# awk filter file
#
# Version : 2005-Mar-04
#   print last exception
#
# Version : 2003-Jul-17
#   handles exception for data2 without any information
#
# Version : 2003-Apr-14
#   change output date / time format to be able to use in excel
#   mm/dd/yyyy hh:mm:ss
#
# Version : 2003-Apr-10
#   add summary for breakoutFields
#
BEGIN{
#
# internal DATE Format  YY : Year      MM : Month    DD : Day
#          Time Format  hh : 24 hours  mm : minutes  ss : seconds
#
#
  t_start="01-01-01 01:01:01"
   t_stop="99-01-31 23:59:00"
# t_start="01-06-06 23:59:59"
#  t_stop="01-06-07 23:59:59"
  b_start="FALSE"
  b_stop="FALSE"
#
# create Array to translate Month Name "Jan" into two digit number "01"
#
  a_MMM["Jan"] = 01
  a_MMM["Feb"] = 02
  a_MMM["Mar"] = 03
  a_MMM["Apr"] = 04
  a_MMM["May"] = 05
  a_MMM["Jun"] = 06
  a_MMM["Jul"] = 07
  a_MMM["Aug"] = 08
  a_MMM["Sep"] = 09
  a_MMM["Oct"] = 10
  a_MMM["Nov"] = 11
  a_MMM["Dec"] = 12
#
# set start conditions
#
  i_lines=0
  s_timestamp="TimeStamp errlog"
  s_task="Task"
  s_category="Category"
  s_severity="Severity"
  s_module="Modul"
  s_alarm="Alarm"
  s_data_1="Data 1 "
  s_data_2="Data 2 "
#
# create headerline
#
  printf ("%-17s,%-11s,%-8s,%-4s,%-7s,%-5s,%-15s,%s\n",
   s_timestamp,s_category,s_severity,s_task,s_module,s_alarm,s_data_1,s_data_2)
#
# exception can be without field "Data 2" reset value
#
  s_data_1=""
  s_data_2=""
}
#
# syncronzise counting lines  AND PRINT ONELINER if not first record
#
/^------/ { i_lines=0
#
#  oneliner as output
#
             if ( b_start == "TRUE" ) {
               printf ("%-17s,%-11s,%-8s,%-4s,%-7s,%-5s,%-15s,%s\n",
                         s_timestamp,s_category,s_severity,s_task,
                         s_module,s_alarm,s_data_1,s_data_2)
               statistik(s_task,s_module,s_alarm)
             }
             if ( b_stop == "TRUE") {
               exit
             }
#
# exception can be without field "Data 1" and "Data 2" reset value
#
             s_data_1=""
             s_data_2=""
#
             next
          }
#
# extract Taskname and Clone
#
/^Task:/ { s_task=substr($2,1,length($2)-1)
           s_clone=$NF
           next
         }
#
# extract Category and Severity
#
/Category:/ { i_space=index($0," ")
              i_comma=index($0,",")
              s_category=substr($0,i_space+1,i_comma-i_space-1)
              s_severity=substr($NF,1,8)
              next
            }
#
# extract Module and Alarm number
#
/Module :/ { s_module=substr($3,1,length($3)-1)
             s_alarm=$NF
             next
           }
#
# extract Data 1
#
/Data 1 :/ { i_colon=index($0,":")  # !! additional space at the end
             i_length=length($0)
             i_start=i_colon+2
             s_data_1=substr($0,i_start,i_length-i_start)
             sub("[,;]",".",s_data_1)
#            print $0 "<" i_start,i_length-i_start  # only for testing
#
# extract information for breakoutFields
#
             if ( match (s_data_1,"breakoutFields") != 0 ) {
               if ( s_data_1 in a_count_protocol ) {
#                print "#  found",s_data_1," in a_count_protocol"
                 ;
               }
               else {
                 i_protocol++
                 a_protocol[i_protocol]=s_data_1
               }
               a_count_protocol[s_data_1]++
             }
             next
           }
#
# extract Data 2 
#
/Data 2 :/ { i_colon=index($0,":")
             i_length=length($0)
             s_data_2=substr($0,i_colon+2,i_length-i_colon+1)
#            print $0 "<" i_colon+2,i_length-i_colon+1  # only for testing
             next
           }
#
# every Line do
#
  {
    i_lines=i_lines+1
#
# getting date and time
#   Sat Jun 21 05:19:17 2003
#   $1  $2  $3 $4       $5
#
    if ( i_lines == 3 ) {
      s_yy=substr($5,3,2)  
      s_MM=a_MMM[$2]
#     s_timestamp=sprintf("%s-%d-%.2d %s", year, month, day, time) 
      s_timestamp=sprintf("%s-%d-%.2d %s", s_yy, s_MM, $3, $4) 
#
#     s_timestamp used compare time to determin start and stop of buffer
#
#     print s_timestamp, t_start, t_stop, b_start, b_stop # for testing
      if ( s_timestamp >= t_start ) {
        b_start="TRUE"
      }
      if ( s_timestamp >= t_stop ) {
        b_stop="TRUE"
      }
#
#     s_timestamp build to be used in excel
#     MM-DD-YY hh:mm:ss will be converted in excel to M/D/YYYY hh:mm
#
      s_timestamp=sprintf("%.2d-%.2d-%.2d %s", s_MM, $3, s_yy, $4) 
    }
    next
  }
#
END{
#
#  print last exception
#
  printf ("%-17s,%-11s,%-8s,%-4s,%-7s,%-5s,%-15s,%s\n",
           s_timestamp,s_category,s_severity,s_task,
           s_module,s_alarm,s_data_1,s_data_2)
  statistik(s_task,s_module,s_alarm)
#
#  Summary for breakout fields
#
  if ( i_protocol > 0 ) {
    print ""
    print "Summary for breakoutField exception"
    print "Number of exception , Protcol"
  }
  for ( i = 1 ; i <= i_protocol ; ++i) {
    print a_count_protocol[a_protocol[i]]," ,  ",a_protocol[i]
  }
}
#
#  statistik not yet implemented
#
function statistik(l_task,l_module,l_alarm) {
  
}
#
