#! /bin/ksh  

# version 1

#  Keeps a rolling backup for critical files

DOW=`/bin/date +%a`   # Mon Tues ...
OUTDIR=/tmp/backup_config_files

# source access7 profile
. /etc/opt/platform7/share/env/p7profile
. /opt/platform7/lbin/profile

if [ ! -d $OUTDIR ]; then mkdir $OUTDIR ; fi


# Current Logs
if [ -f $OUTDIR/local_error_log_1.$DOW ]
  then
       rm $OUTDIR/local_error_log_1.$DOW
       cp /var/opt/platform7/logs/local/local_error_log_1   $OUTDIR/local_error_log_1.$DOW
  else 
       cp /var/opt/platform7/logs/local/local_error_log_1   $OUTDIR/local_error_log_1.$DOW
  fi

if [ -f $OUTDIR/local_error_log_2.$DOW ]
  then
       rm $OUTDIR/local_error_log_2.$DOW
       cp /var/opt/platform7/logs/local/local_error_log_2   $OUTDIR/local_error_log_2.$DOW
  else 
       cp /var/opt/platform7/logs/local/local_error_log_2   $OUTDIR/local_error_log_2.$DOW
  fi


######## LVM configuration
/etc/vgcfgbackup /dev/vg00

DIR=/etc/lvmconf
FILE=$OUTDIR/lvmconf.tar
FFILE=$FILE.$DOW            #final file w/ DOW extension

cd $DIR
tar cf $FILE * 

  if [ -f $FFILE ]
  then
      rm $FFILE
      mv $FILE  $FFILE
  else
      mv $FILE  $FFILE
fi


####### misc files

cp -p /etc/hosts  $OUTDIR/hosts.$DOW
cp -p /etc/group  $OUTDIR/group.$DOW
cp -p /etc/passwd  $OUTDIR/passwd.$DOW
cp -p /etc/ntp.conf $OUTDIR/ntp.conf.$DOW
cp -p /etc/inetd.conf  $OUTDIR/inetd.conf.$DOW
cp -p /etc/exports $OUTDIR/exports.$DOW
cp -p /etc/bootptab $OUTDIR/bootptab.$DOW
/usr/bin/crontab -l > $OUTDIR/crontab.$DOW

## create tarball
cd $OUTDIR;
tar cf backups.$DOW *.$DOW
/usr/contrib/bin/gzip backups.$DOW
mv backups.$DOW.gz /var/tmp
