#################################################
# This script will create the files necessary to send to ASD when ticket data
# is required. 
#  
# This automates the process of collecting log files and system configurations requested by TSD when submitting a ticket.

#  Dependancies: TSD utilities need to be installed
  
# 04-16-2007 - Original script created by Kerry Munson
# 08 june 07 - modified by bmetzger

#################################################

. /opt/platform7/lbin/p7profile

WORKDIR=/home/Agilent/tsd/utils
finaldir=${WORKDIR}/finaldir/

systemname=`cat ${WORKDIR}/.customer`
junkfile=/tmp/junk

function stage1 {
   echo "Started Task 1 - Dump the configuration of the system"
   cd ${WORKDIR}/backup-a7
   time  ./backup-a7.ksh    > ${junkfile} 2>&1
   duration=`grep  real ${junkfile} | awk '{printf ("%s", $2)}'` 
   mv ${WORKDIR}/data/config-$systemname.tar.gz  $finaldir
   echo "Completed Task 1 in $duration Minutes " 
}  # stage1

function stage2 {
    echo "Started Task 2 - Get swlisting from every box in the system"
    cd ${WORKDIR}/swlist
    time ./getswlist.ksh  > ${junkfile} 2>&1
    duration=`grep  real ${junkfile} | awk '{printf ("%s", $2)}'` 

    mv ${WORKDIR}/data/swlist-$systemname.tar.gz $finaldir
    mv ${WORKDIR}/data/swlist-$systemname.txt.gz $finaldir
   echo "Completed Task 2 in $duration Minutes " 
} #stage2

function stage3 {
    echo "Started Task 3 - Dump Central Server Error and Alarm Log files"       

    if [ -f ${finaldir}/TM_* ]; then rm ${finaldir}/TM_* ; fi
    
    cd ${WORKDIR}/a7log
    time ./collectfiles    > ${junkfile}  2>&1 
    duration=`grep  real ${junkfile} | awk '{printf ("%s", $2)}'` 
    mv ${WORKDIR}/a7log/$systemname.tar.gz $finaldir
    mv ${WORKDIR}/a7log/TM*   $finaldir
   echo "Completed Task 3 in $duration Minutes " 
} #stage3

function stage4 {
    echo "Started Task 4 - Collect local error log files from all other boxes"
#    echo "Started Task 4 - Collect local error log files from all other boxes (except HSPPs)"
    cd ${WORKDIR}/a7log

    time ./loop -s -w -d -p  > ${junkfile}  2>&1   #HSPPs take a long time.  writes to a7log dir

    duration=`grep  real ${junkfile} | awk '{printf ("%s", $2)}'` 
    mv ${WORKDIR}/a7log/*.tar.gz   $finaldir
   echo "Completed Task 4 in $duration Minutes " 
} #stage4

function stage5 {
    remotebox="m7sstra1"

    echo "Started Task 5 - Tar up and copy all logfiles"
    cd ${WORKDIR}
    tar cf ${WORKDIR}/$ticketnumber.systemlogs.tar  $finaldir
    gzip $ticketnumber.systemlogs.tar

    remsh ${remotebox} " if [ ! -d /tmp/tskc ]; then mkdir /tmp/tskc ; fi"
    rcp $ticketnumber*  ${remotebox}:/tmp/tskc

    # clean up after yourself
    rm  $ticketnumber* 
    if [ -f ${finaldir}/* ]; then rm ${finaldir}/* ; fi
    echo "Completed Task 5 " 
    echo ""
    echo " Final tar file for TSKC is located at:  ${remotebox}:/tmp/tskc/$ticketnumber.systemlogs.tar.gz"
    echo ""

} #stage5

function format {
  echo ""
  echo "---------------------------------"

} # format

###### start of Main

if [ ! -d $finaldir ]; then mkdir $finaldir ; fi
if [ -f ${finaldir}/* ]; then rm ${finaldir}/* ; fi

clear
echo
read ticketnumber?'TSKC Ticket Number? '

echo
echo "  Compiling log files for ticket $ticketnumber.  You Might Want to Grab a Cup of Coffee.  This could take up to 50 Minutes"
echo "  (to view status and activity as logs are being collected, tail -f ${junkfile}  )"
echo ""

stage1
echo ""

stage2
echo ""

stage3    
echo ""

stage4
echo ""

stage5
echo ""
