#!/bin/ksh

. /opt/platform7/lbin/p7profile
export PATH=$PATH:/opt/platform7/lbin

WORKDIR=/h/bmetzger/s   # local directories
TMPDIR=${WORKDIR}/tmp/ssh

HPUX_list="m7sstra1 m7sstra2 m7ossca1 m7ossca2 a7svrlab "

TMPKEY=${WORKDIR}/tmp_new_keys
NEWKEY=${WORKDIR}/new_authorized_keys2


if [ ! -d ${TMPDIR} ]; then mkdir ${TMPDIR} ; fi
if [ -f ${TMPDIR}/*.pub ]; then rm ${TMPDIR}/*.pub ; fi
if [ -f ${TMPKEY} ]; then rm ${TMPKEY} ; fi
if [ -f ${NEWKEY} ]; then rm ${NEWKEY} ; fi

# Create and gather .pub key from all boxes
clear
echo "gathering .pub files"
for f in ${HPUX_list}
do
    if ping $f -n2 2>&1 >/dev/null
    then
        print $f
        remsh $f 'rm .ssh/id*; /usr/bin/ssh-keygen -q -t rsa  -P "" -f ~/.ssh/id_rsa'
        rcp $f:.ssh/id_rsa.pub  ${TMPDIR}/$f.pub
    else
        print skipping $f: not pingable
        print
    fi
done

# One off for lenexa lab
# stopped here
#  remsh a7svrlab 'remsh a7lnxsvr rm .ssh/id*; /usr/bin/ssh-keygen -q -t rsa  -P "" -f .ssh/id_rsa'
#  remsh a7svrlab "rcp a7lnxsvr:.ssh/id_rsa.pub /tmp/wm/a7lnxsvr.pub"
#  rcp a7svrlab:/tmp/wm/*.pub  ${TMPDIR}/$f.pub

# Create new single key
# files for OSSinstall and CS
cat /.ssh/authorized_keys2 >> ${TMPKEY}
cat /.ssh/id_dsa.pub >> ${TMPKEY}

cd ${TMPDIR}
for j in `ls *.pub`
do
   cat $j >> ${TMPKEY}
done

sort -u ${TMPKEY} >  ${NEWKEY} 

# Copy out new global key
echo 
echo "pushing new global keys"
for k in ${HPUX_list}
do
    if ping $k -n2 2>&1 >/dev/null
    then
        print $k
        rcp ${NEWKEY}  $k:.ssh/authorized_keys
        rcp /root/.ssh/known_hosts  $k:.ssh/
        remsh $k "chmod 750 /root"
    else
        print skipping $k: not pingable
        print
    fi
done

# For CS
cp ${NEWKEY}  /.ssh/authorized_keys
chmod 750 /root

# cleanup
rm  ${TMPDIR}/*.pub  
if [ -f ${TMPKEY} ]; then rm ${TMPKEY} ; fi
if [ -f ${NEWKEY} ]; then rm ${NEWKEY} ; fi

echo
echo
