#!/bin/sh

# Checks to see which entries in commsconfig are not in /etc/hosts
# (CommsConfig needs to be supplied).

. /opt/platform7/lbin/p7profile


HOSTS_FILE=/etc/hosts
#HOSTS_FILE=hosts.new
COMMS_FILE=wm.comms

DOW=`/bin/date +%m%d%Y"`
WORKDIR=/h/bmetzger/s/etr
OUTDIR=/h/bmetzger/s/etr/

OUTFILE=${WORKDIR}/audit.out
IP_LIST=${WORKDIR}/ip_list
junk=${WORKDIR}/junk
PARSED_COMMS_FILE=${WORKDIR}/parsed_comms_file

 if [ -f ${junk} ]; then rm ${junk} ; fi
 if [ -f ${PARSED_COMMS_FILE} ]; then rm ${PARSED_COMMS_FILE} ; fi
 if [ -f ${OUTFILE} ]; then rm ${OUTFILE} ; fi
 if [ -f ${IP_LIST} ]; then rm ${IP_LIST} ; fi
 if [ -f ${COMMS_FILE} ]; then rm ${COMMS_FILE} ; fi

 if [ ! -f ${COMMS_FILE} ]; then p7updatecomms -d ${COMMS_FILE} ; fi

echo " "
echo "using $HOSTS_FILE and $COMMS_FILE\n"

grep \: $COMMS_FILE | grep -v \#  > ${PARSED_COMMS_FILE}   #weeds out blank, 1024, and #
#cat $COMMS_FILE | awk '{if ($0 ~ /:/ && $0 !~ /LABEL/)}  {print $0}'  > ${PARSED_COMMS_FILE}   #weeds out blank, 1024, and #

# create just list of sorted IP
for comms_line in `cat ${PARSED_COMMS_FILE}`
do
   echo $comms_line | awk 'BEGIN {FS=":"} {print $3}'  >> junk 
done

sort junk > ${IP_LIST}

for IP in `cat ${IP_LIST}`
do
   grep ${IP}  ${PARSED_COMMS_FILE} |read comms_entry
   grep ${IP}  ${HOSTS_FILE} |read hosts_entry
   length=${#hosts_entry}     # zero if there is no hosts entry

   if [[ $length != 0 ]] 
   then  
         print "$comms_entry    ${hosts_entry} " >> ${OUTFILE}
   else
         print "$comms_entry    no_match " >> ${OUTFILE} 
   fi
done


parsed_comms_entries=`wc -l ${PARSED_COMMS_FILE} | awk '{print $1}' `
no_match=`grep no_match ${OUTFILE} | wc -l | awk '{print $1}' `
cc_entries=`grep -E ' cc$' ${HOSTS_FILE} | wc -l | awk '{print $1}' `

print "Total comms entries = $parsed_comms_entries"
print "No_match entries = $no_match"
print "cc entries in hosts file = $cc_entries"
echo " "

