#!/bin/ksh

TMPDIR=/tmp/vnc
JUNKFILE1="${TMPDIR}/vnc.junk1"

if [ ! -d ${TMPDIR} ]; then mkdir ${TMPDIR} ; fi
if [ -f ${JUNKFILE1} ]; then rm ${JUNKFILE1}; fi

PORTS="1 2 3 4 5 6 7 8 9 10"

function check_wst_load {
# Find VNC loading

   if ping m7ossca1 -n2 2>&1 >/dev/null
      then
          ca1_load=`remsh m7ossca1 ps -ef|grep Xvnc | grep -v grep | wc -l | awk '{print $1}`
      else
          ca1_load=20  # high count so it won't be used
      fi

   if ping m7ossca2 -n2 2>&1 >/dev/null
      then
          ca2_load=`remsh m7ossca2 ps -ef|grep Xvnc | grep -v grep | wc -l | awk '{print $1}`
      else
          ca2_load=20  # high count so it won't be used
      fi
  echo
  echo "Total number of existing VNC Sessions:  m7ossca1:${ca1_load}   m7ossca2:${ca2_load}\n"

  if ((${ca1_load}<=${ca2_load}))
  then
       REMOTE_WST="m7ossca1" 
       DMZ_HOST=`hostname`
  else
        REMOTE_WST="m7ossca2"        
        DMZ_HOST=`hostname`
  fi
} #check_wst_load 

function check_for_existing_sessions {
# check for existing VNC session(s) already running

   for host in m7ossca1 m7ossca2
   do
      if ping $host -n2 2>&1 >/dev/null
      then
            integer session_count=0
            create_new_vnc="yes"       # default

            remsh ${host} "ps -ef|grep Xvnc | grep -i ${VNC_SESSION_NAME} | grep -v grep | sed -e s/://g " > ${JUNKFILE1}
            session_count=`wc -l ${JUNKFILE1} | awk '{print $1}'` 

            if (( ${session_count}>0 ))
            then
                 current_session_number=`cat ${JUNKFILE1} | awk '{print $9}'`
                 echo "You already have ${session_count} VNC sessions running on ${host}\n"

                 print "Would you like to: "
                 print "1) Create tunnel to use existing VNC session :${current_session_number} on ${host}."
                 print "2) Kill existing session :${current_session_number} on ${host}"
                 print "3) Kill existing session :${current_session_number} on ${host}, and start a new session."
                 print "4) Start a 2nd VNC session and tunnel."

                 print -n "\nChoice: "; read reply
                 case ${reply} in
                      1)  print "Create new tunnel for existing :${current_session_number} on ${host}" 
                          create_new_vnc="no" 
                          existing_vnc_host=${host} ;;

                      2)  # kill existing sesson and bail
                           remsh ${host} "vncserver -kill :${current_session_number}" 
                           exit 0 ;;

                      3)  # kill existing session, and let script create new tunnel & vnc session as normal
                          print "killing :${current_session_number}" 
                          remsh ${host} "vncserver -kill :${current_session_number}" 
                          create_new_vnc="yes" ;;

                      4)  # Create 2nd vnc session and tunnel 
                          VNC_SESSION_NAME=${VNC_SESSION_NAME}_2
                          create_new_vnc="yes" ;;

                      *) print "Okay.  Do nothing."
                         exit 0 ;;
                 esac
            fi
      else
            continue
      fi
   done
} #check_for_existing_sessions 

function analyze_remote_wst {
# find 1st unused port on REMOTE_WST
    # ports already in use
    #  5901
    #  5902

   remsh ${REMOTE_WST}  ps -aex  |grep rfbport | grep -v grep |  awk '{print $(NF-1) }' | sort|  sed -e s/590//g > ${JUNKFILE1}

    for port in ${PORTS}  # look 4 1st unused port
    do
         count=`grep ${port} ${JUNKFILE1} | wc -l | awk '{print $1}'`
         if (( ${count} > 0 ))   # port in use.  Check next port
         then
               continue
         else
               NEXT_VNC="${port}"  #  This is next avail port
               REMOTE_PORT="590${port}"  #  This is next avail port
               break
         fi
    done 

} # analyze_remote_wst 

function analyze_dmz_host { 
# Get next unused port on gateway box (DMZ_HOST)

    # capture ports already in use on
    netstat -a  |  grep *.59 | awk '{print $4}' | sort|  sed -e s/\*\.590// > ${JUNKFILE1}
    #  *.5902 

     # find 1st unused port on DMZ_HOST
     for port in ${PORTS}  # look 4 1st unused port
     do
         count=`grep ${port} ${JUNKFILE1} | wc -l | awk '{print $1}'`
         if (( ${count} > 0 ))   # port in use.  Check next port
         then
               continue
         else
               DMZ_PORT="590${port}"  #  This is next avail port
               PEECEE_PORT=${port}    # for localhost:xx
               break
         fi
    done 
} #analyze_dmz_host 

function create_session {
# Using variables collected, create VNC session, and SSH tunnel

#      echo "remote_wst: ${REMOTE_WST}"  
#      echo "next_vnc: ${NEXT_VNC}"  
#      echo "remote_port:  ${REMOTE_PORT}"
#      echo
#      echo "dmz_host: ${DMZ_HOST}"      
#      echo "dmz_port: ${DMZ_PORT}"      
#      echo "peecee_port: ${PEECEE_PORT}"      
#      echo "vnc_session_name: ${VNC_SESSION_NAME}"
#
      # Start VNC session using next available port or
      # Create tunnel to existing vnc session

      if [[ "${create_new_vnc}" = "yes" ]] 
      then
           REMOTE_WST_IP=`grep ${REMOTE_WST} /etc/hosts | cut -d" " -f 1`

           echo "Starting VNC session :${NEXT_VNC} on ${REMOTE_WST} for ${VNC_SESSION_NAME}"
           remsh ${REMOTE_WST} "vncserver :${NEXT_VNC} -name '${VNC_SESSION_NAME} on ${REMOTE_WST} - ${REMOTE_WST_IP}:${NEXT_VNC}'   > /dev/null 2>&1  "
      fi
 
      if [[ "${create_new_vnc}" = "no" ]] 
      then
           # set variables for existing VNC session
           NEXT_VNC=${current_session_number}   # connect to existing VNC session
           REMOTE_WST=${existing_vnc_host}      # host on which existing vnc session is running
           REMOTE_PORT=590${current_session_number}
      fi  
     

      # Start SSH tunnel and listen for VNC on REMOTE end
      echo "Creating ssh tunnel between ${DMZ_HOST} and ${REMOTE_WST} "
      echo
      echo "To access VNC session :${NEXT_VNC} use   localhost:${PEECEE_PORT} "      
      echo
      echo
      ssh -qgAX  -L ${DMZ_PORT}:${REMOTE_WST}:${REMOTE_PORT} -R ${REMOTE_PORT}:${DMZ_HOST}:${DMZ_PORT} root@${REMOTE_WST} 

#      ssh -gAX -L 5904:m7ossca2:5922  -R 5922:m7sstra1:5904   root@m7ossca2

} #create_session 


function kill_vnc_session {
# run after SSH tunnel is taken down
# Kill vncsession when done

    remsh  ${REMOTE_WST} "if [ -f  .vnc/${REMOTE_WST}:${NEXT_VNC}.pid ]; then vncserver -kill :${NEXT_VNC}; fi"

} # kill_vnc_session 



#############################
# runit
#############################

if (($# == 0))
then
     echo "Useage:  script [your lastname]"
     exit 1
else
   for f in $*
   do
      VNC_SESSION_NAME=${f}
      check_wst_load ;
      check_for_existing_sessions;
      analyze_remote_wst;
      analyze_dmz_host;
      create_session;
      kill_vnc_session 
   done

    if [ -f ${JUNKFILE1} ]; then rm ${JUNKFILE1}; fi

fi

###################
### Notes 
###################

# error of "# channel 2: open failed: connect failed: Connection refused "
# indicates no vnc :xx session is running

#remote_bind_address=
# Port listens for incoming  connections from VNC viewers
# 5900 + display #

#ports already in use
# ps -aex  |grep rfbport | grep -v grep | awk '{print $(NF-1) }'


## todo:  
# 1) if a window is killed, vnc is still running. Need to recreatd local port so VNC session can be viewed.
# 2) keep IP in title bar (in addition to name) so know  where to export display to.
