#!/usr/bin/ksh

. /etc/opt/platform7/share/env/p7profile
. /opt/platform7/lbin/profile

export PATH=$PATH:/opt/platform7/lbin/:.
WORKDIR=/h/bmetzger/s

JUNKFILE0=${WORKDIR}/getmac.junkfile0
JUNKFILE1=${WORKDIR}/getmac.junkfile1
JUNKFILE2=${WORKDIR}/getmac.junkfile2
JUNKFILE3=${WORKDIR}/getmac.junkfile3

STATUS_SUMMARY=${WORKDIR}/getmac.status.summary   #database of bpp status info (need to be able to grep on MAC)
RESULTSFILE=${WORKDIR}/getmac.results             #parsed results

if [ -f ${JUNKFILE0} ]; then rm ${JUNKFILE0}; fi
if [ -f ${JUNKFILE1} ]; then rm ${JUNKFILE1}; fi
if [ -f ${JUNKFILE2} ]; then rm ${JUNKFILE2}; fi
if [ -f ${JUNKFILE3} ]; then rm ${JUNKFILE3}; fi

if [ -f ${STATUS_SUMMARY} ]; then rm ${STATUS_SUMMARY}; fi

#create the header
print "Hostname  Component    IP     MAC  S/N   Model   CPU_Speed  RAM  lan_Speed   Duplex RTM_type" > ${RESULTSFILE}

for site in `list_processors -s `   # EXCEPTION
#for site in m014
do
#echo "site ${site}"
    for bpp_hostname in `list_processors -b |grep ${site} `   # EXCEPTION
    do
echo "bpp: ${bpp_hostname}"
#        remsh ${site} "remsh ${bpp_hostname} 'level 1' "      > /dev/null 2&>1
#        remsh ${site} "remsh ${bpp_hostname} 'forward 1' "    > /dev/null 2&>1
#        remsh ${site} "remsh ${bpp_hostname} 'enableTelnet' " > /dev/null 2&>1

        remsh ${site}  "remsh $bpp_hostname 'status' " > ${JUNKFILE0}

        bpp_model=`grep "bpp model"  ${JUNKFILE0} | awk '{printf ("%s_%s",$4, $5)}"`
        cpu_speed=`grep "cpu type"  ${JUNKFILE0} | awk '{printf ("%s",$7)}"`
        mac=`grep "mac address" ${JUNKFILE0} | sed -e s/://g | awk '{print $NF}'`
        ip=`grep "internet addr" ${JUNKFILE0} | awk '{print $NF}'`
        speed=`grep "link Up" ${JUNKFILE0} |tail -1 | sed -e s/,//g |awk '{print $8}'`
        duplex=`grep "link Up" ${JUNKFILE0} | tail -1 |sed -e s/]//g |awk '{print $NF}'`
        memory=`grep "total memory" ${JUNKFILE0} |awk '{print $4}'`
        rtm_type=`grep "rtm type"  ${JUNKFILE0} |sed -e 's/[(|)]//g' |  awk '{printf ("%s_%s_%s_%s_%s_%s",$4, $5, $6, $7,$8, $9)}"`

        echo "$bpp_hostname $ip  $mac  $bpp_model  $cpu_speed  $memory  $speed  $duplex $rtm_type" >> ${STATUS_SUMMARY} 
    done  # collecting all bpp info for a site

    for amc in `list_processors -a |grep ${site} `   #EXCEPTION
    do
echo "amc: ${amc}"
         remsh ${site} -n "remsh  ${amc} smc-cmd -e hardwarefittedDeviceSerialNumber" | sed -e 's/[\.|=]/ /g' | awk '{printf ("%s %s %s %s\n",$2, $3, $4, $5) }' > ${JUNKFILE1}
         remsh ${site} -n "remsh  ${amc} smc-cmd -e hardwarefittedDeviceDriverName"   | sed -e 's/[\.|=]/ /g' | awk '{printf ("%s %s_%s_%s\n",$2, $3, $4, $5) }' > ${JUNKFILE2}
      #   remsh ${site}  -n "remsh  '${amc} smc-cmd -e hardwarefittedDeviceDriverName"   | sed -e 's/[\.|=]/ /g' | awk '{printf ("%s %s %s %s\n",$2, $3, $4, $5) }' > ${JUNKFILE2}
         remsh  ${site} -n "remsh  ${amc} smc-cmd -e hardwarefittedDeviceMacAddress "   | sed -e 's/[\.|=]/ /g' | sed -e 's/://g' | awk '{printf ("%s %s %s %s\n",$2, $3, $4, $5) }' > ${JUNKFILE3}

        cat ${JUNKFILE1} | awk 'NF == 2 { print $0 } ; NF == 1 {printf ("%s NA\n",$1)} ' > xx; mv xx ${JUNKFILE1} # replace non-existent SN with NA
        cat ${JUNKFILE3} | awk 'NF == 2 { print $0 } ; NF == 1 {printf ("%s NA\n",$1)} ' > xx; mv xx  ${JUNKFILE3} # replace non-existent SN with NA

        count=0
        while ((count <=20))
        do 
            SN=`grep "^$count " ${JUNKFILE1} | awk '{printf ("%s", $2)}'`
            card_type=`grep "^$count " ${JUNKFILE2} | awk '{printf ("%s",$2) }'`
          # card_type=`grep "^$count " ${JUNKFILE2} | awk '{printf ("%s %s %s %s",$2, $3, $4, $5) }'`
            MAC=`grep "^$count " ${JUNKFILE3} | awk '{printf ("%s",$2) }'`
          # echo "type: ${card_type}"
 #                                                                                         hostname,               , IP, MAC,        ,type, speed , ram, lan, duplex, rtm_type
            grep -i ${MAC} ${STATUS_SUMMARY} | awk '{printf ("%s %s %s %s %s %s %s %s %s %s %s\n", $1, "'$card_type'", $2, $3, "'$SN'",$4,    $5,    $6,  $7,  $8, $9 )} ' >> ${RESULTSFILE}

            ((count = count + 1))
       done # counting down list in each amc
     done # done with all amc at a site

     if [ -f ${JUNKFILE0} ]; then rm ${JUNKFILE0}; fi
     if [ -f ${JUNKFILE1} ]; then rm ${JUNKFILE1}; fi
     if [ -f ${JUNKFILE2} ]; then rm ${JUNKFILE2}; fi
     if [ -f ${JUNKFILE3} ]; then rm ${JUNKFILE3}; fi

done # processing the list of sites

rcp  ${RESULTSFILE} m7sstra1:/tmp/wm
echo " ${RESULTSFILE} file copied"
