#!/usr/bin/sh
get_yn()
{
	print "Please enter yes or no: \c"
	read answer
	print $answer|cut -c 1 | tr [A-Z] [a-z] | read answer
	if [[ "$answer" = "" || "$answer" = n ]]
	then
		return 1
	else
		return 0 
	fi
}
. /opt/platform7/lbin/p7profile
if [[ $1 = "" ]]
then 
	print '\nChecking for config manager processes'
	for i in $(/opt/platform7/lbin/list_processors -w)
	do
		process=$(remsh $i ps -ef | grep 'p7cm$'|grep -v grep)
		if [[ "$process" != "" ]] 
		then
			location=$i
			break
		fi
	done	
else
	location="$1"
	process=$(remsh $location ps -ef | grep 'p7cm$' |grep -v grep)
fi
if [[ "$process" != "" ]]
then
	print 'Config manager read/write process found' 
	print $process | cut -f 1 -d' ' | read cmuser
	print $process | tr ' ' ' ' | cut -f 2 -d' ' | read pid
	print "\nLocation: $location, User: $cmuser"
	print "\nAre you SURE you want me to kill the config manager session?\n\n"
	if get_yn
	then
		remsh $location kill $pid
		/home/a7users/tskc/scripts/check_config_mgr.sh
	fi
else
	print 'No config manager process found.'
fi
