#!/bin/ksh

#ver 5.   9 april


. /opt/platform7/lbin/profile

export TIME=`date "+%b.%d.%y.%H.%M"`
export JUNK=${PWD}/junk

WORKDIR=/h/bmetzger/s/mirror
TMPDIR=${WORKDIR}/tmp                   # location of formated (.final) and raw data from every machine

REMOTE_SCRIPT=mirror_remote.sh   # don't add $WORKDIR - path is  passed to rsp

MIRROR_REPORT=${WORK_DIR}/mirror.results
MIRROR_ERRORS=${WORK_DIR}/mirror.errors

QUORUM_REPORT=${WORK_DIR}/quorum.results
QUORUM_ERRORS=${WORK_DIR}/quorum.errors

if [ ! -d ${TMPDIR} ]; then mkdir ${TMPDIR}; fi
if [ -f ${TMPDIR}/* ]; then rm ${TMPDIR}/* ; fi

function process_mirror_data
{  # After remote script is run on all machines, the results
   # need to be compiled into a single report

   if [ -f $MIRROR_REPORT ]; then rm $MIRROR_REPORT ; fi
   if [ -f $MIRROR_ERRORS ]; then rm $MIRROR_ERRORS ; fi

   # Set up header for new report files
   echo "Host                                  Mirrored"  > $MIRROR_REPORT > $MIRROR_ERRORS
   echo "name   Volume Name         Status      Copies " >> $MIRROR_REPORT >> $MIRROR_ERRORS
   echo "-----  ------------   --------------- --------" >> $MIRROR_REPORT >> $MIRROR_ERRORS


  # Take raw data collected and put it into single file with headers
   for raw_data in `ls $TMPDIR/*.raw`
   do
      awk '{ printf ("%5s  %12s  %16s  %3s \n", $1, $2, $3, $4) } ' <  $raw_data >> $MIRROR_REPORT
      awk ' /unavailable/ { printf ("%5s  %12s  %16s  %3s \n", $1, $2, $3, $4) }
            /stale/       { printf ("%5s  %12s  %16s  %3s \n", $1, $2, $3, $4) }
            {if ($NF == 0)
               { printf ("%5s  %12s  %16s  %3s \n", $1, $2, $3, $4) }
            }
          '<  $raw_data >> $MIRROR_ERRORS
   done

  # just notification if there are no errors
  num_errors=`wc -l $MIRROR_ERRORS |awk '{print $1}` 
   if (( $num_errors <= 3 ))
   then
        echo "  There are no mirror errors" >> $MIRROR_ERRORS
#        echo "  Full report can be found at:" >> $MIRROR_ERRORS
#        echo "  $MIRROR_REPORT"  >> $MIRROR_ERRORS
#        echo " " >> $MIRROR_ERRORS
   fi

}  # end of  process_mirror_data function

function process_quorum_data {

   if [ -f $QUORUM_REPORT ]; then rm $QUORUM_REPORT ; fi
   if [ -f $QUORUM_ERRORS ]; then rm $QUORUM_ERRORS ; fi

   # Set up header for new report files
   echo "Host                                                 "    > $QUORUM_REPORT  > $QUORUM_ERRORS
   echo "name     Raw Disk          Quorum  Status (want -lq) "   >> $QUORUM_REPORT >> $QUORUM_ERRORS
   echo "-----  ---------------   ----------------------------"   >> $QUORUM_REPORT >> $QUORUM_ERRORS

   for file in `ls $TMPDIR/*quorum*`
   do
         grep dsk  $file >> $QUORUM_REPORT
   done

   grep -v lq $QUORUM_REPORT >> $QUORUM_ERRORS

  # just notification if there are no errors
  num_errors=`wc -l $QUORUM_ERRORS |awk '{print $1}` 
   if (( $num_errors <= 3 ))
   then
        echo "  There are no quorum errors" >> $QUORUM_ERRORS
   fi

} # process_quorum_data

#----------------------------------------------------------------
#procs="`/opt/platform7/lbin/list_processors -sw` m7server"
#procs="`/opt/platform7/lbin/list_processors -s` `cat /etc/opt/p7install/servers.conf`"
procs="m7ossca8"

cd ${WORKDIR}

for node in $procs
do
   if ping $node -n2 2>&1 >/dev/null
   then
 
        print -n  "."
        remsh $node -n "if [ ! -d /tmp/wm ]; then mkdir /tmp/wm ; fi"
        remsh $node -n "if [ ! -d /tmp/wm/tmp ]; then mkdir /tmp/wm/tmp; fi"

        rcp ${REMOTE_SCRIPT} $node:/tmp/wm
        remsh $node  -n "cd /tmp/wm/;  /tmp/wm/${REMOTE_SCRIPT} > /tmp/wm/mirror.errors 2>&1"
        rcp $node:/tmp/wm/*.mirror.out $TMPDIR 
        rcp $node:/tmp/wm/*.mirror.raw $TMPDIR
        rcp $node:/tmp/wm/*quorum*  $TMPDIR   
        remsh $node  -n "cd /tmp/wm/; rm $REMOTE_SCRIPT ;rm *.out ;rm *.raw ; rm junk "
    else
        print "$node unpingable"
         print
    fi
done

echo 
process_mirror_data  # compile the results from all machines
process_quorum_data  # compile the results from all machines

echo
cat $MIRROR_ERRORS
echo

echo
cat  ${QUORUM_ERRORS} 
echo
