#!/bin/ksh

# 0,10,20,30,40,50  * * * * /tmp/wm/nettl.logging.sh  > /tmp/wm/nettl_log.cron 2>&1

export PATH=$PATH:/usr/sbin

LOGDIR=/var/tmp/wm

if [ ! -d ${LOGDIR} ]; then mkdir ${LOGDIR} ; fi

nettl -traceoff -e all    # shut all logging off
nettl -start 2>/dev/null  # problem noted trying to start(initialize) while already runnilng


if [ -f ${LOGDIR}/*.gz ]; then rm ${LOGDIR}/*.gz ; fi

if [ -f ${LOGDIR}/*.TRC0 ]; then mv  ${LOGDIR}/*.TRC0  ${LOGDIR}/`hostname`.log0; fi
if [ -f ${LOGDIR}/*.TRC1 ]; then mv  ${LOGDIR}/*.TRC1  ${LOGDIR}/`hostname`.log1; fi

# restart trace
nettl -start
nettl -traceon 0x30000000  -entity NS_LS_IP -tracemax 3000 -file /var/tmp/wm/`hostname` 2>/dev/null

if [ -f ${LOGDIR}/*.log0 ]; then /usr/contrib/bin/gzip ${LOGDIR}/*.log0 ; fi
if [ -f ${LOGDIR}/*.log1 ]; then /usr/contrib/bin/gzip ${LOGDIR}/*.log1 ; fi


