#!/usr/bin/perl 

# purpose:
#  ref DB used is sprint supplied arch file for low speed
#  Verify nodes section
#    1) ensure all CLLIs found in DB exist
#    2) ensure all CLLI node type matches DB DEV 
#    3) ensure all CLLI point codes match DB (watch for non-leading zero) 

# verify the link type (A, B,C) matches the DB

# customize:
#  - location of ETR
#  - location of DB
#  - specify monitored end as FTW_ISTP or STK_ISTP 

use English;
use Carp;
use Cwd;
use DBI;
use Net::Ping;
use File::Basename;
use File::Path;
use File::Glob;
use File::Copy;


# db
#   CLLI        Dev     PointCode   Linkset SLC    Link#   Type   Ccage   BPP
#  NYCMNYZRDS4  SSP     253-064-044 LS6048   SLC0    48      A       2     3
#

# ETR
#[linkset]
#kkSS7 AKR314 NYC706 A LS6048 1

#[link]
#Q703:NxDS0 0 LowSpeed AKR314-NYC706/00 AKR-LS6048/0-048 acceSS7 ENABLED \
#  CHANA PCROFF L T1 56 9 \
#  CHANB PCROFF L T1 56 9
#
#[interface]
#NETELEM:J6739A 7 \
#  CHANA 2 8 SSG 48 6144 1 "" 1 0 "" \
#  CHANB 2 8 SSG 48 6144 1 "" 1 0 ""
#
#[monitoring]
#CT BOTH 2 3
#ILM BOTH 2 3
#LS BOTH 2 3
#PA BOTH 2 3
#Stats BOTH 2 3
#TM BOTH 2 3
#p7ctf BOTH 2 3

# configurable
my $ETR = "/tmp/wm/wm.etr";
my $OUT = "/h/bmetzger/s/p/outfile";
my $DB = "/h/bmetzger/s/p/db_hs";
#my $DB = "/h/bmetzger/s/p/junk";


  # See if linkset from DB is found in ETR
  #
  open (DB, "<$DB") or croak "Can't open DB for read: $!\n";
  while (my $dbline = <DB>) {
      chomp $dbline;
      next if $dbline =~ /^$/;   #blank

      ($dbName, $dbDevice, $dbPC, $dbLinkSet, $junk) = split(/\s+/,$dbline);

      open (OUT, ">>$OUT") or croak "Can't open results for write: $!\n";
      open (ETR, "<$ETR") or croak "Can't open etr for read: $!\n";
      while (<ETR>) {

           chomp;
           if (/^\[nodes\]$/ ... / \#/) {  #nodes range
                 next if ($_ =~ /^\#/); 
                 next if ($_ =~ /^$/); 
                 ($etrDevice, $etrName, $junk, $etrAltName, $junk1, $junk2, $junk3, $etrClass, $etrPC, $junk4) = split(/\s+/,$_);

                 # If Name matches, check DeviceType and PointCode.  
                 # If Name is missing, no other checks needed.
              
                 if ($etrName =~ /$dbName/){  #Name is correct.  
                     if ($etrDevice !~ /$dbDevice/) {  # SSP/MSC ....
                           print "$dbName $etrDevice should be $dbDevice\n";
                     }

#                     if ($etrPC !~ /$dbPC/) {  # expect to see lots of missing leading zeros's 
#                           print "$dbName $etrPC should be $dbPC\n";
#                     }

#                     print "$dbName matches $etrName \n";
                     last; 
                  }
                 if ($_ =~ /^ \#/){
#                     print OUT "$dbName not found\n";
#                     print  "$dbName not found\n";
                     next;
                  }
           }
      } 
      close (OUT);
      close (ETR);
  }
  close (DB);
