#! /usr/bin/ksh

# source access7 profile
. /etc/opt/platform7/share/env/p7profile
. /opt/platform7/lbin/profile

WORKDIR=/h/bmetzger/s
TMPDIR=${WORKDIR}/tmp/ping
OUTDIR=${WORKDIR}/keep

CS_list=`cat /etc/opt/p7install/servers.conf`
RSP_list=`/opt/platform7/lbin/list_processors -s |sort`
WST_list=`/opt/platform7/lbin/list_processors -w |sort `
BPP_list=`/opt/platform7/lbin/list_processors -b | sort `

JUNK1=${TMPDIR}/ping.junk1
LOCAL_PROBLEMS=${OUTDIR}/ping.problems.csv

today=`date '+%d%b'`    # 30Apr

if [ ! -d ${WORKDIR}/tmp ]; then mkdir ${WORKDIR}/tmp ; fi
if [ ! -d ${TMPDIR} ]; then mkdir ${TMPDIR} ; fi
if [ ! -d ${OUTDIR} ]; then mkdir ${OUTDIR} ; fi

bad_count=0
ping_time_threshold=80
packet_loss_threshold=5

localtime=`date '+%d%b_%H:%M'`

if [ -f ${JUNK1} ]; then rm ${JUNK1}; fi

# Header
if [ ! -f ${LOCAL_PROBLEMS} ]
then
     print " hostname,  time, ping_time(ms),  packet_loss%,"  > ${LOCAL_PROBLEMS}
     echo  "--------------, ---------------,  ------------,  ------------," >> ${LOCAL_PROBLEMS}
     chmod 777  ${LOCAL_PROBLEMS}
fi

for f in ${RSP_list} ${WST_list} ${CS_list} 
#for f in  ${CS_list}
do
    if ping $f -n2 2>&1 >/dev/null

    then
         print  "$f"
          ping $f -n 5 -m 2 | tail -2   > ${JUNK1}

          packet_loss="`grep loss ${JUNK1} | sed -e 's/\%/ /g' | awk '{print $7}'`"
          avg_ping_time="`grep round ${JUNK1} | sed -e 's/\// /g' | awk '{print $8}'`"

          if ((${packet_loss} > ${packet_loss_threshold}))  || ((${avg_ping_time} > ${ping_time_threshold}))  #problem
          then
               date | awk '{printf ("%s, %s, %s,  %s\n", "'$f'", "'$localtime'", "'$avg_ping_time'", "'$packet_loss'") }' >> ${LOCAL_PROBLEMS}
          fi
    else
          date | awk '{printf ("%s, %s, not_pingable\n", "'$f'", "'$localtime'") }' >> ${LOCAL_PROBLEMS}
    fi
done

# bad_count=`wc -l ${LOCAL_PROBLEMS} | awk '{print $1}'`

# if ((${bad_count} > 100))
# then
#      mailx -s "NgN ping issues ${today}" bill_metzger@agilent.com  <  ${LOCAL_PROBLEMS}
# fi



