#!/bin/ksh

# past_hour.sh

. /opt/platform7/lbin/p7profile

WORKDIR=/h/bmetzger/s/tm
TMPDIR=${WORKDIR}/tmp

#INFILE=${WORKDIR}/junkfile 
INFILE=${WORKDIR}/tm_report.out    # results of TM load > 1 (captured every 10 minutes)
FILE_TO_MAIL=file_to_mail
JUNK1=${WORKDIR}/junk1

current_hour=`TZ=GMT; date "+%y/%m/%d:%H"`   # 07/04/16:01
mdate=`date "+%b %d %H00 CDT"`   # Apr 16 0100

tarball="${mdate}.tmspike.tar"
zipfile="${tarball}.gz"

if [ -f ${JUNK1} ]; then rm ${JUNK1} ; fi
if [ ! -d ${TMPDIR} ]; then mkdir ${TMPDIR} ; fi

# "238-211-0<0>5-59-13","07/04/16:01:14:57","07/04/16:01:24:42","F",15,0.17,0.17,4095000.00,0.04,0.96

grep -E "${current_hour}"  ${INFILE} > ${JUNK1}

count=`wc -l ${JUNK1} | awk '{print $1}' `

if [ ${count} -gt  0 ]
  then

      /tmp/asd/utils/a7log/collectfiles  > /dev/null 2>&1
      cp /tmp/asd/utils/a7log/*.gz  ${TMPDIR}
      cp ${JUNK1} ${TMPDIR}/current_TM_errors.txt

      cd ${WORKDIR}
      tar -cvf ${tarball}  tmp > /dev/null 2>&1   # tar up tempdir
      /usr/contrib/bin/gzip --best ${tarball}

      echo "To: bmetzger " >  ${WORKDIR}/${FILE_TO_MAIL}
      echo "Subject: possible tmspike in past hour ${mdate} " >> ${WORKDIR}/${FILE_TO_MAIL}
      echo " " >> ${WORKDIR}/${FILE_TO_MAIL}
      echo "Body" >> ${WORKDIR}/${FILE_TO_MAIL}
      echo " " >> ${WORKDIR}/${FILE_TO_MAIL}
      echo "- TM loading info is collected every 10 minutes " >> ${WORKDIR}/${FILE_TO_MAIL}
      echo "- A check is performed to see if any events exceeding .9 in the previous hour " >> ${WORKDIR}/${FILE_TO_MAIL}
      echo "- If you are reading this, a possible TM event occured in the past hour " >> ${WORKDIR}/${FILE_TO_MAIL}
      echo " " >> ${WORKDIR}/${FILE_TO_MAIL}
      echo "Attached file contains: " >> ${WORKDIR}/${FILE_TO_MAIL}
      echo " " >> ${WORKDIR}/${FILE_TO_MAIL}
      echo "- Log files collected by collectlogs  " >> ${WORKDIR}/${FILE_TO_MAIL}
      echo "  " >>${WORKDIR}/${FILE_TO_MAIL}

      echo " These email notificataions are currently being sent to: jeph and ken_foreman " >> ${WORKDIR}/${FILE_TO_MAIL}
      echo "  " >> ${WORKDIR}/${FILE_TO_MAIL}

       /usr/bin/uuencode ${zipfile}  ${zipfile}  >> ${WORKDIR}/${FILE_TO_MAIL}
       sendmail  bmetzger < ${WORKDIR}/${FILE_TO_MAIL}
fi
 if [ -f ${WORKDIR}/${FILE_TO_MAIL} ]; then rm ${WORKDIR}/${FILE_TO_MAIL} ; fi
 if [ -f ${zipfile} ]; then rm ${zipfile} ; fi
# if [ -f ${JUNK1} ]; then rm ${JUNK1} ; fi
 if [ -f ${TMPDIR}/* ]; then rm ${TMPDIR}/* ; fi


