#!/bin/ksh

. /opt/platform7/lbin/p7profile

DOW=`/bin/date +%a`    # Mon Tues ...  daily file extension
alarm_date=`date "+%m-%d-%y"`  # 01-02-07 ... format found in alarmlog

WORKDIR=/h/bmetzger/s/tm_late

resultsfile="${WORKDIR}/tm_late.probs.${DOW}"
junkfile="${WORKDIR}/tm_late_junk"

#cleanup
if [ -f ${junkfile} ]; then rm ${junkfile}; fi
if [ ! -f ${resultsfile} ]; then touch ${resultsfile}; fi

# Don't delete old or recreate new .  Use .csv created by overload check
#
#if [ -f ${WORKDIR}/a7log/S* ]; then rm ${WORKDIR}/a7log/S*; fi
#if [ -f ${WORKDIR}/a7log/T* ]; then rm ${WORKDIR}/a7log/T*; fi
#${WORKDIR}/a7log/alarm > /dev/null 2>&1  # generate files

A7FILE=/h/bmetzger/s/a7log/Sys*.csv

 grep -i fan  ${A7FILE} >> ${resultsfile}
 grep -i late  ${A7FILE} >> ${resultsfile}

 cp ${resultsfile} ${junkfile}
 
 head -1  ${A7FILE} > ${resultsfile}  # header and reinitialize output file
 egrep -e "${alarm_date}"  ${junkfile} | sort -u >> ${resultsfile}  # just want unique errors for today

#      mailx -s "Total of $total_bad  overload errors at `date +%X`"  bmetzger < ${outfile}
#      mailx -s "Total of $total_bad  overload errors on `date +%x`"  bmetzger < ${outfile}

#cleanup
if [ -f $junkfile ]; then rm $junkfile; fi
