#!/usr/bin/sh

# This script will write a list of AMCs and whether they have Full or Half duplex LAN settings
# Want AMCs set to 100 FULL duplex (the port needs to be set to auto negotiate):

. /opt/platform7/lbin/profile

WORKDIR=/h/bmetzger/s/amc

ETR=${WORKDIR}/wm.etr
COMMS=${WORKDIR}/wm.comms

junk1=${WORKDIR}/junk1
junk2=${WORKDIR}/junk2
junk3=${WORKDIR}/junk3
junk4=${WORKDIR}/junk4
site_ips=${WORKDIR}/site_ips     # site_number and ip address
lanconfigs_all=${WORKDIR}/lanconfigs_all
lanconfigs_errors=${WORKDIR}/lanconfigs_errors

#cleanup
if [ -f ${junk1} ]; then rm ${junk1} ; fi
if [ -f ${junk2} ]; then rm ${junk2} ; fi
if [ -f ${site_ips} ]; then rm ${site_ips} ; fi
if [ -f ${lanconfigs_all} ]; then rm ${lanconfigs_all} ; fi
if [ -f ${lanconfigs_errors} ]; then rm ${lanconfigs_errors} ; fi

# From comms config
#name      :17.site.cc.10:IP
#AMC10C1S12:17.12.1.10:172.17.247.30
#AMC10C1S14:17.14.1.10:172.17.238.30

#name     :2.site.0.1.IP
#SITE1SYS1:2.1.0.1:172.17.250.132
#SITE2SYS1:2.2.0.1:172.17.251.132

#From  /var/opt/platform7/conf/gf35_sysProcDets 
#17.site.cc.10.IP
#17.11.1.10:172.17.246.30

#2.site.0.cc.IP
#2.1.0.1:172.17.250.132

# grep 172.17.238.30 wm.etr  (gives hostname)
#AMC 10 0030D30F4625 172.17.246.30 m011ly1p10 acceSS7 

# create current copy of files required
# count=2;   # uncomment if you don't want to dump ETR
 count=`ls /var/opt/platform7/tmp/*.tlf 2>/dev/null | wc -l `

 if ((${count} > 0))
   then
         print -n "ETR is locked.  Find and copy the latest. "
       # grab copy of latest ETR
         latest_etr=`find /home/a7users -type f -name *.etr* | xargs ls -rt | tail -1`
         cp $latest_etr  ${ETR}

         latest_comms=`find /home/a7users -type f -name *.comms | xargs ls -rt | tail -1`
         cp $latest_comms  ${COMMS}
    else
         print  "ETR is available.  Dumping ETR "
         time p7config -db ${ETR}    2> /dev/null

         print  "Dumping comms config "
          p7updatecomms -d ${COMMS}   > /dev/null 2>&1

    fi

# create list of site numbers and IP addresses
# 9 172.17.244.132

grep ^2. /var/opt/platform7/conf/gf35_sysProcDets | sed -e 's/\.0\.1\:/ /g' | sed -e 's/^2\.//' > $site_ips

# create list of AMC info from comms_config
#
#grep ^AMC ${ETR} | grep -v \# | awk '{printf ("%s  %s\n", $4, $5)}' > $amc_ips
grep ^AMC ${COMMS} | grep -v \# |  awk 'FS=":" {printf ("%s %s\n", $2, $NF)}' | grep ^17 > $junk1

# junk1
#17.2.26.10 172.17.251.230
#17.2.27.10 172.17.251.40

while read mach_ident amc_ip; 
do
   site_numb=`echo $mach_ident |awk 'FS="." {printf ("%s ", $2)}`
   site_ip=`grep -E "^$site_numb" $site_ips |awk '{printf ("%s", $2)}`
   cc_numb=`echo $mach_ident   |awk 'FS="." {printf ("%s", $3)}`
   amc_hostname=`grep  "$amc_ip " ${ETR} | grep ^AMC | awk '{print $5}'`

   print "$site_numb $site_ip $cc_numb $amc_hostname $amc_ip"
done < $junk1 > $junk2 

# junk2
#1  172.17.250.132 23 m001c23p10 172.17.250.30
#2  172.17.251.132 23 m002ly23p10 172.17.251.30


# Ready to get lan configuration
#

while read -r site_numb site_ip cc_numb amc_hostname amc_ip
do
   print -n  "Site $site_numb $site_ip CC $cc_numb AMC $amc_hostname $amc_ip  "
   remsh $site_ip -n  "remsh $amc_ip  smc-landiag  |grep RTM10 " > ${junk3}
   cat ${junk3} | sed -e 's/RTM10//g' |sed -e 's/Pass//g' |awk '{printf ("%s",$0)}'
   echo 
done < ${junk2} >> ${lanconfigs_all}
echo

grep Half  ${lanconfigs_all} > ${lanconfigs_errors}
cat ${lanconfigs_all} | awk 'NF < 10' >> ${lanconfigs_errors}

#cleanup
cd ${WORKDIR};  
if [ -f junk* ]; then rm junk* ; fi
if [ -f ${site_ips} ]; then rm ${site_ips} ; fi

