#! /bin/ksh  

# version 9

#  Keeps a rolling backup for critical files
# 22 august  - added p7ldb
# 20 sept ITF
# 21 sept ntp.conf 
#  1 dec  p7resdiff
# 31 march  badlinks, channelconf, create /var/tmptarball
# 15 aug  backup lvm configuration

### Need to add WST OV license file
### WST  cat /etc/opt/OV/share/conf/.license
### WST /var/adm/sw/.codewords

DOW=`/bin/date +%a`   # Mon Tues ...
OUTDIR=/var/backups

# source access7 profile
. /etc/opt/platform7/share/env/p7profile
. /opt/platform7/lbin/profile

if [ ! -d $OUTDIR ]; then mkdir $OUTDIR ; fi

# Dump optimized version of ETR file. If successful, remove the 
# current compressed version and compress the dumped version

 count=`ls /var/opt/platform7/tmp/*.tlf 2>/dev/null | wc -l `
 if ((${count} > 0))
 then
         print -n "ETR is locked.  Find and copy the latest. "
       # grab copy of latest ETR
         latest_etr=`find /home/a7users -type f -name *.etr* | xargs ls -rt | tail -1`
         cp $latest_etr $OUTDIR/tmp.etr 
         cp $latest_etr /h/bmetzger/s/tmp/all/wm.etr
         cp $latest_etr /h/bmetzger/s/amc/wm.etr 

         /opt/platform7/bin/p7updatecomms -d $OUTDIR/tmp.commsConfig
         cp $OUTDIR/tmp.commsConfig   /h/bmetzger/s/tmp/all/wm.comms
         cp $OUTDIR/tmp.commsConfig   /h/bmetzger/s/amc/wm.comms

 else
         print  "ETR is available.  Dumping ETR "
         /opt/platform7/bin/p7config -db $OUTDIR/tmp.etr  2> /dev/null
         cp $OUTDIR/tmp.etr /h/bmetzger/s/tmp/all/wm.etr 
         cp $OUTDIR/tmp.etr /h/bmetzger/s/amc/wm.etr 

         /opt/platform7/bin/p7updatecomms -d $OUTDIR/tmp.commsConfig
         cp $OUTDIR/tmp.commsConfig   /h/bmetzger/s/tmp/all/wm.comms
         cp $OUTDIR/tmp.commsConfig   /h/bmetzger/s/amc/wm.comms
 fi

if [ -f $OUTDIR/etr.Z.$DOW ]
then
  rm $OUTDIR/etr.Z.$DOW
  compress $OUTDIR/tmp.etr 
  mv $OUTDIR/tmp.etr.Z  $OUTDIR/etr.Z.$DOW
else
  compress $OUTDIR/tmp.etr 
  mv $OUTDIR/tmp.etr.Z  $OUTDIR/etr.Z.$DOW
fi

if [ -f $OUTDIR/commsConfig.$DOW ]
then
  rm $OUTDIR/commsConfig.$DOW 
  mv $OUTDIR/tmp.commsConfig $OUTDIR/commsConfig.$DOW
else
  mv $OUTDIR/tmp.commsConfig $OUTDIR/commsConfig.$DOW
fi

cp /var/opt/platform7/conf/OVdatabase.cpio.Z  $OUTDIR/OVdatabase.cpio.Z.$DOW

if [ -f /opt/cdr/bin/cdrConfig ]
then
   /opt/cdr/bin/cdrConfig -d $OUTDIR/tmp.cdrConfig
   if [ -f $OUTDIR/tmp.cdrConfig ]
   then
     rm $OUTDIR/cdrConfig_$DOW 
     mv $OUTDIR/tmp.cdrConfig $OUTDIR/cdrConfig.$DOW
   else
     mv $OUTDIR/tmp.cdrConfig $OUTDIR/cdrConfig.$DOW
   fi
fi

# Load Balance Database
if [ -f /opt/platform7/bin/p7lbdb ]
then
  if [ -f $OUTDIR/LoadBalanceDB.$DOW ]
  then
       rm $OUTDIR/LoadBalanceDB.$DOW
  else 
       /opt/platform7/bin/p7lbdb  -d $OUTDIR/LoadBalanceDB.$DOW
  fi
fi

# Current Logs
if [ -f $OUTDIR/alarm_log_1.$DOW ]
  then
       rm $OUTDIR/alarm_log_1.$DOW
       cp /var/opt/platform7/logs/current/alarm_log_1   $OUTDIR/alarm_log_1.$DOW
  else 
       cp /var/opt/platform7/logs/current/alarm_log_1   $OUTDIR/alarm_log_1.$DOW
  fi

if [ -f $OUTDIR/alarm_log_2.$DOW ]
  then
       rm $OUTDIR/alarm_log_2.$DOW
       cp /var/opt/platform7/logs/current/alarm_log_2   $OUTDIR/alarm_log_2.$DOW
  else 
       cp /var/opt/platform7/logs/current/alarm_log_2   $OUTDIR/alarm_log_2.$DOW
  fi

if [ -f $OUTDIR/local_error_log_1.$DOW ]
  then
       rm $OUTDIR/local_error_log_1.$DOW
       cp /var/opt/platform7/logs/local/local_error_log_1   $OUTDIR/local_error_log_1.$DOW
  else 
       cp /var/opt/platform7/logs/local/local_error_log_1   $OUTDIR/local_error_log_1.$DOW
  fi

if [ -f $OUTDIR/local_error_log_2.$DOW ]
  then
       rm $OUTDIR/local_error_log_2.$DOW
       cp /var/opt/platform7/logs/local/local_error_log_2   $OUTDIR/local_error_log_2.$DOW
  else 
       cp /var/opt/platform7/logs/local/local_error_log_2   $OUTDIR/local_error_log_2.$DOW
  fi


########  Platform7 directories
DIR=/etc/opt/platform7
FILE=$OUTDIR/etc.opt.p7.tar   #temp
FFILE=$FILE.Z.$DOW            #final file w/ DOW extension

cd $DIR
tar cf $FILE * 
compress $FILE

  if [ -f $FFILE ]
  then
      rm $FFILE
      mv $FILE.Z  $FFILE
  else
      mv $FILE.Z  $FFILE
fi

#DIR=/var/opt/p7install
#FILE=$OUTDIR/var.opt.p7install.tar   #temp
#FFILE=$FILE.Z.$DOW            #final file w/ DOW extension
#
#cd $DIR
#tar cf $FILE * 
#compress $FILE
#
#  if [ -f $FFILE ]
#  then
#      rm $FFILE
#      mv $FILE.Z  $FFILE
#  else
#      mv $FILE.Z  $FFILE
#fi
#
###### changed resource files
/opt/platform7/bin/p7resdiff  -a >  $OUTDIR/resdiff_all.$DOW
/opt/platform7/bin/p7resdiff  -l >  $OUTDIR/resdiff_changed.$DOW

##### system status
/opt/p7ctf/bin/p7channelconf  -full >  $OUTDIR/channelconf.$DOW 
cp $OUTDIR/channelconf.$DOW /h/bmetzger/s/tmp/all/channelconf.raw

/opt/p7ctf/bin/p7badlinks   >  $OUTDIR/badlinks.$DOW 
cp $OUTDIR/badlinks.$DOW /h/bmetzger/s/tmp/all/badlinks.raw

##### out of comms
rm  /var/opt/platform7/tmp/*32*
/opt/platform7/bin/p7dumpstatus c32
sleep 5
echo "hardware out_of_comms list"  > $OUTDIR/out_of_comms.$DOW    #just in case their is no bad hardware
grep not  /var/opt/platform7/tmp/*32* >> $OUTDIR/out_of_comms.$DOW

######## NI database
/opt/a7stats/lbin/do_backup

######## LVM configuration
/etc/vgcfgbackup /dev/vg00

DIR=/etc/lvmconf
FILE=$OUTDIR/lvmconf.tar
FFILE=$FILE.$DOW            #final file w/ DOW extension

cd $DIR
tar cf $FILE * 

  if [ -f $FFILE ]
  then
      rm $FFILE
      mv $FILE  $FFILE
  else
      mv $FILE  $FFILE
fi


cd /h/bmetzger

if [ -f s.tar.gz ]                                                                                          
  then
      rm s.tar.gz
      tar cf s.tar s 
      /usr/contrib/bin/gzip s.tar
      rcp  s.tar.gz  m7sstra1:/tmp/wm
      rm s.tar.gz
  else
      tar cf s.tar s 
      /usr/contrib/bin/gzip s.tar
      rcp  s.tar.gz  m7sstra1:/tmp/wm
      rcp  s.tar.gz  m7sstra2:/tmp/wm
      rm s.tar.gz
fi


####### quotas
/usr/sbin/repquota -v /home > $OUTDIR/quotas_list.$DOW

####### misc files

cp /etc/nsswitch.conf  $OUTDIR/nsswitch.conf.$DOW
cp /etc/resolv.conf  $OUTDIR/resolv.conf.$DOW
cp /etc/mail/sendmail.cf $OUTDIR/sendmail.cf.$DOW
cp /etc/mail/service.switch $OUTDIR/service.switch.$DOW

cp /etc/hosts  $OUTDIR/hosts.$DOW
cp /etc/group  $OUTDIR/group.$DOW
cp /etc/passwd  $OUTDIR/passwd.$DOW
cp /etc/ntp.conf $OUTDIR/ntp.conf.$DOW
cp /etc/inetd.conf  $OUTDIR/inetd.conf.$DOW
cp /var/opt/platform7/conf/RemAppCompatFile $OUTDIR/RemAppCompatFile.$DOW
cp /var/opt/platform7/conf/gf35_sysProcDets $OUTDIR/gf35_sysProcDets.$DOW
cp /var/opt/platform7/LBDB/u*  $OUTDIR/LBDB.$DOW
cp /opt/platform7/lbin/profile   $OUTDIR/lbin_profile.$DOW          
cp /etc/opt/platform7/resources/ifpc/scalar/ITF_ifpc_dist $OUTDIR/ITF_ifpc_dist.$DOW 
cp /var/opt/a7trafmon/file/tm_normalisation_load.txt  $OUTDIR/tm_normalisation_load.txt
cp /etc/opt/platform7/resources/encrypted/license_options.text  $OUTDIR/license_options.text
cp /etc/opt/platform7/resources/encrypted/license_options.text  /h/bmetzger/s/tmp/all/license_options.text
cp /etc/passwd $OUTDIR/passwd.$DOW
cp /etc/passwd  /h/bmetzger/s/tmp/all/passwd.txt
cp /etc/exports $OUTDIR/exports.$DOW
/usr/bin/crontab -l > $OUTDIR/crontab.$DOW

## create tarball
cd $OUTDIR;
tar cf backups.$DOW *.$DOW
/usr/contrib/bin/gzip backups.$DOW
mv backups.$DOW.gz /var/tmp
