#!/bin/sh

# Find BPP corefile that have been created on todays date.
# And cleanup coredumps older than 14 days.

. /etc/profile

WORKDIR=/h/bmetzger/s/bpp_reboots
RESULTS=${WORKDIR}/daily_summary.out
JUNK=${WORKDIR}/bpp_junk
HISTORICAL=${WORKDIR}/bpp_coredump_history.out

if [ -f ${RESULTS} ]; then rm ${RESULTS}; fi
 
# corefile naming scheme  BPPdump_s004c02p8_DEC-06-06_12-09-24.gz
#
MONTH=`date +%b | tr "[:lower:]" "[:upper:]"`   # DEC
DAY=`date +%d`
YEAR=`date +%y`

cat ${HISTORICAL} > ${JUNK}  # keep a copy of the current list

#for f in `/opt/platform7/lbin/list_processors -s | sort` 
for f in m004
do
    count=`remsh $f  "ls /var/opt/platform7/tmp/*${MONTH}-${DAY}-${YEAR}* 2>/dev/null | wc -l | awk '{print $1}'"`  #DUMPS with just todays date
    remsh $f  "cd /var/opt/platform7/tmp/; ls *BPP* |  awk '{print $1}' | sed -e 's/old.//g" 2> /dev/null  >> ${JUNK}   # append all BPP to junk

    # clean up old file > 2 weeks old
    remsh $f  " find /var/opt/platform7/tmp -type f -name  "*BPP*" -mtime +14 -exec rm {} \; "  2> /dev/null 

    if [ ${count} -gt  0 ];  then echo "$f  $count" >> ${RESULTS}; fi  # had at least one coredump today
done

# Create one sorted list of historical dumps
sed -e 's/BPPdump_//g' ${JUNK} | sed -e 's/_/ /g' |sort -u > ${HISTORICAL}   # add todays files to historical 


total_bad=`wc -l ${RESULTS} | awk '{print $1}' `
if [ ${total_bad} -gt  0 ];
then
   mailx -s "Total of $total_bad sites had bpp's core dump on `date +%x`" bmetzger < ${RESULTS}
else
   mailx -s "No BPP core dumps on `date +%x`" bmetzger < /dev/null
fi


# cleanup
rm ${JUNK} ${RESULTS}

