#!/bin/ksh

. /opt/platform7/lbin/p7profile

DOW=`/bin/date +%a`    # Mon Tues ...  daily file extension
today=`date "+%b %e"`  # Jan 28   ...  for searching in log files
alarm_date=`date "+%m-%d-%y"`  # 02-02-07 ... format found in alarmlog

WORKDIR=/h/bmetzger/s/framesynch_check
a7logdir=/h/bmetzger/s/a7log     # TSD utility

SITE=s27

junkfile=${WORKDIR}/junkfile

#cleanup
  if [ -f ${junkfile} ]; then rm ${junkfile}; fi
  if [ -f ${a7logdir}/S* ]; then rm ${a7logdir}/S*; fi
  if [ -f ${a7logdir}/T* ]; then rm ${a7logdir}/T*; fi

  ${a7logdir}/alarm > /dev/null 2>&1  # generates Sys_0117-0957.csv, Sys_0117-0957.raw, TM_Sys_0117-0957.txt  

    FILE=${a7logdir}/Sys*.csv   # Name will change based on date

    resultsfile=${WORKDIR}/framesync.${SITE}.probs.${DOW}      # daily summary of unigue framsyne errors
    if [ ! -f ${resultsfile} ]; then touch ${resultsfile}; fi

    #capture
    egrep CRITICAL  ${FILE} | grep ${SITE} | egrep  1670 >> $resultsfile   # append all alarms to existing unique list
    egrep CRITICAL  ${FILE} | grep ${SITE} | egrep  1661 >> $resultsfile   # append all alarms to existing unique list

    #filter for todays info only
    cp ${resultsfile} ${junkfile}
    egrep -e ${alarm_date} ${junkfile} | sort -u  > ${resultsfile}

   count_1661=`grep 1661 ${junkfile} |wc -l | awk '{print $1}' `
   if [ ${count_1661} -gt  0 ];
   then
       echo "hello " > /dev/null
       # mailx -s "s27 1661 alarm noted at `date +%X`"  bmetzger < ${junkfile}
   fi


#cleanup
  if [ -f ${junkfile} ]; then rm ${junkfile}; fi
   
