package HC;

# configure global variables, tools and directories availale to HC modules

use strict;
use English;
use Carp;
use File::Basename;
use File::Path;
use lib "/opt/perl_32/lib/site_perl/5.8.8/PA-RISC1.1-thread-multi/ActiveState";
use lib "/opt/perl_64/lib/site_perl/5.8.8/PA-RISC2.0-thread-multi-LP64/ActiveState/";
use lib "/opt/p7perl/lib/site_perl/5.8.5";

# initilization. Setup files and directories
use Exporter;
our ($VERSION, @ISA, @EXPORT, @EXPORT_OK, %EXPORT_TAGS);

$VERSION     = 1.00;
@ISA         = qw(Exporter);
@EXPORT      = qw();
@EXPORT_OK   = qw(InitVars summarize);
%EXPORT_TAGS = ( ALL => [@EXPORT, @EXPORT_OK], DEFAULT => [@EXPORT] );

###############################################################################
# Miscellaneous utility routines

sub InitVars {
# initialize global variables to be used with other programs

    my $pwd  = $ENV{'PWD'};
    my ($file, $path, $suffix) = fileparse("$pwd/$0",'\..*');
# DEBUG
#    my $TmpDir = "${path}tmp/${file}";   #TmpDir automatically named based on script name
    my $TmpDir = "/h/bmetzger/s/p/hc/tmp";   #hardcode tmpdir
    mkpath("$TmpDir"); 

    select(STDOUT);

    $ENV{'PATH'} = '/usr/bin:/usr/local/bin:/usr/sbin/:/usr/ucb:/etc/:/opt/platform7/lbin/:.';

    our $sitelist = "/h/bmetzger/s/p/hc/tmp/sitelist";
    our $ArchiveDir = "/h/bmetzger/s/p/hc/archives";
    our $global_problems = "$TmpDir/global_problems";
    our $global_details = "$TmpDir/global_details";
    our $global_summary = "$TmpDir/global_summary";

    open GLOBAL_DETAILS,  ">>$global_details" or croak "Can't open file $global_details for write: $!\n";
    open GLOBAL_PROBLEMS, ">>$global_problems" or croak "Can't open file $global_problems for write: $!\n";

    open GLOBAL_SUMMARY, ">>$global_summary" or croak "Can't open file $global_summary for write: $!\n";

    return ($TmpDir,$sitelist,$global_problems,$global_details,$global_summary,$ArchiveDir);
} #InitVars


###################
sub summarize  {
# append header and files to global report

   # header, local_problems, local_details passed in from funcion
   my ($header, $problems, $details) = @_;

    # open input files for reading
    open PROBLEMS, "<$problems" or croak "Can't open file $problems for read: $!\n";
    open DETAILS, "<$details" or croak "Can't open file $details for read: $!\n";

#   print GLOBAL_PROBLEMS $header;
#   print GLOBAL_DETAILS $header;
   print GLOBAL_SUMMARY $header;

   while (<PROBLEMS>) {
       print GLOBAL_PROBLEMS ;
   }
   while (<DETAILS>) {
       print GLOBAL_DETAILS ;
   }

   $header = undef;
   unlink("$problems") || print $!;
   unlink("$details")  || print $!;
} #summarize


#------------------------------------------------------------------------------
# This file MUST return TRUE (non-zero) for 'use' to succeed
1;

