# awk filter file for system status log
#
#   Version  : 2005-Mar-15
#     Statistik for Late Messages
#
#   Version  : 2004-Sep-13
#     Supports European Time Format
#
#   Version  : 2004-Jan-06
#     add field delimiter 
#
#   Version  : 2003-Apr-14
#     change output date / time format to be able to use in excel
#     mm/dd/yyyy hh:mm:ss
#
BEGIN{
# DATE / TIME Format : YY : Year      MM : Month    DD : Day
#                      hh : 24 hours  mm : minutes  ss : seconds
#
# t_start="01-06-13 19:59:59"
#  t_stop="01-06-13 23:59:59"
  t_start="01-01-01 01:01:01"
   t_stop="99-12-31 23:59:59"
  b_start="TRUE"   # set to TRUE to print headerline
  b_stop="FALSE"
#
# set start conditions
#
  i_lines=0
  s_timestamp="TimeStamp syslog"
  s_severity="Severity"
  s_category="Category"
  s_machine="Machine"
  s_error="Error"
  s_task="Task"
  s_module="Modul"
  s_alarm="Alarm"
  s_data_1="Data 1 "
  s_data_2="Data 2 "
  s_text="TEXT"
  s_firsttime=""
  s_lasttime=""
  i_pap=0     # TM late messages Counter of affected PAP's
#
  if ( s_fd == "" ) {
    s_fd=sprintf(",")
  }
  print "# Field delimiter >",s_fd,"< length =",length(s_fd)
}
#
# First Line
# SYNCRONIZE and take out date and time
#
/^>>>/  {  i_lines=0
#
# output the oneliner  first time the headerline
#
          if ( b_start == "TRUE" ) {
            printf ("%-17s%s%-11s%s%-8s%s%-9s%s%-7s%s%-4s%s%-6s%s%-s\n",
              s_timestamp,s_fd,s_category,s_fd,s_severity,s_fd,
              s_machine,s_fd,s_error,s_fd,s_task,s_fd,s_module,s_fd,s_text )
          }
#
          s_text=""                # reset content
          YY=substr($2,7,2)
          MM=substr($2,1,2)
          DD=substr($2,4,2)
          hh=substr($3,1,2)
          mm=substr($3,4,2)
          ss=substr($3,7,2)
          AP=$4 
          split ($0,a_line," ")
          print "# first line",a_line[4],a_line[5],a_line[8],a_line[7]
          if ( ( a_line[4] == "AM" ) || ( a_line[4] == "PM" ) ) {
            s_severity=a_line[5]
            s_category=sprintf ("%s %s",a_line[6],a_line[7])
            s_machine=a_line[8]
            i_site=a_line[9]
          }
          else {
            s_severity=a_line[4]
            s_category=sprintf ("%s %s",a_line[5],a_line[6])
            s_machine=a_line[7]
            i_site=a_line[8]
          }
#         s_severity=$5
#         s_severity=substr($0,27,8)
#         s_category=sprintf ("%s %s",$6,$7)
#         s_category=substr($0,40,11)
#         s_machine=substr($0,53,11)
          if ( s_machine == "workstation" ) {
#             s_machine=sprintf ("WST%s",substr($0,64) )
              s_machine=sprintf ("WST%s",$NF)
          }
          else { 
            if ( match(s_machine,"site") != 0 ) {
              s_machine=sprintf ("STE %3s",i_site)
            }
          }
          print "# Machine",s_machine                         # for debugging
#         print date, hh, mm, ss, AP
          if ( ( hh == "12" ) && ( AP == "AM" ) ) {
            hh="00"
          }
          if ( ( AP == "PM" ) && ( hh != "12" ) ) {
            hh=hh+12
          }
#
#     s_timestamp used compare time to determin start and stop of buffer
#
          s_timestamp=sprintf("%s-%s-%s %s:%s:%s",YY,MM,DD,hh,mm,ss)
          if ( s_timestamp >= t_start ) {
            b_start="TRUE"
          }
          else {
            b_start="FALSE"
          }
          if ( s_timestamp >= t_stop ) {
            b_stop="TRUE"
            exit
          }
#
#     s_timestamp build to be used in excel
#     MM-DD-YY hh:mm:ss will be converted in excel to M/D/YYYY hh:mm
#
          s_timestamp=sprintf("%s-%s-%s %s:%s:%s",MM,DD,YY,hh,mm,ss)
#
#     save first and last time stamp
#
          if ( s_firsttime == "" ) {
            s_firsttime=s_timestamp
          }
          s_lasttime=s_timestamp
}
#
# Second Line
#   get errornumber  identify Task and Module
#
/    \(/ { s_error=sprintf("'%s",substr($1,2,length($1)-2))
          s_task=substr($3,1,3)
          i=index($0,"Module")
          if ( i != 0 ) {
            s_module=substr($0,i+7,5)
          }
          else {
            s_module=""
          }
}
#
# Third Line
#   get queue id if Data loss message
#
/^    Data loss between/ {
     s_text=sprintf ("%s Data loss",$7)
     next
}
#
# get Datastore ID if available
#
/^    Datastore: / { s_machine=sprintf("S%.2d DSP%.2d",$3,$6) 
                     next
                   }
#
# Recv call failed to read any data from Datastore: site 
#
/ Datastore: site / { i_site=match($0,"site")
                      i_processor=match($0,"processor")
                      i_point=index($0,".")
                      s_text=sprintf("S%.2d DSP%.2d %s",
                                          substr($0,i_site+5,2),
                                          substr($0,i_processor+10,2),
                                          substr($0,i_point+2))
                      next
                    }
#
# get Data Capture Card Slot
#
/ DCC DCC LAN/ { s_text=sprintf("%7s DCC %.2d LAN Connection Loss.",
                                 index($1,"Cleared") ? "Cleared:" : "", $NF) 
                    next
                  }
#
# get  IFPC or BPP  ID if available
#   IFPC: site 5 (Kh dma), cage 1, slot 0
#   BPP: site 22 (ArMobRMS), cage 1, slot 1
#
/^    IFPC: / || /^    BPP: / { print "#",$0 
                split ($0,a_machine,"[:]")
                print "#",a_machine[2]
                getifpc(a_machine[2],s_ifpc)
                if ( s_machine == "" ) {
                  s_machine=s_ifpc
                  i_lines=i_lines-1    # Line 4 is important
                                       # Line 3 is the error line
#
#                  cc=substr($(NF-2),1,length($(NF-2))-1) 
#                  s_machine=sprintf ("s%.2dc%.2dp%.2d",$3,cc,$NF) 
#
                }
                else {
                  s_text=sprintf ("%s %s",s_ifpc,a_machine[3])
                  print "#",s_text
                }
                print "# Machine",s_machine
}
#
# reformat SLT messages OPC/DPC
#
/^    SLT/ { first_dash=index($4,"/")
             second_dash=index(substr($4,first_dash+1),"/")
             first_sign=match($NF,"[<>]")
             second_sign=match(substr($NF,first_sign+1),"[<>]")
             slt_opc=substr($4,1,first_dash-1)
             slt_slc=substr($4,first_dash+1,second_dash-1)
             slt_dpc=substr($4,first_dash+second_dash+1)
             db_opc=substr($NF,1,first_sign-1)
             db_slc=substr($NF,first_sign+1,second_sign-1)
             db_dpc=substr($NF,first_sign+second_sign+1)
             if ( ( slt_opc == db_dpc ) && ( slt_slc == db_slc ) && ( slt_dpc == db_opc ) ) {
               swapped=swapped+1
             }
             else {
               s_text=sprintf ( "OPC/SLC/DPC SLT %5s/%2s/%5s does not match DB %5s/%2s/%5s",
                slt_opc,slt_slc,slt_dpc,db_opc,db_slc,db_dpc)
#              printf ( " %s %s %s %-13s does not match %s\n",
#                           timestamp, $1, $3, $4, $NF )
               other=other+1
             }
             next
           }
#
# Third Line
#   build statistik for TM late messages from PAP towards the Site Server
#
/    Traffic Monitor on site received / {
# s_PAP=$NF
# i_late_message=$(NF-5)
  if ( $NF in a_TM ) {

  }
  else {
    i_pap++            # Counter of affected PAP's
    a_PAP[i_pap]=$NF   # List of affected PAP's
    a_TM[$NF]=0        # Counter of late messages per PAP
  }
  a_TM[$NF]+=$(NF-5)
# 
  printf ("# PAP %s seen late messages now %s in total %s\n",
     $NF,$(NF-5),a_TM[$NF])
#
}
#
# Third or Fourth Line
#   get addtional text
#
{ i_lines=i_lines+1
  if ( i_lines > 2 ) { 
    i=index($0,"ORA-")
    if ( i != 0 ) {
      s_text=sprintf ("%s %s",s_text,substr($0,i))
    }
    else {
      if ( s_text == "" ) {
#       s_text=sprintf ("%s %s",s_text,substr($0,5,50))  # cut last characters
        s_text=sprintf ("%s %s",s_text,substr($0,5))     # all text
      }
    }
#   print s_text
  }
}
#
END{
#
# Summary for SLT messages
#
  summ=swapped+other
  if ( summ != 0 ) {
    printf ( "\nSLT %s Problems : %s swapped OPC/DPC's %s other reasons \n",summ,swapped,other )
  }
#
# Statistik for Late Messages
#
  printf ("#TM Late Messages from %s PAPs Start %s Stop %s \n",
             i_pap,s_firsttime,s_lasttime)
# printf ("#TM Start %s Stop %s\n",s_firsttime,s_lasttime)
  for ( i = 1 ; i <= i_pap ; ++i ) {
    printf ("#TM %5s, PAP, %11s, late messages, %5s\n",
              i, a_PAP[i], a_TM[a_PAP[i]])
  }
#
}
#
# function getifpc
#
function getifpc (STRING,IFPC) {
  print "#",STRING,IFPC
  i_start=index(STRING,"site")
  if ( i_start != 0 ) {
    i_length=index(substr(STRING,i_start+5),"(")
    i_site=substr(STRING,i_start+5,i_length)
  }
  else {
    i_site="-1"
  } 
  i_start=index(STRING,"cage")
  if ( i_start != 0 ) {
    i_length=index(substr(STRING,i_start+5),",")
    i_cage=substr(STRING,i_start+5,i_length)
  }
  else {
    i_cage="-1"
  } 
  i_start=index(STRING,"slot")
  if ( i_start != 0 ) {
    i_slot=substr(STRING,i_start+5)
  }
  else {
    i_slot="-1"
  } 
  IFPC=sprintf("s%.2dc%.2dp%.2d",i_site,i_cage,i_slot)
  s_ifpc=IFPC
  return s_ifpc
  print "#",STRING,IFPC
}
