#! /usr/contrib/bin/perl 

# aug 2008

open (INFILE, "</tmp/wm/burl3") || die "can't open input file: $!";
open (OUTFILE, ">ilm.out")     || die "can't open ilm.out: $!";

while (defined ($line = <INFILE>)) { 

      @array = split( /\s+/, $line );  # want entire line of info

       if ( $line =~ /00000000:/ ) {
           # 0 line  ";
           # 2-15 bytes for ethernet ";
           $message_type = hex($array[16]);
     
           print OUTFILE "message_type: $message_type\n" ;
       }   

       if ( $line =~ /00000010:/ ) {
           $ssg_class = hex($array[2]);
           $seq_numb = hex($array[4]);
           $link_id  = hex($array[6],$array[7],$array[8],$array[9]);
           $port  = hex($array[12]);
           $direction  = hex($array[13]);
           $link_protocol  = hex($array[14],$array[15]);  # 4=ss7oIP
           $opc_dpc_format  = hex($array[16]);  
           $link_type  = $array[17];  

           print OUTFILE "link_id: $link_id\n" ;
           print OUTFILE "Port: $port\n" ;
           print OUTFILE "Direction: $direction\n" ;
           print OUTFILE "Link_Protocol: $link_protocol\n" ;
           print OUTFILE "Link_Type: $link_type\n" ;
       }  
 
       if ( $line =~ /00000020:/ ) {
           $opc0 = hex($array[2]);
           $opc_member = hex($array[3]);
           $opc_cluster = hex($array[4]);
           $opc_network = hex($array[5]);
           $dpc0 = hex($array[6]);
           $dpc_member = hex($array[7]);
           $dpc_cluster = hex($array[8]);
           $dpc_network = hex($array[9]);
           
           #pcl specific
           $src_IP_address1 = hex($array[14]);
           $src_IP_address2 = hex($array[15]);
           $src_IP_address3 = hex($array[16]);
           $src_IP_address4 = hex($array[17]);

           print OUTFILE "OPC: ${opc_network}-${opc_cluster}-${opc_member} \n" ;
           print OUTFILE "DPC: ${dpc_network}-${dpc_cluster}-${dpc_member} \n" ;
           print OUTFILE "Source_IP: ${src_IP_address1}.${src_IP_address2}.${src_IP_address3}.${src_IP_address4}\n";
          }
 
       if ( $line =~ /00000030:/ ) {
           $dst_IP_address1 = hex($array[2]);
           $dst_IP_address2 = hex($array[3]);
           $dst_IP_address3 = hex($array[4]);
           $dst_IP_address4 = hex($array[5]);

           $src_IP_port = hex($array[6],$array[7]);
           $dst_IP_port = hex($array[8],$array[9]);
           $base_speed = hex($array[10],$array[11],$array[12],$array[13]);  # Kb/s
           $numb_alt_src_addr = hex($array[14]);  
           $numb_alt_dst_addr = hex($array[15]);  

           print OUTFILE "Destination_IP: ${dst_IP_address1}.${dst_IP_address2}.${dst_IP_address3}.${dst_IP_address4}\n";
           print OUTFILE "Numb Alt SRC addresses: $numb_alt_src_addr\n";
           print OUTFILE "Numb Alt DST addresses: $numb_alt_dst_addr\n";
       }

       if ( $line =~ /00000040:/ ) {
           $alt_src_IP_address1 = hex($array[2]);
           $alt_src_IP_address2 = hex($array[3]);
           $alt_src_IP_address3 = hex($array[4]);
           $alt_src_IP_address4 = hex($array[5]);
           $alt_dst_IP_address1 = hex($array[6]);
           $alt_dst_IP_address2 = hex($array[7]);
           $alt_dst_IP_address3 = hex($array[8]);
           $alt_dst_IP_address4 = hex($array[9]);

           print OUTFILE "Alt SRC IP: ${alt_src_IP_address1}.${alt_src_IP_address2}.${alt_src_IP_address3}.${alt_src_IP_address4}\n";
           print OUTFILE "Alt DST IP: ${alt_dst_IP_address1}.${alt_dst_IP_address2}.${alt_dst_IP_address3}.${alt_dst_IP_address4}\n";
       
       if ( $link_protocol == 4) {
            print "SRC     ${opc_network}-${opc_cluster}-${opc_member}";
            print "\t ${src_IP_address1}.${src_IP_address2}.${src_IP_address3}.${src_IP_address4}";
            print "\t Alt_SRC_IP: ${alt_src_IP_address1}.${alt_src_IP_address2}.${alt_src_IP_address3}.${alt_src_IP_address4}\n";

            print "DST     ${dpc_network}-${dpc_cluster}-${dpc_member}";
            print "\t ${dst_IP_address1}.${dst_IP_address2}.${dst_IP_address3}.${dst_IP_address4} ";
            print "\t Alt_DST_IP: ${alt_dst_IP_address1}.${alt_dst_IP_address2}.${alt_dst_IP_address3}.${alt_dst_IP_address4}\n\n";
       }
   }  # end of  /00000040:/ 

}
close OUTFILE;
