#!/bin/ksh

# right_now.sh

. /opt/platform7/lbin/p7profile

WORKDIR=/h/bmetzger/s/bpp_reboots
TMPDIR=${WORKDIR}/tmp
FILE_TO_MAIL=file_to_mail
overload_list=${TMPDIR}/overload_list

today=`date "+%b %d"`

if [ ! -d $TMPDIR ]; then mkdir $TMPDIR ; fi
if [ -f ${TMPDIR}/* ]; then rm ${TMPDIR}/* ; fi

for f in `/opt/platform7/lbin/list_processors -s`
do
   bad_count=`remsh $f  -n "cd /var/opt/platform7/tmp; ls BPP* | wc -l"`

   if [ ${bad_count} -gt  0 ]
   then
         rcp $f:/var/opt/platform7/tmp/BPP* ${TMPDIR}

         cd ${TMPDIR};
         for bpp in `ls B*`
         do
             remsh $f -n  "mv /var/opt/platform7/tmp/$bpp /var/opt/platform7/tmp/old.$bpp"  # so it won't be flagged again

             remsh $f  -n "cd /tmp/a7log; collectfiles;"  # TSD utility to collect local error logs
             remsh $f  "/usr/bin/netstat -a"  > ${TMPDIR}/netstat.out 
             remsh $f  "/usr/bin/ipcs -o"  > ${TMPDIR}/ipcs.out 
             remsh $f  "grep ntp /var/adm/syslog/syslog.log* | grep synchronisation"  > ${TMPDIR}/ntpstats.out 
             rcp $f:/tmp/a7log/S*  ${TMPDIR}  
             rcp $f:/var/opt/platform7/tmp/snmpProxy.log  ${TMPDIR}  
             rcp $f:/var/opt/platform7/tmp/ifpclog  ${TMPDIR}  
             rcp $f:/var/tmp/wm/*.gz   ${TMPDIR}  
             remsh $f  "rm /tmp/a7log/S*"    # cleanup

             # old.BPP files are deleted daily by the summary 

             echo "Suspend messages in $f/syslog for $today" > ${overload_list}
             echo "  " >> ${overload_list}
             remsh $f  "grep Suspended /var/adm/syslog/*syslog* |egrep '$today'  " >> ${overload_list}

#   format:   BPPdump_s004c03p2_DEC-06-06_13-29-39.gz (GMT time)
#
#             bpp_name=`echo $bpp | awk '{FS="_"}; {print $2}'`
#             echo $bpp | awk '{FS="_"}; {print $2}' | site=`cut -c 2-4`
#             echo $bpp | awk '{FS="_"}; {print $2}' | cc=`cut -c 6-7`
#             echo $bpp | awk '{FS="_"}; {print $2}' | bpp_numb=`cut -c 9`

#   format:   BPPdump_m001ly23p2_APR-05-07_00-09-39 (GMT time)
#
             bpp_name=`echo $bpp | awk '{FS="_"}; {print $2}'`
             echo $bpp | awk '{FS="_"}; {print $2}' | site=`cut -c 2-4`
             echo $bpp | awk '{FS="_"}; {print $2}' | cc=`cut -c 7-8`
             echo $bpp | awk '{FS="_"}; {print $2}' | bpp_numb=`cut -c 10-11`

# cant use sprint naming to derive the number needed for syshealthstat

#             /opt/p7ctf/bin/p7syshealthstat -site $site -cc $cc -bpp $bpp_numb > ${TMPDIR}/$bpp_name.healthstat.out 2>&1 

             cd ${WORKDIR};
             tar -cvf $bpp_name.tar  tmp   # tar up tempdir

             /usr/contrib/bin/gzip --best $bpp_name.tar 

#             echo "To: Support " >> ${WORKDIR}/${FILE_TO_MAIL}
             echo "Subject: $bpp_name just core dumped " >> ${WORKDIR}/${FILE_TO_MAIL}
             echo " " >> ${WORKDIR}/${FILE_TO_MAIL}
             echo "Body" >> ${WORKDIR}/${FILE_TO_MAIL}
             echo " " >> ${WORKDIR}/${FILE_TO_MAIL}
             echo "Attached file contains: " >> ${WORKDIR}/${FILE_TO_MAIL}
             echo "- BPP corefile  " >> ${WORKDIR}/${FILE_TO_MAIL}
             echo "- ifpclog  " >>  ${WORKDIR}/${FILE_TO_MAIL}
             echo "- snmpProxy.log  " >>  ${WORKDIR}/${FILE_TO_MAIL}
             echo "- ipcs -o  " >>  ${WORKDIR}/${FILE_TO_MAIL}
             echo "- local error logs for RSP  " >> ${WORKDIR}/${FILE_TO_MAIL}
             echo "- netstat -a of RSP  " >> ${WORKDIR}/${FILE_TO_MAIL}
             echo "- ntp synchronisation stats " >> ${WORKDIR}/${FILE_TO_MAIL}
             echo "- list of any Suspend message in syslog for $today" >> ${WORKDIR}/${FILE_TO_MAIL}
             echo "  " >>${WORKDIR}/${FILE_TO_MAIL}
             echo " These email notificataions are currently being sent to: carol " >> ${WORKDIR}/${FILE_TO_MAIL}
             echo "  " >> ${WORKDIR}/${FILE_TO_MAIL}
             /usr/bin/uuencode $bpp_name.tar.gz $bpp_name.tar.gz >> ${WORKDIR}/${FILE_TO_MAIL}
             sendmail  bmetzger < ${WORKDIR}/${FILE_TO_MAIL}

             rm ${TMPDIR}/* ${WORKDIR}/${FILE_TO_MAIL} ${WORKDIR}/$bpp_name.tar.gz
         done
   else
         cat /dev/null
   fi 
   
done





