#!/usr/bin/sh

# Check_configmgr.sh
# Terrie

get_yn()
{
   print "Please enter yes or no: \c"
   read answer
   print $answer|cut -c 1 | tr [A-Z] [a-z] | read answer
   if [[ "$answer" = "" || "$answer" = n ]]
   then
      return 1
   else
      return 0 
   fi
}
. /opt/platform7/lbin/p7profile
print '\nChecking for config manager processes'
for i in $(/opt/platform7/lbin/list_processors -w)
do
   process=$(remsh $i ps -ef | grep 'p7cm$'|grep -v grep)
   if [[ "$process" != "" ]] 
   then
      print '**** Cannot continue! ****'
      print 'Config manager read/write process found on' $i
      print $process | cut -f 1 -d' ' | read cmuser
      print Please have "$cmuser" close out the session and then rerun this script
      print or run the script called kill_config_mgr.sh to kill the session
      exit
   fi
done
print '\nNo Config manager read/write process found'
print '\nLooking for lockfiles...'
for i in $(/opt/platform7/lbin/list_processors -w)
do 
   semaphore=$(remsh $i ls -d /var/opt/ConfigMgr/temp/semaphore 2>/dev/null) 
   guilock=$(remsh $i ls /var/opt/ConfigMgr/temp/.cm-gui-lock 2>/dev/null)
   if [[ "$semaphore" != "" ]]
   then
      print OK to delete $semaphore on $i?
      if get_yn
      then
         remsh $i rm -r $semaphore
      fi
   fi
   if [[ "$guilock" != "" ]]
   then
      print OK to delete $guilock on $i?
      if get_yn
      then
         remsh $i rm $guilock
      fi
   fi
done
sessionfiles=$(ls /var/opt/ConfigMgr/sessions/*RW* 2>/dev/null)
if [[ "$sessionfiles" != "" ]]
then
   print OK to delete $sessionfiles on the Central Server?
   if get_yn
   then
      rm $sessionfiles
   fi
fi
guilock=$(ls /var/opt/ConfigMgr/temp/.cm-gui-lock 2>/dev/null)
if [[ "$guilock" != "" ]]
then
   print OK to delete $guilock on the Central Server?
   if get_yn
      then
         rm $guilock
   fi
fi
semaphore=$(ls /var/opt/ConfigMgr/temp/semaphore 2>/dev/null)
if [[ "$semaphore" != "" ]]
then
   print OK to delete $semaphore on the Central Server?
   if get_yn
   then
      rm -r $semaphore
   fi
fi

tlf_files=$(ls /var/opt/platform7/tmp/*.tlf 2>/dev/null)
if [[ "$tlf_files" != "" ]]
then
   print OK to delete the .tlf files on the Central Server?
   if get_yn
   then
      rm $tlf_files
   fi
fi

comms_lock_file=$(ls /var/opt/platform7/conf/C35_DBINUSE 2>/dev/null)
if [[ "$comms_lock_file" != "" ]]
then
   print OK to delete the CommsConfig lock file on the Central Server?
   if get_yn
   then
      rm $comms_lock_file
   fi
fi
