#! /bin/ksh  

. /etc/opt/platform7/share/env/p7profile
. /opt/platform7/lbin/profile

export PATH=${PATH}:/opt/platform7/lbin

WORKDIR=/h/bmetzger/s

integer percent=80  # level we're looking for

JUNKFILE=${WORKDIR}/diskspace.junk
RESULTSFILE=${WORKDIR}/diskspace.results

if [ -f ${RESULTSFILE} ]; then rm ${RESULTSFILE}; fi
if [ -f ${JUNKFILE} ]; then rm ${JUNKFILE}; fi



   echo "hostname    Filesystem        kbytes         used        avail     %used   Mounted on " > ${RESULTSFILE}

 for f in  `/opt/platform7/lbin/list_processors -sw` m7server m7altsrv
    do
       date | awk '{printf("%-12s \n ", "'$f'") }'
       remsh $f  "bdf -l" | grep -v Filesystem | sed -e s/\%//g > ${JUNKFILE}
       cat ${JUNKFILE} | awk '(($5 >= '$percent')) {printf ("%-9s %-16s %11s  %11s  %11s  %4s     %s\n","'$f'", $1, $2, $3, $4, $5, $6) }' >> ${RESULTSFILE}
       cat ${JUNKFILE}
       echo
       echo
    done

#   remsh a7svrlab "remsh s002 'bdf -l' " | grep -v Filesystem | sed -e s/\%//g > ${JUNKFILE}
#   cat ${JUNKFILE} | awk '(($5 >= '$percent')) {printf ("s002      %-16s %11s  %11s  %11s  %4s     %s\n", $1, $2, $3, $4, $5, $6) }' >> ${RESULTSFILE}

 count=`wc -l ${RESULTSFILE} | awk '{print $1}'`
 if ((${count} > 1))
 then
      mailx -s "diskspace problem" bmetzger <  ${RESULTSFILE}
  else
       echo "No partitions are > ${percent}% full "
   fi

cat ${RESULTSFILE} 

if [ -f ${RESULTSFILE} ]; then rm ${RESULTSFILE}; fi
if [ -f ${JUNKFILE} ]; then rm ${JUNKFILE}; fi

echo " "

