#!/bin/ksh

# ver.6
# Modified 6/19/07 to be used hourly rather than daily, STS

. /opt/platform7/lbin/p7profile

DOW=`/bin/date +%a`    # Mon Tues ...  daily file extension
today=`date "+%b %e"`  # Feb  3   ...  for searching syslog files
thishour=`date "+%b %e %H"`  # Feb  3 22  ...  for searching syslog files
alarm_date=`date "+%m-%d-%y"`  # 01-28-07 ... format found in alarmlog

WORKDIR=/h/bmetzger/s/ntp

resultsfile="${WORKDIR}/ntp.probs.${DOW}"
historyfile=${WORKDIR}/ntp_historical.out
current_errors=${WORKDIR}/current_errors

junkfile1=${WORKDIR}/ntp_junk1
junkfile2=${WORKDIR}/ntp_junk2

#cleanup
if [ -f ${junkfile1} ]; then rm ${junkfile1}; fi
if [ -f ${junkfile2} ]; then rm ${junkfile2}; fi
if [ -f ${current_errors} ]; then rm ${current_errors}; fi

cd $WORKDIR

#Modified 5/25/07 because m010 is down
for f in `/opt/platform7/lbin/list_processors -s` 
#for f in `/opt/platform7/lbin/list_processors -s|grep -v m010` 
do
   remsh $f  "cd /var/adm/syslog; grep -h ntp *syslog* | grep synchro  " >> ${junkfile1}
   remsh $f  "cd /var/opt/platform7/tmp; grep -hE 'lost sync' *ifpclog* " >> ${junkfile1}
   remsh $f  "cd /var/opt/platform7/tmp; grep -h ntp *ifpclog* | grep synchro  " >> ${junkfile1}
done

 grep lost ${junkfile1} | sed -e 's/syslog.log.old://g' | sed -e 's/syslog.log://g' | sed -e 's/OLD//g' | sort -u > ${resultsfile}

cp ${historyfile} ${junkfile2}
cat ${resultsfile} >> ${junkfile2}
sort -u ${junkfile2} > ${historyfile}

# See if we have any errors from just today
grep -hE "${thishour}" ${historyfile} > ${current_errors}

total_bad=`wc -l ${current_errors} | awk '{print $1}' `

if [ ${total_bad} -gt  0 ];
then
#Modified 5/25/07 to include Rick and Shea
      #mailx -s " $total_bad NTP sync loss errors on `date +%x`"  bmetzger < ${current_errors}
      #mailx -s " $total_bad NTP sync loss errors on `date +%x`"  agilentOA < ${current_errors}
cat ${current_errors}
fi

#cleanup
if [ -f ${junkfile1} ]; then rm ${junkfile1}; fi
if [ -f ${junkfile2} ]; then rm ${junkfile2}; fi
if [ -f ${current_errors} ]; then rm ${current_errors}; fi

