#!/usr/bin/perl 

# purpose:
#  ref DB used is sprint supplied arch file for high speed
#  - create unique list of linksets, and how many times they appear in DB

# customize:
#  - location of ETR
#  - location of DB
#  - specify monitored end as FTW_ISTP or STK_ISTP 

use English;
use Carp;
use Cwd;
use DBI;
use Net::Ping;
use File::Basename;
use File::Path;
use File::Glob;
use File::Copy;

# configurable
my $ETR = "/tmp/wm/wm.etr";
my $OUT = "/h/bmetzger/s/p/outfile";
#my $DB = "/h/bmetzger/s/p/junk";
#my $DB = "/h/bmetzger/s/p/nyc_hsl.db";
my $DB = "/h/bmetzger/s/p/akr_hsl.db";


#&compare_SLC_count;
#&compare_link_type;
&compare_device_type;


# db
#   CLLI        Dev     PointCode   Linkset SLC    Link#   Type   Ccage   BPP
#  NYCMNYZRDS4  SSP     253-064-044 LS6048   SLC0    48      A       2     3
#

# ETR
#[linkset]
#SS7 AKR314 NYC706 A LS6048 1

#[link]
#Q703:NxDS0 0 LowSpeed AKR314-NYC706/00 AKR-LS6048/0-048 acceSS7 ENABLED \
#  CHANA PCROFF L T1 56 9 \
#  CHANB PCROFF L T1 56 9
#
#[interface]
#NETELEM:J6739A 7 \
#  CHANA 2 8 SSG 48 6144 1 "" 1 0 "" \
#  CHANB 2 8 SSG 48 6144 1 "" 1 0 ""
#
#[monitoring]
#CT BOTH 2 3
#ILM BOTH 2 3
#LS BOTH 2 3
#PA BOTH 2 3
#Stats BOTH 2 3
#TM BOTH 2 3
#p7ctf BOTH 2 3


####
sub compare_SLC_count {

my @arr =();
my %linksets ;
my $unique;

#Create header, *assuming* there will be errors
print "Linkset DBcount ETRcount       dbSLCs                 etrSLCs\n";

 #Gather all linksets in DB
 open (DB, "<$DB") or croak "Can't open DB for read: $!\n";
 while (my $dbline = <DB>) {
      chomp $dbline;

      if ($. == 1) { #gotta create a prefix to use with grep for this site
            # EKRGMD92D06     SSP     253-060-012     LS3078  SLC1  
            @tmparr = split(/\s+/,$dbline);

            open (ETR, "<$ETR") or croak "Can't open ETR for read: $!\n";
            while (<ETR>) {
                 # SS7 AKR314 EKRGMD92D06 A LS3078 0
                 if ( ($_ =~ /$tmparr[3]/) && ($_ =~ /^SS7/)){
                     ($crap1, $full_prefix, $full_postfix, $crap2) = split(/\s+/,$_);
                     $prefix = sprintf("%.2s", $full_prefix);
                 }
            }
            close(ETR);
      } #end of processing 1st line of DB

      next if $dbline =~ /^$/;   #blank
      ($dbName, $dbDevice, $dbPC, $dbLinkSet, $junk) = split(/\s+/,$dbline);
      push (@arr, $dbLinkSet);
  }
  close (DB);

  $linksets{$_}++ for @arr;  # Count number of times linkset appears in DB
  $unique = keys %linksets;  # Show unique linksets found

 #Compare number of times linksets are found in DB and ETR
 while (my ($key, $value) = each(%linksets) ) {

#stopped

#ONLINE CS # grep LS3565  /tmp/wm/wm.etr
#Q2110:ATM:NxDS0 2 HighSpeed AKR314<02>TTBONJ1201W AKR-LS3565/2-335 acceSS7 ENABLED \
#SS7 NYC305 TTBONJ1201W A LS3565 1
#Q2110:ATM:NxDS0 0 HighSpeed NY-TTBONJ1201W/0 NYC-LS3565/0-215 acceSS7 ENABLED \
#Q2110:ATM:NxDS0 1 HighSpeed NY-TTBONJ1201W/1 NYC-LS3565/1-227 acceSS7 ENABLED \
#Q2110:ATM:NxDS0 2 HighSpeed NY-TTBONJ1201W/2 NYC-LS3565/2-335 acceSS7 ENABLED \

        chomp ($ETRcount = qx[grep $key $ETR |grep acceSS7 | wc -l]);

        # If different values, find and sort SLCs in DB and ETR
        if ($value ne $ETRcount) {
              my (@slc, @DBsorted) = ();
              open (DB, "<$DB") or croak "Can't open DB for read: $!\n";
              while (my $dbline = <DB>) {
                   chomp $dbline;
                   next if $dbline =~ /^$/;   #blank
                   $dbline =~ s/SLC/ /g;
                   if ($dbline =~ /$key/){
                       ($dbName, $dbDevice, $dbPC, $dbLinkSet, $dbSLC) = split(/\s+/,$dbline);
                        push (@slc, $dbSLC);
                   }
                   @DBsorted = sort {$a <=> $b} @slc;   #sorted SLCs for given linkset
              }
              my $size = @DBsorted; 
              for ($count = $size; $count < 9; $count++){
                  push(@DBsorted, '.');
              }
              close (DB);

              my (@etr, @ETRsorted) = ();
              open (ETR, "<$ETR") or croak "Can't open ETR for read: $!\n";
              while (my $etrline = <ETR>) {
                   if ( ($etrline =~ /$key/) && ($etrline !~ /^SS7/)){
                       ($ETRtype, $ETRslc, $personality, $junk) = split(/\s+/,$etrline);
                        push (@etr, $ETRslc);
                   }
                   @ETRsorted = sort {$a <=> $b} @etr;   #sorted SLCs for given linkset
              }
              my $size = @ETRsorted; 
              for ($count = $size; $count < 9; $count++){
                  push(@ETRsorted, '.');
              }
              close (DB);

#debug             print "key:$key value:$value ETR:$ETRcount  db:@DBsorted  etr:@ETRsorted\n";
#             print "$key DBcount:$value   ETRcount:$ETRcount  dbSLCs:@DBsorted  etrSLCs:@ETRsorted\n";
             printf "%-7s    %2s     %2s     ",$key, $value, $ETRcount;
             printf " @DBsorted        @ETRsorted\n";
       }
    }
} #compare_SLC_count


###
sub compare_device_type {

my $junk1 = "junk1";
my $sorted = "sorted";

unlink $junk1;
unlink $sorted;

#[nodes]
#  [type] "node_name" (unique node number) "node_alt_name" "parent_node_id"
#    (site) [remote/monitored flag] "class"
#  SSP ABLNTXOW04W 981 ABLNTXOW04W "" 0 REM SSP 249-51-0 "" "" ""

# DB
#NYCMNY8324W     SSP     214-090-016     LS3548  SLC3    201     A       5       4


 # For each linkset, see if dbDevice matches node type in ETR
 
  # Create single list of CLLI and dbDevice(STP,SSP)....
  open (JUNK1, ">$junk1") or croak "Can't open junk1 for write $!\n";
  open (DB, "<$DB") or croak "Can't open DB for read: $!\n";
  while (my $dbline = <DB>) {
      chomp $dbline;
      ($dbName, $dbDevice, $dbPC, $dbLinkSet, $dbSLC, $dbLinkNumb, $dbLinkType) = split(/\s+/,$dbline);
      print JUNK1 "$dbName $dbDevice\n";
  }
  close(DB);
  close(JUNK1);

  qx[sort -u $junk1 > $sorted];  #Now have one [linkset] dbDevice entry for every linkset

  # NSVLTN2021W  STP
  open (SORTED, "<$sorted") or croak "Can't open sorted for read: $!\n";
  while (my $line = <SORTED>) {
      my ($dbName, $dbDevice) = undef;

      chomp $line;
      ($dbName, $dbDevice) = split(/\s+/,$line);
 
      open (ETR, "<$ETR") or croak "Can't open etr for read: $!\n";
      while (<ETR>) {
           chomp;
           if (/^\[nodes\]$/ ... / \#/) {  #nodes range
                 next if ($_ =~ /^\#/);
                 next if ($_ =~ /^$/);
                 ($etrDevice, $etrName, $junk, $etrAltName, $junk1, $junk2, $junk3, $etrClass, $etrPC, $junk4) = split(/\s+/,$_);

                 # If dbName matches etrName, see if dbDevice matches etrDevice 
                 if ($etrName =~ /$dbName/){  #Names match.
                     if ($etrDevice !~ /$dbDevice/) {  # SSP/MSC ....
                           print      "$dbName $etrDevice should be $dbDevice\n";
                     }
                 }
           }
     }
     close(ETR);
     close(OUT);
  }
  close (DB);
}# compare_device_type 

####
sub compare_link_type {

my $junk1 = "junk1";
my $sorted = "sorted";

unlink $junk1;
unlink $sorted;

# ETR
# SS7 AKR314 NAS307 B LS3006 1

# DB
# NSVLTN2021W     STP     253-037-000     LS3006  SLC0    221     B       5       6
# NSVLTN2021W     STP     253-037-000     LS3006  SLC4    263     B       6       4


# [linkset_type] "mon_node_name" "rem_node_name"  [link_type] "linkset_name" (normalisation_factor)
#SS7 AKR314 NAS307 B LS3006 1

  # Want only 1 linkset, and type
  open (JUNK1, ">$junk1") or croak "Can't open junk1 for write $!\n";

  open (DB, "<$DB") or croak "Can't open DB for read: $!\n";
  while (my $dbline = <DB>) {
      chomp $dbline;
      next if $dbline =~ /^$/;   #blank
      ($dbName, $dbDevice, $dbPC, $dbLinkSet, $dbSLC, $dbLinkNumb, $dbLinkType) = split(/\s+/,$dbline);
      print JUNK1 "$dbLinkSet $dbLinkType\n";
  }
  close(DB);
  close(JUNK1);

  qx[sort -u $junk1 > $sorted];  #Now have one [linkset] [link_type] entry for every linkset

  open (SORTED, "<$sorted") or croak "Can't open sorted for read: $!\n";
  while (my $line = <SORTED>) {
      my ($dbLinkSet, $dbLinkType) = undef;

      chomp $line;
      ($dbLinkSet, $dbLinkType) = split(/\s+/,$line);

      if ($dbLinkType !~ /[A-Z]/) { #missing in worksheet 
          print "$dbLinkSet LinkType is missing from DB\n";
          next;
      }

      open (ETR, "<$ETR") or croak "Can't open etr for read: $!\n";
      while (my $line2 = <ETR>) {
           my @linkset = ();
           chomp;
           if (($line2 =~ /$dbLinkSet/) && ($line2 =~ /^SS7 /) ){
                 #SS7 AKR314 NAS307 B LS3006 1
                 @linkset = split(/\s+/,$line2);

                if ($dbLinkType ne $linkset[3]) {
                      print "$dbLinkSet $linkset[3] should be $dbLinkType\n";
                }
           }
      }
  }
} #compare_link_type
