# Awk Program Name:    SysHealthExceptions.awk
# Created:  04/15/2004
# Modiifed: 05/09/2004   Searches for Average Cpu, Mem, and CapBuff
# Modified: 04/28/2005   Make compatible for C.08 hardware
# Modified: 03/17/2006   Ignore AMC and EPP data elements; Only filter on Avg, not Peak data
#
# Usage:
# cat ifpcusage_yyyymmdd | awk -f SysHealthExceptions.awk Arg
#   or
# ParseSyshealth p7syshealth_all.yyyymmdd | tee ifpcusage_yyyymmdd | awk -f SysHealthExceptions.awk Arg
#
# where:  Arg = yyyymmdd
# note:   The standard input is required to be from ParseSyshealth
#         which is equivalent to using input filename ifpcusage_yyyymmdd

BEGIN {
  FS = ";"
  Header = "Id;Site Name;ProcType;IfpcHostName;IfpcIp;IfpcModel;Ifpc Memory;Synced;CpuAvg Load (%);CpuPeak Load (%);CpuPeakLoad Time;Mem Free Avg (%);Mem Free Peak (%);MemFreePeak Time;CapBuff Free Avg (%);CapBuff Free Peak (%);CapBuff Free PeakTime;Comments"

  Date = ARGV[1]     # DateParam -> example, 20040415
  ARGV[1] = "-"
  ARGC = 1

# "date +%Y%m%d" | getline Date 

  HighCpuThresh = 10                                         # High CPU Warning Threshold IFPC/BPP/EPP(%)
  AmcHighCpuThresh = 70                                      # High CPU Warning Threshold AMC(%)
  IfpcLowMemThresh = 70                                      # Low Memory Warning Threshold IFPC(%)
  BppLowMemThresh = 60                                       # Low Memory Warning Threshold BPP(%)
  AmcLowMemThresh = 25                                       # Low Memory Warning Threshold AMC(%)
  EppLowMemThresh = 65                                       # Low Memory Warning Threshold EPP(%)
  LowCapBuffThresh = 85                                      # Low Capture Buffer Warning Threshold IFPC/BPP(%)

  F1 = "NoIfpcs_" Date ".txt"
  F2 = "HighCpu_" Date ".txt"
  F3 = "LowMem_" Date ".txt"
  F4 = "LowCap_" Date ".txt"
  F5 = "NonIfpc0Sync_" Date ".txt"
  F6 = "NoSync_" Date ".txt"
  F7 = "Comments_" Date ".txt"

  print Header > F1
  print Header > F2
  print Header > F3
  print Header > F4
  print Header > F5
  print Header > F6
  print Header > F7
}

  $1=="NoData" { print $0 > F1 }                             # Check out of comms ifpcs
  (($3=="IFPC" || $3=="BPP" || $3=="EPP") && $9>HighCpuThresh && $1!="Id") || \
    ($3=="AMC" && $9>AmcHighCpuThresh && $1!="Id") \
      { print $0 > F2 }                                      # Check HighCpu
  ($3=="IFPC" && $12<IfpcLowMemThresh && $1!="NoData") || \
    ($3=="BPP" && $12<BppLowMemThresh && $1!="NoData") || \
      ($3=="AMC" && $12<AmcLowMemThresh && $1!="NoData") || \
        ($3=="EPP" && $12<EppLowMemThresh && $1!="NoData") \
          { print $0 > F3 }                                  # Check LowMem
  $15<LowCapBuffThresh && $1!="NoData" && $3!="AMC" && $3!="EPP" { print $0 > F4 } # Check LowCapBuff
  $3=="IFPC" && $8=="Yes,Master" && !match($1, "IFPC0") { print $0 > F5 }  # ifpc 0 that is not the Master
  $3=="IFPC" && match($8, "No") { print $0 > F6 }                          # ifpcs out of sync
  $18!="" && $1!="Id" { print $0 > F7 }                      # Print fields with comments

