#!/usr/bin/perl

#Summarize list of users that are running CT or PA sessions and what IFPCs are being used. 

$filename = "/var/opt/platform7/tmp/eng_logging_G25_0";
$sitelist = "/usr/local/bin/Site_List";

if (-e $filename ){ unlink $filename; }                 	     	#if text file and not 0 bytes in size close(FH);
else { print "File does not exist\n";}

system "p7dumpstatus g25";
sleep 1;
open(FH,$filename);				 			#Open file entered from command line value

@file = <FH>;								#Assign file to array
chomp @file;
$noCTPAmsg = "INFORMATION: There are no PA or CT sessions defined";
$state = 0;								# initialize state variable
$line = 0;								# initialize line counter variable
$u_start = 0;
$h_start = 0;
$s_start = 0;
close(FH);								# close file

$dumptime = substr($file[2],17);					# extract dumptime
$linkinfo = substr($file[5],0,index($file[5],"con")-1);
$num_sess = substr($file[6],20,index($file[6],"se") - 21);		# extract number of sessions
if ($num_sess == 0) { print "$noCTPAmsg\n"; exit;	}		# error message if no sessions are running


if (-T $sitelist && -s $sitelist){                   
   open(SL,$sitelist) ||  die "Cannot open the Site_List file\n";}
   else { print "ERROR: Site List file does not exist\n";}

@site_data = <SL>;
chomp @site_data;
close(SL);

foreach (@site_data) {
   my ($a7_num, $c7num, $bi_num, $s_name, $s_state, $s_pc) = split /\t/;
   if ($s_start = 0)
     { $s_start = 1;
       %site_field = ($a7_num => { SITE_NAME=>$s_name });
     }
   else {$site_field{$a7_num} = {SITE_NAME=>$s_name};}
  }

foreach (@file) {					# go through G25 file
  $line++;						# increment line counter variable
  if ($line == 11 )   { $state = 1; }  			# go to line 12 (right before session data starts and set session data flag
  elsif ($state == 1) { &get_user_data; }		# if session data flag is true, parse the user data section
  elsif ($state == 2) { &parse_pa;}		        # start processing data for PA sessions and parse the IFPCs with PA sessions
  elsif ($state == 3) { &parse_ct;	}	        # start processing data for CT sessions and parse the IFPCs with CT sessions
}


&print_list;
#&print_ifpc_list;


# ******************************************************************************
# ********************** subroutine section ************************************
# ******************************************************************************

sub get_user_data {
 if(/PAP Data For PROT ANAL/) { $state = 2;} 			# set flag at end of session data
 else 	
  {    	                    				  	# start processing user session data
   $str_len = length;						# get length of line
   if ($str_len > 100) 						# if line is longer than 100 chars => session info line
    { $sess_id = substr($_,0,9);				# extract session id
      $sess_id =~ s/ //g;					# remove extra spaces
      $user_name =  substr($_,10,15);				# extract user name
      $user_name =~ s/ //g;					# remove extra spaces
      $s_end = index($_,"CALL TRACE");				# get position of CALL TRACE string - because some session names may be long
      if ($s_end < 0 ) { $s_end = index($_,"PROT ANAL"); }	# get position of PROT ANAL string - if CALL TRACE is not found 
      $sess_name = substr($_,25,$s_end - 25);			# get session name
      $sess_name =~ s/ //g;		 			# remove extra spaces
      $sess_type = substr($_,$s_end,15);			# get session type
      $sess_type =~ s/ //g;					# remove extra spaces
      $status = substr($_,55,15);				# get status of session
      $status =~ s/ //g;					# remove extra spaces
      $time_stamp =  substr($_,-25);				# get time stamp 
      chop $time_stamp;						# chop carriage return
      $num_links = substr($file[$line + 1],0,12);
      $num_links =~ s/ //g;

      if ($u_start = 0)
       { $u_start = 1;
         %session_info = ($sess_id => {UNAME=>$user_name,SNAME=>$sess_name,STYPE=>$sess_type,STAT=>$status,TSTAMP=>$time_stamp,NUM_LINKS=>$num_links});
       }
      else { $session_info{ $sess_id } = { UNAME=>$user_name,SNAME=>$sess_name,STYPE=>$sess_type,STAT=>$status,TSTAMP=>$time_stamp,NUM_LINKS=>$num_links};}
    }
  } 
}

sub parse_pa {
   if(/PAP Data For CALL TRACE/) { $state = 3;} 		# set flag at end of PROT ANAL data
   else { 
     $str_len = length;
     if ($str_len > 25) 
      { $site_id = substr($_,12,index($_,"status") - 14);
        $site_id =~ s/, type 1, card cage /:/g;
        $site_id =~ s/, type 8, card cage /:/g;
        $site_id =~ s/, card cage/./g;
        $site_id =~ s/, slot /:/g;
        $app_id = $file[$line + 1];
        if (substr($app_id,0,1) eq " ") {$app_id =~ s/ //;}
        $app_id =~ s/  / /g;
        $app_id =~ s/ /-/g;
        
	if ($h_start = 0)
	  { $h_start = 1;
	    %ifpc = ($site_id => {PA=>$app_id});
	  }
        else { $ifpc{ $site_id } = { PA  => $app_id};}
      } 		
   }
}

sub parse_ct {
   if(/Session Priority/) { $state = 4;} 						# set flag at end of CALL TRACE data
   else { 
     $str_len = length;
     if ($str_len > 25) {
	$site_id = substr($_,12,index($_,"status") - 14);
	$site_id =~ s/, type 1, card cage /:/g;
	$site_id =~ s/, type 8, card cage /:/g;
	$site_id =~ s/, card cage/./g;
	$site_id =~ s/, slot /:/g;
	$app_id = $file[$line + 1];
	if (substr($app_id,0,1) eq " ") {$app_id =~ s/ //;}
        $app_id =~ s/  / /g;
        $app_id =~ s/ /-/g;		  
	$ifpc{$site_id}{CT} = $app_id;;
     } 		
   }
}


sub print_list {
  system "clear";
  print " _______________________________________________________________\n";
  print "|                     SYSTEM INFORMATION                        |\n";
  print "|_______________________________________________________________|\n";
  print "|DUMPTIME: $dumptime      \t\t\t|\n";
  print "|Number of Active Sessions: $num_sess\t\t\t\t\t|\n";
  print "|_______________________________________________________________|\n";	
  print "|\t\t\t|       |       |       |               |\n";
  print "| Site Name\t\t| Site\t| CC\t| Slot\t| Session Data\t|\n";
  print "|_______________________|_______|_______|_______|_______________|_______________________________\n";
  for $ifpc_id ( sort keys %ifpc ) {
   $c = length($ifpc{$ifpc_id}{CT});
   $p = length($ifpc{$ifpc_id}{PA});
   if ($c > 1 || $p > 1) 
     { @mach_id = split /:/, $ifpc_id;
       $mach_id[0] = "s" . substr("00".$mach_id[0],-3);
       $" = "\t| ";
       if (length($site_field{$mach_id[0]}{SITE_NAME}) < 6) {
          print "| $site_field{$mach_id[0]}{SITE_NAME}\t\t\t| @mach_id\t|";}
       elsif (length($site_field{$mach_id[0]}{SITE_NAME}) < 14) {
          print "| $site_field{$mach_id[0]}{SITE_NAME}\t\t| @mach_id\t|";} 
       else { print "| $site_field{$mach_id[0]}{SITE_NAME}\t| @mach_id\t|";} 
       
       
       if ( $c > 1 ) {
         @uname = split "-", $ifpc{$ifpc_id}{CT};
         foreach (@uname)
         { print " CT--$session_info{$_}{UNAME}\t"; }}
       if ( $p > 1 ) {
         @uname = split "-", $ifpc{$ifpc_id}{PA};
         foreach (@uname)
         {print " PA--$session_info{$_}{UNAME}\t"; }} 
       print "\n";
     }	    
  }
  print "|_______________________________________________________________________________________________\n";
  print "\n\n";
}




# Print user session info
#for $href ( keys %site_fields ) {
#    print "{ ";
#    for $role ( keys %$href ) {
#         print "$role=$href->{$role}|\t";
#    }
#    print "}\n";
#}

sub print_ifpc_list {
 for $iref ( @ifpc ) {
   if (length($iref->{CT}) > 1) {
     print "{";
     #for $app ( keys %$iref ) {
     #print "$iref";
     print "$iref->{IFPC} -- $iref->{CT}";
     #}
     print "}\n";
   }
 }
}


