#! /bin/ksh  

. /etc/opt/platform7/share/env/p7profile
. /opt/platform7/lbin/profile

WORKDIR=/h/bmetzger/s

JUNKFILE=${WORKDIR}/getntpinfo.junkfile
RESULTSFILE=${WORKDIR}/getntpinfo.results
PROBLEMSFILE=${WORKDIR}/getntpinfo.problems

if [ -f ${JUNKFILE} ]; then rm ${JUNKFILE}; fi
if [ -f ${RESULTSFILE} ]; then rm ${RESULTSFILE}; fi
if [ -f ${PROBLEMSFILE} ]; then rm ${PROBLEMSFILE}; fi

#for f in m001ilm9p5
for f in `list_processors -b` 
do

#remsh $f level 1
#remsh $f forward 1
#remsh $f enableTelnet
#remsh $f enableRemsh

   remsh  $f showTimeInfo > ${JUNKFILE}

   state=`grep "ntp state"  ${JUNKFILE} | awk 'BEGIN {FS=":"} {printf ("%s",$NF)}"`
   sync=`grep "timesync"  ${JUNKFILE} | awk 'BEGIN {FS=":"} {printf ("%s",$NF)}"`

   echo "$f  $sync   $state   `date`" >> ${RESULTSFILE} 
done

grep Out ${RESULTSFILE} > ${PROBLEMSFILE}

count=`wc -l ${PROBLEMSFILE} | awk '{print $1}'`
   if ((${count} > 0))
   then 
        mailx -s " $count BPPs  not timesyncd" bmetzger < ${PROBLEMSFILE}
   else
        mailx -s " no BPP timesync problems" bmetzger < /dev/null
   fi

if [ -f ${JUNKFILE} ]; then rm ${JUNKFILE}; fi
if [ -f ${RESULTSFILE} ]; then rm ${RESULTSFILE}; fi
if [ -f ${PROBLEMSFILE} ]; then rm ${PROBLEMSFILE}; fi
