#!/bin/ksh

# ver.6  14 jun

. /opt/platform7/lbin/p7profile

DOW=`/bin/date +%a`    # Mon Tues ...  daily file extension
today=`date "+%b %e"`  # Feb  3   ...  for searching syslog files
thishour=`date "+%b %e %H"`  # Feb  3 22  ...  for searching syslog files
alarm_date=`date "+%m-%d-%y"`  # 01-28-07 ... format found in alarmlog

WORKDIR=/h/bmetzger/s/iopp

resultsfile="${WORKDIR}/iopp.probs.${DOW}"
historyfile=${WORKDIR}/iopp_historical.out
current_errors=${WORKDIR}/current_errors

junkfile1=${WORKDIR}/iopp_junk1
junkfile2=${WORKDIR}/iopp_junk2

#cleanup
if [ -f ${junkfile1} ]; then rm ${junkfile1}; fi
if [ -f ${junkfile2} ]; then rm ${junkfile2}; fi
if [ -f ${current_errors} ]; then rm ${current_errors}; fi


cd ${WORKDIR}

#Modified 5/25/07 because site 10 is down
#for f in `/opt/platform7/lbin/list_processors -s|grep -v m010` 
for f in `/opt/platform7/lbin/list_processors -s` 
do
   remsh $f  "cd /var/adm/syslog; grep IOPP *syslog*     " >> ${junkfile1}
done

  cat  ${junkfile1} | sed -e 's/syslog.log.old://g' | sed -e 's/syslog.log://g' | sed -e 's/OLD//g' | sort -u > ${resultsfile}

cp ${historyfile} ${junkfile2}
cat ${resultsfile} >> ${junkfile2}
sort -u ${junkfile2} > ${historyfile}

# See if we have any current errors 
# Further, grep for this hour to get only "new" data
grep -E "${thishour}" ${historyfile} > ${current_errors}

total_bad=`wc -l ${current_errors} | awk '{print $1}' `

if [ ${total_bad} -gt  0 ];
then
#modified 5/25/07 
   mailx -s " $total_bad IOPP errors"  bmetzger < ${current_errors}
fi

#cleanup
if [ -f ${junkfile1} ]; then rm ${junkfile1}; fi
if [ -f ${junkfile2} ]; then rm ${junkfile2}; fi
if [ -f ${current_errors} ]; then rm ${current_errors}; fi

