#! /bin/ksh 

#   mirror.remote.sh

#   Purpose:  file is copied to, and then run on each remote machine
#             The results are then rcp'd back to a central directory
#             so reports can be compiled.
#   4 apr 07 - added check for low quorum

WORKDIR=/tmp/wm

TMPFILE=$WORKDIR/mirror.check.tmp      
JUNK=$WORKDIR/junk
TMP_MIRROR_FILE=/$WORKDIR/`hostname`.mirror.raw     # unformated node summary
MIRROR_OUTFILE=/$WORKDIR/`hostname`.mirror.out      # final file processed by awk
LOWQ_OUTFILE=$WORKDIR/`hostname`.low_quorum.out

PATH=/usr/sbin:$PATH

function check_lvols   
{
   # verify all mirrors on each logical volume have 
   # been setup and sync'd

  cd /dev
  for log_volume in `ls vg*/lvol*`
  do
         # example:  lvdisplay -v /dev/vg00/lvol1
       lvdisplay -v /dev/$log_volume > $TMPFILE
          
       mirror_copies=`awk '/Mirror/ {print $NF}'  < $TMPFILE `

       lv_status=`awk '/LV Status/ {print $NF}'  < $TMPFILE `

   print `hostname`  $log_volume  $lv_status  $mirror_copies >> $TMP_MIRROR_FILE

  done
}  #end check_lvols function

# verify boot, root,swap and dump settings
# verify mirror has been sucessfully added to volume group /dev/vg00

function check_physical_vols
{
    # find all potential /dev/vg0x volume groups
  for vgrps in `ls -d /dev/vg[0-9]*`            # /dev/vg00
  do
      # Get list of physical devices associated with volume groups
      # Then get current status of those devices by running pvdisplay
      # on those devices.
            # example:  vgdisplay -v /dev/vg00
         for actual_disks in `vgdisplay -v $vgrps |grep -E 'PV Name' | awk '{print $NF}'`
         do
              #example:    pvdisplay /dev/dsk/c0t6d0
             pvdisplay $actual_disks > $TMPFILE
         
             pv_name=`cat $TMPFILE | awk '/PV Name/ {print $NF}' | sed -e 's/\/dev\// /' `
             pv_status=`awk '/PV Status/ {print $NF}'  < $TMPFILE `

             print `hostname`  $acutal_disks  $pv_name $pv_status  >> $TMP_MIRROR_FILE

        done
  done
}  # end check_physical_vol function

function check_low_quorum {

    if [ -f ${JUNK} ]; then rm ${JUNK} ; fi
    if [ -f ${LOWQ_OUTFILE} ]; then rm ${LOWQ_OUTFILE} ; fi

             # check disk will boot with low quorum
             for vol in `vgdisplay -v /dev/vg00 |grep "PV Name" | awk '{print $3}'`
             do
                  print -n "print -n \"`hostname`  $vol    \"; " >> $JUNK
                  echo $vol | sed -e  "s/dsk/rdsk/"|awk '{printf ("sh \"lifcp %s:AUTO -\"\n",$1)}' >> $JUNK
             done
             chmod +x $JUNK
             $JUNK >> ${LOWQ_OUTFILE} 
} #check_low_quorum 

function print_results
{
  
   awk 'BEGIN {print "Host                                  Mirrored"
               print "name   Volume Name         Status      Copies "
               print "-----  ------------   --------------- --------"
              }
        { printf ("%5s  %12s  %16s  %3s \n", $1, $2, $3, $4) }
       ' <  $TMP_MIRROR_FILE > $MIRROR_OUTFILE
}  # end print_results function


#  -------------------------------------------------------
#  Start of program

if [ -d $WORKDIR ]; then rm $WORKDIR/`hostname`*mirror* ; fi

# check for Mirror bundle
software_install_check=`swlist -l bundle |grep  MirrorDisk/UX |wc -l`

if (($software_install_check == 1))
then
     check_lvols        # mirroring installed.  Run program
     check_physical_vols
     print_results
     check_low_quorum 
else
     print `hostname`:  mirrordisk_not_installed >> $TMP_MIRROR_FILE
fi

rm $TMPFILE
