#!/bin/ksh

. /opt/platform7/lbin/p7profile

DOW=`/bin/date +%a`      # Mon Tues  ...  daily file extension
today=`date "+%b-%d-%y"` # Feb-02-07 ...  custom date for this script

WORKDIR=/h/bmetzger/s/net_check
TMPDIR=${WORKDIR}/tmp
ALL_RESULTS=${WORKDIR}/netcheck.all_results.out             # results from pinging every box (good and bad results)
CURRENT_PROBLEMS=${WORKDIR}/netcheck.current_problems.out   # highlighted problems from this run
DAILY_RESULTS=${WORKDIR}/netcheck.probs.${DOW}              # daily summary of network issues (CURRENT_PROBLEMS appends to this file)
junkfile=${WORKDIR}/netcheck_junkfile

COUNT=10    # number of packets to send
SIZE=1024  # size of packets

# create header
print "number_of_packets=${COUNT}" > ${ALL_RESULTS}
print "packet_size=${SIZE}"  >> ${ALL_RESULTS}
print " "  >> ${ALL_RESULTS}
print "Date Time(CST)  From   To %Loss  Min  Avg  Max  From   To %Loss  Min  Avg  Max" >> ${ALL_RESULTS}

function check_RSPs {
#   for i in s003  s030 s029
   for i in `/opt/platform7/lbin/list_processors -p`
   do
        echo $i
       now=`date "+%b-%d-%y %H:%m "` # Feb-02-07 11:02
         print -n "${now} m7server $i "  >> ${ALL_RESULTS}
        /usr/sbin/ping  $i ${SIZE} -n ${COUNT} |tail -2 > ${junkfile}

   #  contents of ${junkfile}
   #       5 packets transmitted, 5 packets received, 0% packet loss
   #       round-trip (ms)  min/avg/max = 63/63/64

        grep loss ${junkfile} | sed -e 's/\%//g' | awk '{printf ("%d ", $7)}'  >> ${ALL_RESULTS}
        grep min ${junkfile} |  sed -e 's/\// /g' | awk '{printf ("%d %d %d ", $7, $8, $NF)}'  >> ${ALL_RESULTS}

        print -n "$i m7server " >>  ${ALL_RESULTS}
        remsh $i  "/usr/sbin/ping  m7server ${SIZE} -n ${COUNT} |tail -2" > ${junkfile}
        grep loss ${junkfile} | sed -e 's/\%//g' | awk '{printf ("%d ", $7)}'  >> ${ALL_RESULTS}
        grep min ${junkfile} |  sed -e 's/\// /g' | awk '{printf ("%d %d %d\n", $7, $8, $NF)}'  >> ${ALL_RESULTS}
        rm ${junkfile}
   done

}  # end of check_RSPs

function check_DSPs {
#   for i in s001ds02 s029ds01
  for i in `/opt/platform7/lbin/list_processors -d |sort `

   do
       now=`date "+%b-%d-%y %H:%m "` # Feb-02-07 11:02
       print -n "${now} m7server $i "  >> ${ALL_RESULTS}
      echo $i
      /usr/sbin/ping  $i ${SIZE} -n ${COUNT} |tail -2 > ${junkfile}
      grep loss $junkfile | sed -e 's/\%//g' | awk '{printf ("%d ", $7)}'  >> ${ALL_RESULTS}
      grep min $junkfile |  sed -e 's/\// /g' | awk '{printf ("%s %s %s ", $7, $8, $NF)}' >> ${ALL_RESULTS}

      #5 packets transmitted, 5 received, 0% packet loss, time 4000ms
      #rtt min/avg/max/mdev = 33.875/54.877/87.293/25.525 ms

      print -n "$i m7server "  >> ${ALL_RESULTS}
      ssh $i  "ping  -c ${COUNT} -s ${SIZE} m7server | tail -2" > $junkfile
      grep loss $junkfile | sed -e 's/\%//g' | awk '{printf ("%d ", $7)}'  >> ${ALL_RESULTS}
      grep min $junkfile |  sed -e 's/\// /g' | awk '{printf ("%s %s %s\n", $7, $8, $9)}'  >> ${ALL_RESULTS}
      rm ${junkfile}
  done

} # end check_DSPs

function look_for_errors {

   head -4 ${ALL_RESULTS} > ${CURRENT_PROBLEMS}       # initialize each time script is run

   grep m7server ${ALL_RESULTS} | awk ' $5 > 0 || $11 > 0 || $8 > 81 || $NF > 81 {print $0}' >> ${CURRENT_PROBLEMS}

#   if [ ! -f ${DAILY_RESULTS} ]; then head -4 ${CURRENT_PROBLEMS} >  ${DAILY_RESULTS} ; fi
    head -4 ${CURRENT_PROBLEMS} >  ${DAILY_RESULTS} # initialize daily file

    grep m7server ${CURRENT_PROBLEMS} >> ${DAILY_RESULTS}    # save running history
    cp ${DAILY_RESULTS} ${junkfile}
    egrep  -e "${today}" ${junkfile} >> ${DAILY_RESULTS}     

} # end of look_for_errors

check_RSPs
#check_DSPs
look_for_errors

#cleanup
# if [ -f ${junkfile} ]; then rm ${junkfile}; fi

rcp ${DAILY_RESULTS} m7sstra1:/tmp/wm
echo "${DAILY_RESULTS} ftp'd"

