#!/bin/ksh

export TIME=`date "+%b.%d.%y.%H.%M"`

WORK_DIR="/tmp/wm"
CAPTURE_SCRIPT=${WORK_DIR}/mlan_here.sh
OUTFILE=${WORK_DIR}/lanconfig.out
TMPFILE=${WORK_DIR}/junk2

export PATH=$PATH:/usr/sbin:.

#need to pass if box has more than 1 lan card
#ppid=`netstat -r |grep UG | tail -1 |tr -s " " " " | sed s/lan//g |  awk '{printf $(NF-1) }'`;
ppid=`netstat -i |grep lan | tr -s " " " " | sed s/lan//g |  awk '{printf $1 }'`;


$CAPTURE_SCRIPT $ppid > junk

cat junk |sed /^$/d | grep -v continue |grep -v Statistics > ${TMPFILE}

speed=`grep Speed ${TMPFILE} | sed s/000000//g |awk 'BEGIN {FS = "="}; {print $2}'` ; 
mac=`grep Station  ${TMPFILE} | sed s/.0x//g |awk 'BEGIN {FS = "="}; {print $2}'`;  #"." removes leading space
FCS=`grep FCS  ${TMPFILE} |awk 'BEGIN {FS = "="}; {print $2}'`; 
config=`lanadmin -x $ppid | sed -e 's/\./ /g' | sed -e 's/  */ /g' | awk '{printf $0};'| awk 'BEGIN {FS="= "}; {print $2 $3}'` ;
#config=`lanadmin -x $ppid | awk 'BEGIN {FS = "="}; {print $NF}'` ;
#interface=`netstat -r |grep UG | tail -1 |tr -s " " " " |  awk '{printf $(NF-1) }'`  #2nd to last field
ip=`ifconfig lan$ppid |grep inet| awk '{print $2}'` ;


inbound_pkts=`cat ${TMPFILE} |awk 'BEGIN {FS = "="}; /Inbound Octets/ {print $2}'`;
outbound_pkts=`cat ${TMPFILE} |awk 'BEGIN {FS = "="}; /Outbound Octets/ {print $2}'`;

deferred=`cat ${TMPFILE} |awk 'BEGIN {FS = "="}; /Deferred Transmissions / {print $2}'`;
excessive=`cat ${TMPFILE} |awk 'BEGIN {FS = "="}; /Excessive Collisions/ {print $2}'`;

total_pkts=`date | awk '{printf("%d\n",('"$inbound_pkts"'+'"$outbound_pkts"')) }'`
percent_deferred=`date | awk '{printf("%7.2f\n",('"$deferred"'/'"$total_pkts"')*100) }'`
percent_excessive=`date | awk '{printf("%7.2f\n",('"$excessive"'/'"$total_pkts"')*100) }'`


proc_type=`model | awk 'BEGIN {FS = "/"}; {print $NF}' ` ;

   case $proc_type in
            B*)
                 if [[ $ppid = "" ]] #unset.  ppid must be wrong
                 then
                      ppid=`lanscan |grep lan0 | awk '{print $7}'`   #works on HSPPs ;
                      config=`lanadmin -x $ppid | awk 'BEGIN {FS = "="}; {print $2}'` ;
                 fi;;
            D*)
                 if [[ $config = "" ]] #unset. 10BaseT card.
                 then
                      config="cmd_not_supported" ;
                 fi;;
		
             *)
                config=`lanadmin -x $ppid | sed -e 's/\./ /g' | sed -e 's/  */ /g' | awk '{printf $0};'| awk 'BEGIN {FS="= "}; {print $2 $3}'` ;
                 if [[ $config = "" ]] #unset.  ppid must be wrong
                 then
                    ppid=0
                    config=`lanadmin -x $ppid | awk 'BEGIN {FS = "="}; {print $2}'` ;
                 fi;;
  esac

  if [ -f /var/opt/platform7/conf/gf36_MCIDStorage ]
  then
         # Site:9:0:1
         # Workstation:0:0:4
         # Server:0:0:1
         # Workstation:0:0:1
         # ProbeProcessor:50:0:2
         # Datastore:29:0:26

       a7processor_type=`cat /var/opt/platform7/conf/gf36_MCIDStorage |cut -d ":" -f 1`;
  fi

  case $a7processor_type in
               Server)
                        a7processor_number=`cat /var/opt/platform7/conf/gf36_MCIDStorage |cut -d ":" -f 4`;
                        a7processor_name="$a7processor_type$a7processor_number"  ;;

                 Site)
                        a7processor_number=`cat /var/opt/platform7/conf/gf36_MCIDStorage |cut -d ":" -f 2`;
                        a7processor_name="$a7processor_type$a7processor_number"  ;;

          Workstation)
                        a7processor_number=`cat /var/opt/platform7/conf/gf36_MCIDStorage |cut -d ":" -f 4`;
                        a7processor_name="ws$a7processor_number" ;;


       ProbeProcessor)
         # Workstation:0:0:1
         # ProbeProcessor:50:0:2
         # Datastore:29:0:26

                        site_number=`cat /var/opt/platform7/conf/gf36_MCIDStorage |cut -d ":" -f 2`;
                        slot_number=`cat /var/opt/platform7/conf/gf36_MCIDStorage |cut -d ":" -f 4`;
                        a7processor_name="s"$site_number"Probe$slot_number"  ;;
                      #  a7processor_name="s$site_number$a7processor_type$slot_number"  ;;

            Datastore)
                        site_number=`cat /var/opt/platform7/conf/gf36_MCIDStorage |cut -d ":" -f 2`;
                        a7processor_number=`cat /var/opt/platform7/conf/gf36_MCIDStorage |cut -d ":" -f 4`;
                        a7processor_name="s$site_number$a7processor_type$a7processor_number"  ;;

                    *) a7processor_type="not access7"
                       a7processor_name="check_gf36_MCIDStorage" ;;

  esac

print  "`hostname`;$a7processor_name;$a7processor_type;`model`;$ip;$mac;$ppid;$speed;$config;$FCS;$percent_deferred;$percent_excessive" > $OUTFILE

