#!/opt/perl5/bin/perl

# diskfree.pl
# 8-23-01 by Jon Bieker

$THRESHOLD = 95;

$user = `whoami`;
chop $user;
if ($user ne "root") {
	print "This script must be run as root!\n";
	exit(1);
}

$hostname = `hostname`;
chop $hostname;
if ($hostname ne "m7server") {
	print "This script must be run on the central server!\n";
	exit(1);
}

$lHeader = 0;
while (<`/opt/platform7/lbin/list_processors -w`>) {
	&checkdf;
}

while (<`/opt/platform7/lbin/list_processors -s`>) {
	&checkdf;
}

while (<`/opt/platform7/lbin/list_processors -p`>) {
	&checkdf;
}

#finis
exit(0);

sub checkdf {
	@df = `remsh $_ bdf -l`;

	for ($nJ = 1; $nJ < @df; $nJ++) {
		@df[$nJ] =~ s/  */ /g;
		($filesystem,$kbytes,$used,$avail,$pctused,$mntpoint) = split(/ /,@df[$nJ]);
		chop $pctused;
		chop $mntpoint;

		if ($pctused > $THRESHOLD) {
			if (!$lHeader) {
				$lHeader = 1;
				print "$_\n";
				for ($nI = 0; $nI < length($_); $nI++) { 
					print "-"; 
				}
				print "\n";
			}
			print "$mntpoint ";
			if (length($mntpoint) < 5) {
				print "\t";
			}
			print "\tis $pctused% full.\n";
		}
	}
	if ($lHeader) {
		print "\n";
		$lHeader = 0;
	}
}
