#!/opt/perl5/bin/perl

# Get CLLI's & Linksets
# 12-14-01 by Jon Bieker
# (c)2001 Sprint

print "Loading signaling points... ";
open(hSP,"<signaling_points.txt");

$nSP = 0;
while (<hSP>) {
  $_ =~ s/"//g;
  chop $_;
  @aSP[$nSP] = $_;

  ($name,$altname,$pointcode,$type,$capcode,$site,$monflag,$class) = split(/ /,@aSP[$nSP]);

  if (length($name) > 1) {
    $nSP++;
  }

}

close(hSP);
print $nSP - 1 . " SP's loaded.\n";

print "Loading linksets... ";
open(hLinkset,"<linksets.txt");

$nLinkset = 0;
while (<hLinkset>) {
 $_ =~ s/"//g;
 chop $_;
 @aLinkset[$nLinkset] = $_;
 
 ($monsp,$remsp,$linktype,$norm,$name) = split(/ /,@aLinkset[$nLinkset]);
 
 if (length($monsp) > 1) {
   $nLinkset++;
 }
 
}

close(hLinkset);
print $nLinkset - 1 . " linksets loaded.\n";

print "Loading link data... ";
open(hNI,"<ni_09_Dec_2001.dat");

$nNI = 0;
while (<hNI>) {
  @aNI[$nNI] = $_;
  chop $_;
  
  ($date,$id,$link,$time) = split(/\t/,@aNI[$nNI]);
  
  if (length($link) > 0) {
    $nNI++;
  }
}

close(hNI);
print $nNI - 1 . " links loaded.\n";

print "Writing CLLI and linkset info... ";
open(hCLLI,">clli_info.txt");

for ($nI = 0; $nI < $nNI; $nI++) {
  ($date,$id,$link,$time) = split(/\t/,@aNI[$nI]);
  ($opc,$slc,$dpc) = split(/ /,$link);
  $slc =~ s/[<|>]//g;

  for ($nK = 0; $nK < $nLinkset; $nK++) {
    ($monsp,$remsp,$linktype,$norm,$name) = split(/ /,@aLinkset[$nK]);
    
    if ($opc eq $monsp && $dpc eq $remsp) {
      $linkset = $name;
      $nK = $nLinkset;
    }
  }

  $opc_clli = "";
  $dpc_clli = "";  
  for ($nK = 0; $nK < $nSP; $nK++) {
    ($name,$altname,$pointcode,$type,$capcode,$site,$monflag,$class) = split(/ /,@aSP[$nK]);
    
    if ($opc eq $pointcode) {
      $opc_clli = $name;
    }
    
    if ($dpc eq $pointcode) {
      $dpc_clli = $name;
    }

    if (length($opc_clli) > 1 && length($dpc_clli) > 1) {  
      $nK = $nSP;
    }
  }
  
  print hCLLI "$opc <$slc> $dpc\t$opc_clli <$slc> $dpc_clli\t$linkset\n";
}

close(hCLLI);
print "Complete.\n";
