/*
	acctinfo.c by Jon A. Bieker 3-23-01

	Usage:
		./acctinfo [-options] [params]

	Options:
		-a	Only show accounts older than n days (Default is all)
		-u	Specify user account.  (Default is all users)
		-d	Specify alternate home directory. (Default is /home)
		-e	Expire the account if it is older than n days.
		-h	Show help screen.
		-f	Use alternate format.
		-s	Suppress error messages.
*/

#include "/home/a7users/ss7gjobi/src/include/include.h"
#include <unistd.h>
#include <time.h>

#define MAXUSERS 1000

/*********************
** Show Help Screen **
*********************/
void show_help() {
	printf("Usage:\n");
	printf("\t./acctinfo [-h] [-f] [-s] [-r] [-u user] [-d directory] [-a days] [-e days]\n");
	printf("\n\t-a\tOnly show accounts more than n days old.  Default is All.\n");
	printf("\t-d\tSpecify an alternate home directory.  Default is /home.\n");
	printf("\t-e\tExpire the account if it is older than n days.\n");
	printf("\t-f\tUse alternate format.\n");
	printf("\t-h\tThis screen (help).\n");
	printf("\t-r\tRefresh data files. (Must be done as root from m7server)\n");
	printf("\t-s\tSuppress error messages.\n");
	printf("\t-u\tSpecify a username.  Default is All Users.\n");
}

/************************
** Format tm structure **
************************/
char *gettime(timest)
	struct stat timest;
{
	char fmtdate[18];
	strftime(fmtdate,sizeof(fmtdate),"%h %e %Y %H:%M",localtime(&timest));

	return fmtdate;
}

/****************************
** Create a user structure **
****************************/
struct user {
	struct userdata userdata;
	struct facilities facilities[15];
	char name[50];
/*	struct ws ws[50];
*/
};

/*******************************
**  Create a flags structure  **
*******************************/
struct flags {
	char flag[10];
};

/********************************
**  Create a months structure  **
********************************/
struct months {
	char name[4];
};

/*******************
**  Main Function **
*******************/
int main(argc, argv)
	int argc;
	char **argv;
{
	int nI, nJ, nK, nL, nM, nN, nExpireDays, nMaxDays, nDays, nResult, nUsers, nEOF, nLen, nYear;
	unsigned char nBytes, bName, bFormat, bSuppress, bRefresh, bFound, bSpace, bExpire, nFOY;
	struct stat st;
	struct stat pwdfile;
	struct flags flags[25];
	struct user user[MAXUSERS];
	struct months month[12];
	struct passd passd[MAXUSERS];
	struct passd pwd;
	struct tm tm;
	struct utmp utmp;
	double diff;
	time_t now;
	time_t timer;
	char c[2], cBuf[1024], cTmpBuf[1024], cName[256], cPath[512], cHomeDir[256], cCommand[1024];
	char cDeptName[256], cDeptName2[256];
	FILE *hETR, *hFile, *hOrphan, *hPasswd, *hNewPasswd;

	strcpy(cBuf,"");
	for (nI = 1; nI < argc; nI++) {
		strcat(cBuf,argv[nI]);
		strcat(cBuf," ");
	}

	uselog(argv[0],cBuf);

	/*******************
	* Get current time *
	*******************/
	now = time((time_t *) NULL);

	/*************************
	*  Define Home Directory *
	*************************/
	strcpy(cHomeDir,"/home"); 
	
	/*******************************
	*  Parse command line options  *
	*  (this is yucky, I know)     *
	*******************************/
	bFormat = 0;
	bName = 0;
	bSuppress = 0;
        bExpire = 0;
	if (argc > 9) {
		show_help();
		exit(1);
	} else {
		for (nI = 1; nI < argc; nI++) {
			if (!strcmp(argv[nI],"-h") || !strcmp(argv[nI],"--help")) {
				show_help();
				exit(1);
			}
			if (!strcmp(argv[nI],"-f")) {
				bFormat = 1;
			}
			if (!strcmp(argv[nI],"-u")) {
				if (strlen(argv[nI+1]) > (sizeof(cName) - 1)) {
					printf("Error! User name is too long!\n");
					show_help();
					exit(1);
				} else {
					strcpy(cName,argv[nI+1]);
					bName = 1;	
				}
			}
			if (!strcmp(argv[nI],"-d")) {
				if (strlen(argv[nI+1]) > (sizeof(cHomeDir) - 1)) {
					printf("Error! Home directory is too long!\n");
					show_help();
					exit(1);
				} else {
					strcpy(cHomeDir,argv[nI+1]);
				}
			}
			if (!strcmp(argv[nI],"-a")) {
				if (strlen(argv[nI+1]) > (sizeof(nMaxDays) - 1)) {
					printf("Error! Too many days!\n");
					show_help();
					exit(1);
				} else {
					nMaxDays = atoi(argv[nI+1]);
				}
			}
			if (!strcmp(argv[nI],"-e")) {
				if (strlen(argv[nI+1]) > (sizeof(nMaxDays) - 1)) {
					printf("Error! Too many days!\n");
					show_help();
					exit(1);
				} else {
					nExpireDays = atoi(argv[nI+1]);
					bExpire = 1;
				}
			}
			if (!strcmp(argv[nI],"-s")) {
				bSuppress = 1;
			}
		}
	}

	/********************************
	*  Display title & startup info *
	********************************/
	if (!bFormat) {
		printf("\nUser Account Info\n");
		printf("3-23-01 by Jon Bieker\n");
		printf("(c)2001 Sprint\n\n");
	}
	
	/**************************
	*  Load /etc/passwd file  *
	**************************/	
	if (!bFormat) printf("Loading user information... ");
	
	hPasswd = fopen("/etc/passwd","r");
	if (hPasswd == -1) {
		if (!bSuppress) printf("Error %0d!  Can't open /etc/passwd.",errno);
		exit(1);
	}
	
	nJ = 0;
	nEOF = 0;
	while (!nEOF) {
		if (fgets(cBuf,sizeof(cBuf),hPasswd) == NULL) nEOF = 1;
		
		if (strlen(cBuf) > 0) {
			strcpy(cTmpBuf,cBuf);
			
			strcpy(passd[nJ].username,strtok(cTmpBuf,":"));
			strcpy(passd[nJ].password,strtok(NULL,":"));
			strcpy(passd[nJ].uid,strtok(NULL,":"));
			strcpy(passd[nJ].gid,strtok(NULL,":"));
			strcpy(passd[nJ].comments,strtok(NULL,":"));
			strcpy(passd[nJ].homedir,strtok(NULL,":"));
			strcpy(passd[nJ].shell,strtok(NULL,"\n"));
			
			nJ++;
			if (nJ > MAXUSERS) nJ = MAXUSERS;
		}
	}
	nUsers = nJ;
	
	if (!bFormat) printf("%0d users loaded from /etc/passwd.\n",nUsers);
	
	fclose(hPasswd);

	/**********************************
	*  Load user account information  *
	**********************************/
	if (!bFormat) printf("Loading user account information... ");

	hETR = fopen("/home/a7users/ss7gjobi/var/etr/etrfile.etr","r");
	if (!hETR) {
		printf("Error %d!  Couldn't open etrfile.etr!\n",errno);
		exit(1);
	}
	
	nJ = 0;
	nEOF = 0;
	while (!nEOF) {
		strcpy(cBuf,"");

		while (!nEOF && strcmp(cBuf,"[userdata]")) {
			if (fgets(cTmpBuf,sizeof(cTmpBuf),hETR) == NULL) nEOF = 1;
			strncpy(cBuf,cTmpBuf,strlen(cTmpBuf) - 1);
			cBuf[strlen(cTmpBuf) - 1] = 0;
		}
		
		/* Skip comments */
		for (nI = 0; nI < 8; nI++) fgets(cBuf,1024,hETR);
		
		/* Read [userdata] line */
		fgets(cTmpBuf,sizeof(cTmpBuf),hETR);
		strncpy(cBuf,cTmpBuf,strlen(cTmpBuf) - 1);
		cBuf[strlen(cTmpBuf) - 1] = 0;				
		
		strcpy(cTmpBuf,cBuf);		
		strcpy(user[nJ].userdata.name,strtok(cTmpBuf," "));
		strcpy(user[nJ].userdata.type,strtok(NULL," "));
		strcpy(user[nJ].userdata.area_group,strtok(NULL," "));
		strcpy(user[nJ].userdata.language,strtok(NULL," "));
		strcpy(user[nJ].userdata.time_locale,strtok(NULL," "));
		strcpy(user[nJ].userdata.collating_sequence_locale,strtok(NULL," "));
		strcpy(user[nJ].userdata.numeric_format_locale,strtok(NULL," "));
		strcpy(user[nJ].userdata.default_NAM_table,strtok(NULL," "));
		strcpy(user[nJ].userdata.default_PC_format,strtok(NULL," "));
		strcpy(user[nJ].userdata.default_link_format,strtok(NULL," "));
		
		/* Take quotes out of name */
		for (nI = 1; nI < strlen(user[nJ].userdata.name); nI++) {
			cBuf[nI - 1] = user[nJ].userdata.name[nI];
		}
		cBuf[nI - 2] = 0;
		strcpy(user[nJ].userdata.name,cBuf);
		
		/* Skip blank lines */
		for (nK = 0; nK < 3; nK++) fgets(cBuf,1024,hETR);
				
		/* Read [facilities] line */
		fgets(cBuf,sizeof(cBuf),hETR);

		/* Skip blank lines */
		for (nK = 0; nK < 6; nK++) fgets(cBuf,sizeof(cBuf),hETR);
				
		/* Read application permissions */
		nK = 0;
		while (strlen(cBuf) > 0 && cBuf[0] != EOF) {
			fgets(cTmpBuf,sizeof(cTmpBuf),hETR);
			strncpy(cBuf,cTmpBuf,strlen(cTmpBuf) - 1);
			cBuf[strlen(cTmpBuf) - 1] = 0;				
			
			strcpy(cTmpBuf,cBuf);
			
			if (strlen(cBuf) > 1) {
				strcpy(user[nJ].facilities[nK].application,strtok(cTmpBuf," "));
				strcpy(user[nJ].facilities[nK++].flags,strtok(NULL," "));
			}		
			strcpy(user[nJ].facilities[nK].application,"");
		}
				
		for (nI = 0; nI < nUsers; nI++) {
			if (!strcmp(user[nJ].userdata.name,passd[nI].username)) {
				strcpy(user[nJ].name,passd[nI].comments);
				nI = nUsers;
			}
		}
		
		nJ++;
	}

        if (!bFormat) printf(" %0d users loaded from ETR file.\n",nJ);

	fclose(hETR);
	
	/* Find users that still have accounts in /etc/passwd, but not in AcceSS7 */
	if (!bFormat) printf("Finding orphaned accounts...\n");
	
	system("rm -f orphans.dat");
	hOrphan = fopen("orphans.dat","w");
	if (!hOrphan) {
		printf("Error %d!  Can't open orphans.dat!\n",errno);
		exit(1);
	}

	nI = 0;
	while (nI < nUsers) {
		bFound = 0;
		for (nK = 0; nK < nJ; nK++) {
			if (!strcmp(user[nK].userdata.name,passd[nI].username)) {
				bFound = 1;
				nK = nJ;
			}
		}
		if (!bFound) {
/*			if (!bFormat) printf("%s\n",passd[nI].username);
*/
			fputs(passd[nI].username,hOrphan);
			fputs("\n",hOrphan);
		}
		nI++;
	}
	fclose(hOrphan);

	/* Collate User Data */
	for (nI = 0; nI < nUsers; nI++) {
		if (!bName) {
			strcpy(cName,user[nI].userdata.name);
		} else {
			while (nI < nUsers && strcmp(cName,user[nI].userdata.name)) nI++;
		}
		
		strcpy(cCommand,cHomeDir);
		strcat(cCommand,"/");
		strcat(cCommand,cName);

		if (!stat(cCommand,&st) && strlen(cName) > 0) {
		
			/* Make sure it's a directory */
			if (S_ISDIR(st.st_mode)) {

				strcat(cCommand,"/.dt/startlog");
				nResult = stat(cCommand,&st);

				if (nResult) {
					if (!bSuppress) printf("\nStat failed on %s! Error %0d.\n",cCommand,errno);
				} else {
					nDays = ((now - st.st_mtime) / 86400);
					
					/* Expire the password */
					if (bExpire && nDays >= nExpireDays) {

						/* Lock passwd file */
						stat("/etc/ptmp",&pwdfile);
						while (S_ISREG(pwdfile.st_mode)) {
							if (!bSuppress) printf("\n/etc/ptmp exists.  Sleeping for five seconds.\n");
							sleep(5);
							stat("/etc/ptmp",&pwdfile);
						}
						system("touch /etc/ptmp"); 
						
						/* Create a backup */
						system("cp /etc/passwd /etc/passwd.backup");
						
						/* Create a temp file to prevent dist_passwd from running */
						stat("/etc/passwd.dtmp",&pwdfile);
						while (S_ISREG(pwdfile.st_mode)) {
							if (!bSuppress) printf("\n/etc/passwd.dtmp exists.  Sleeping for five seconds.\n");
							sleep(5);
							stat("/etc/passwd.dtmp",&pwdfile);
						}
						system("cp /etc/passwd /etc/passwd.dtmp");
						
						/* Open password temp file */
						hPasswd = fopen("/etc/passwd.dtmp","r");
						
						/* Create new password file */
						hNewPasswd = fopen("/etc/passwd.new","w");
						
						nEOF = 0;
						while (nEOF == 0) {
							if (fgets(cBuf,sizeof(cBuf),hPasswd) == NULL) nEOF = 1;
							
							if (strlen(cBuf) > 10) {
								strcpy(cTmpBuf,cBuf);
								strcpy(pwd.username,strtok(cTmpBuf,":"));
								strcpy(pwd.password,strtok(NULL,":"));
								strcpy(pwd.uid,strtok(NULL,":"));
								strcpy(pwd.gid,strtok(NULL,":"));
								strcpy(pwd.comments,strtok(NULL,":"));
								strcpy(pwd.homedir,strtok(NULL,":"));
								strcpy(pwd.shell,strtok(NULL,"\n"));
								
								if (!strcmp(pwd.username,cName)) {
									/* Found the user, locking account */
									fputs(pwd.username,hNewPasswd);
									fputs(":*:",hNewPasswd);
									fputs(pwd.uid,hNewPasswd);
									fputs(":",hNewPasswd);
									fputs(pwd.gid,hNewPasswd);
									fputs(":",hNewPasswd);
									fputs(pwd.comments,hNewPasswd);
									fputs(":",hNewPasswd);
									fputs(pwd.homedir,hNewPasswd);
									fputs(":",hNewPasswd);
									fputs(pwd.shell,hNewPasswd);
									fputs("\n",hNewPasswd);
									
									printf("%s's account is expired!\n",cName);
								} else {
									/* Not our guy, copy info untouched */
									fputs(cBuf,hNewPasswd);
								}							
							}
							
						}						
						
						/* Close passwd file */
						fclose(hNewPasswd);
						fclose(hPasswd);
						
						/* Copy new password file into place */
						system("cp -f /etc/passwd.new /etc/passwd");
						
						/* Unlock passwd file */
						system("rm -f /etc/ptmp");
						
						/* Remove passwd.dtmp file */
						system("rm -f /etc/passwd.dtmp");

						
					}
					
					if (nDays >= nMaxDays) {
						if (bFormat == 1) {
							printf("%s\t%0d\t%s\n",cName,nDays,user[nI].name);
						} else {
							printf("\nName: %s\n",cName);
							printf("Real Name: %s\n",user[nI].name);
							printf("Department: ");
							
							strcpy(cDeptName2,user[nI].name);
							strcpy(cDeptName,strtok(cDeptName2,","));
							strcpy(cDeptName,strtok(NULL,","));
							
							if (!strncmp("ss7g",cName,4)) {
								printf("AcceSS7 Group\n");
							} else if (!strncmp("sssc",cName,4)) {
								printf("SS7 Management Center\n");
							} else if (!strncmp("hpus",cName,4)) {
								printf("Agilent Support\n");
							} else if (!strncmp("agil",cName,4)) {
								printf("Agilent Support\n");
							} else if (!strncmp("insd",cName,4)) {
								printf("ION Service & Delivery\n");
							} else if (!strncmp("spcs",cName,4)) {
								printf("Sprint PCS\n");
							} else if (!strncmp("ssip",cName,4)) {
								printf("Switch Service Planning\n");
							} else if (!strncmp("swop",cName,4)) {
								printf("Switch Operations\n");
							} else if (!strncmp("ntac",cName,4)) {
								printf("NTAC\n");
							} else if (!strncmp("bsot",cName,4)) {
								printf("Transmissions\n");
							} else if (!strncmp("uofe",cName,4)) {
								printf("Univ. of Excellence\n");
							} else {
								printf("Unknown Department\n");
							}
							
							if (strlen(cDeptName) < 1) strcpy(cDeptName,"Unknown Department");
							printf("New Dept: %s\n",cDeptName);
							
							printf("Area Group: %s\n",user[nI].userdata.area_group);
							printf("Last Access: %s\n",gettime(&st.st_atime));
							printf("Last Modify: %s\n",gettime(&st.st_mtime));
							printf("Account Age: %0d days.\n",nDays);
							printf("Applications\n------------\n");

							nJ = 0;
							while (strlen(user[nI].facilities[nJ].application) > 0) {
								if(!strcmp(user[nI].facilities[nJ].application,"NC")) {
									printf("XXX %s\t",cName);
								}
								printf("%s \tAccess",user[nI].facilities[nJ].application);
								
							 	strcpy(cTmpBuf,user[nI].facilities[nJ].flags);
							 	
							 	nK = 0;
							 	nLen = 0;
								while (strlen(cTmpBuf) > 1) {
									if (nK == 0) {
										strcpy(flags[nK].flag,strtok(cTmpBuf,";"));
									} else {
										strcpy(flags[nK].flag,strtok(NULL,";"));
									}

									if (strlen(flags[nK].flag) < 1) {
										strcpy(cTmpBuf,"");
									} else {
										if (nLen > 60) {
											printf(",\n\t");
											nLen = 0;
										} else {
											printf(", ");
										}
										if (!strcmp(flags[nK].flag,"CC")) { 
											printf("Credit Card");
											nLen += 11;
										} else if (!strcmp(flags[nK].flag,"COMOBJ")) { 
											printf("Manage Common Objects");
											nLen += 21;
										} else if (!strcmp(flags[nK].flag,"EXTAPPS")) { 
											printf("External Applications");
											nLen += 21;
										} else if (!strcmp(flags[nK].flag,"PIN")) { 
											printf("PIN Number");
											nLen += 10;
										} else if (!strcmp(flags[nK].flag,"QUOTA")) { 
											printf("Manage User Quotas");
											nLen += 18;
										} else if (!strcmp(flags[nK].flag,"SESSN")) { 
											printf("Manage Active Sessions");
											nLen += 22;
										} else if (!strcmp(flags[nK].flag,"SMS")) { 
											printf("Display SMS Data");
											nLen += 16;
										} else if (!strcmp(flags[nK].flag,"VTN")) { 
											printf("Display Full Telephone Number");
											nLen += 29;
										} else if (!strcmp(flags[nK].flag,"ALT")) { 
											printf("Alternative Status Mapping");
											nLen += 26;
										} else if (!strcmp(flags[nK].flag,"ACK")) { 
											printf("Acknowledge Alarms");
											nLen += 18;
										} else if (!strcmp(flags[nK].flag,"CLR")) { 
											printf("Clear Alarms");
											nLen += 12;
										} else if (!strcmp(flags[nK].flag,"API")) { 
											printf("Programmatic Schedule");
											nLen += 21;
										} else if (!strcmp(flags[nK].flag,"DP")) { 
											printf("Modify Personality");
											nLen += 18;
										} else if (!strcmp(flags[nK].flag,"P1")) { 
											printf("Realtime Priority");
											nLen += 17;
										} else if (!strcmp(flags[nK].flag,"P2")) { 
											printf("High Priority");
											nLen += 13;
										} else if (!strcmp(flags[nK].flag,"P3")) { 
											printf("Medium Priority");
											nLen += 15;
										} else if (!strcmp(flags[nK].flag,"P4")) { 
											printf("Low Priority");
											nLen += 12;
										} else if (!strcmp(flags[nK].flag,"NAM")) { 
											printf("Generate Alarms");
											nLen += 15;
										} else if (!strcmp(flags[nK].flag,"DSTD")) { 
											printf("Store to Disk");
											nLen += 13;
										} else if (!strcmp(flags[nK].flag,"CLC")) { 
											printf("Change Local Thresholds");
											nLen += 23;
										} else if (!strcmp(flags[nK].flag,"DAH")) { 
											printf("Static Default AH Display");
											nLen += 25;
										} else if (!strcmp(flags[nK].flag,"MUS")) { 
											printf("Open Multiple Sessions");
											nLen += 22;
										} else if (!strcmp(flags[nK].flag,"ULC")) { 
											printf("Use Local Thresholds");
											nLen += 20;
										}
									}
									nK++;
								}
								nJ++;
								printf("\n");
							}
							printf("\n");
						}
					}
				}
			}
		}
		if (bName || strlen(cName) < 1) nI = nUsers;
	}
			
	return 0;
}
