/*
	etrload.c
	4-12-01 by Jon Bieker
	(c)2001 Sprint
	
*/

#include "../include/include.h"
	
int main() 
{

	char c[2], cBuf[256], cTmpBuf[256];
	int nI, nJ, nLine, nObjectLine, nFlag, nSP, nResult, nEOF, nLinks;
	int nLinksets, hslinks, v35links;
	int hEtr, hEtrOut;
	
	struct linkset linkset;
	struct sp sp[2000];
	struct newlink newlink;
	struct link link;
	struct v35culinkinterface v35culinkinterface;
	struct hsiclinkinterface hsiclinkinterface;

	printf("Etrload\n");
	printf("4-12-01 by Jon Bieker\n");
	printf("(c)2001 Sprint\n\n");

	/****************
	*  Init Arrays  *
	****************/
	for (nI = 0; nI < 256; nI++) {
		if (nI < 256) {
			cBuf[nI] = 0;
			cTmpBuf[nI] = 0;
		}
	}
	
	/******************
	*  Copy ETR File  *
	******************/
	printf("Creating backup copy of ETR file...\n");
	strcpy(cBuf,"cp ../etr/etrfile.etr ../etr/etrfile.bak");
	system(cBuf);
	
	printf("Compressing backup ETR file (process will execute in background)...\n");
	strcpy(cBuf,"rm -f ../etr/etrfile.bak.Z");
	system(cBuf);
	strcpy(cBuf,"compress ../etr/etrfile.bak &");
	system(cBuf);
		
	/******************
	*  Open ETR File  *
	******************/
	hEtr = open("../etr/etrfile.etr",O_RDONLY);
	if (hEtr == -1) {
		printf("Error %0d!  Couldn't open ETR file!\n",errno);
		exit(1);
	} else {
		nEOF = lseek(hEtr,0,SEEK_END);
		lseek(hEtr,0,SEEK_SET);
	}

	
	/**************
	*  Main Loop  *
	**************/
	nLine = 0;
	nObjectLine = 0;
	nFlag = 0;
	nSP = 0;

	printf("Loading signaling points...\n");
	/* Find the [signalingpoints] section. */
	while (strcmp(cBuf,"[signalingpoints]")) strcpy(cBuf,readline(&hEtr));

	/* Skip past the comments */
	for(nI = 0; nI < 7; nI++) strcpy(cBuf,readline(&hEtr));

	strcpy(cBuf,"\"\0");
	while (cBuf[0] == 34) {
		strcpy(cBuf,readline(&hEtr));
			
		strcpy(cTmpBuf,cBuf);
		for (nI = 0; nI < 8; nI++) {
			switch (nI) {
				case 0:
					strcpy(sp[nSP].name,strtok(cTmpBuf," "));
					/* Extra handling for spaces in name */
					if (sp[nSP].name[strlen(sp[nSP].name) - 1] != 34) {
						strcat(sp[nSP].name," ");
						strcat(sp[nSP].name,strtok(NULL," "));
					}
					break;
				case 1:
					strcpy(sp[nSP].altname,strtok(NULL," "));
					/* Extra handling for spaces in altname */
					if (sp[nSP].altname[strlen(sp[nSP].altname) - 1] != 34) {
						strcat(sp[nSP].altname," ");
						strcat(sp[nSP].altname,strtok(NULL," "));
					}
					break;
				case 2:
					strcpy(sp[nSP].pointcode,strtok(NULL," "));
					break;
				case 3:
					strcpy(sp[nSP].type,strtok(NULL," "));
					break;
				case 4:
					strcpy(sp[nSP].capcode,strtok(NULL," "));
					break;
				case 5:
					strcpy(sp[nSP].site,strtok(NULL," "));
					break;
				case 6:
					strcpy(sp[nSP].flag,strtok(NULL," "));
					break;
				case 7:
					strcpy(sp[nSP].class,strtok(NULL," "));
					break;
			}
		}
		if (strlen(sp[nSP].name) > 1) {
			printf("Name: %s                 \r",sp[nSP].name);
/*			printf("Alternate Name: %s\n",sp[nSP].altname);
			printf("Point Code: %s\n",sp[nSP].pointcode);
			printf("Link Type: %s\n",sp[nSP].type);
			printf("Capability Code: %s\n",sp[nSP].capcode);
			printf("Site: %s\n",sp[nSP].site);
			printf("Flag: %s\n",sp[nSP].flag);
			printf("Class: %s\n\n",sp[nSP].class);
*/			nSP++;
		}
	}		

	/* Locate Links */
	nLinks = 0;
	nLinksets = 0;
	hslinks = 0;
	v35links = 0;
	while (lseek(hEtr,0,SEEK_CUR) < nEOF) {
		/* Look for [linkset]... */
		strcpy(cBuf,"1\0");
		while (strcmp(cBuf,"[linkset]") \
			&& lseek(hEtr,0,SEEK_CUR) < nEOF \
			&& *strstr(cBuf,"###") < 1) \
			strcpy(cBuf,readline(&hEtr));
		
		if (!strcmp(cBuf,"[linkset]")) {
			getlinkset(&hEtr,&linkset);

/*			printf("Monitored SP:\t%s\n",linkset.monsp);
			printf("Remote SP:\t%s\n",linkset.remsp);
			printf("Link Type:\t%s\n",linkset.linktype);
			printf("Normalization Factor:\t%s\n",linkset.norm);
*/			printf("\nLinkset: %s\n",linkset.name);

			nLinksets++;
		}

		/* Get all links until the next [linkset] and before EOF */
		strcpy(cBuf,"1\0");
		while (strcmp(cBuf,"[linkset]") \
			&& lseek(hEtr,0,SEEK_CUR) < nEOF \
			&& *strstr(cBuf,"###") < 1) {
			
			strcpy(cBuf,readline(&hEtr));

			/* Look for [link]... */
			while (strcmp(cBuf,"[link]") \
				&& lseek(hEtr,0,SEEK_CUR) < nEOF \
				&& strcmp(cBuf,"[linkset]") \
				&& *strstr(cBuf,"###") < 1) \
				strcpy(cBuf,readline(&hEtr));

			if (!strcmp(cBuf,"[link]")) {
				/* Read link info */
				getlink(&hEtr,&link);
				
				printf("SLC: %s Link Name: %s\n",link.slc,link.name);
				
				/* Read blank line */
				strcpy(cBuf,readline(&hEtr));
				
				/* Read link monitoring type */
				strcpy(cBuf,readline(&hEtr));
				
				/* Read link monitoring info */
				if (!strcmp(cBuf,"[v35culinkinterface]")) {
					getv35if(&hEtr,&v35culinkinterface);
					v35links++;

/*					printf("[v.35] Site:%s CC:%s Slot:%s CU:%s Conn:%s\n",v35culinkinterface.site,v35culinkinterface.cardcage,v35culinkinterface.ifslot,v35culinkinterface.concentrator,v35culinkinterface.cuconnector);
*/
				} else if (!strcmp(cBuf,"[hsiclinkinterface]")) {
					gethsicif(&hEtr,&hsiclinkinterface);
					hslinks++;

/*					printf("[hsic] Site:%s PP:%s ChAhsic:%s ChAbearer:%s ChBhsic:%s ChBbearer:%s Linktype:%s\n",hsiclinkinterface.site,hsiclinkinterface.probeproc,hsiclinkinterface.chAhsic,hsiclinkinterface.chAbearer,hsiclinkinterface.chBhsic,hsiclinkinterface.chBbearer,hsiclinkinterface.linktype);
*/
				}
				
				nLinks++;
			}
		}
		
		/* Move fileptr back so we catch the next linkset */
		if (lseek(hEtr,0,SEEK_CUR) < nEOF) lseek(hEtr,-11,SEEK_CUR);
	}

	printf("\n");
	printf("%0d signaling points.\n",nSP);
	printf("%0d linksets.\n",nLinksets);
	printf("%0d links (%0d HS, %0d v.35).\n\n",nLinks,hslinks,v35links);
	
	close(hEtr);
	
	return 0;	
}