/*
    loadping.c
    
    4-16-03 by Jon Bieker
    (c)2003 Sprint

*/

/* Includes */
#include <dirent.h>
#include <libpq-fe.h>
#include <stdio.h>
#include <string.h>
#include <time.h>
#include <zlib.h>

/* Globals variables */
PGconn *log;
PGresult *result;

struct line {
  char ifpc[25];
  int ms;
};

struct datetime {
  char dow[4];
  char mon[4];
  char dom[3];
  char time[9];
  char year[6];
};

main (int argc, char *argv[])
{

  char command[1024], commands[216000];
  char filename[50], cBuf[1024], cTmpBuf[1024], hostname[25];
  char date[11], time[9];
  char nEOF;
  int n, nI, nBytes, nTimes;
  struct line sLine;
  struct datetime sDatetime;
  
  DIR *dirp;
  gzFile hFile;
  
  struct dirent *dp;
  
  /* Connect to database */
  log = PQconnectdb("hostaddr=172.20.206.55 dbname=log user=postgres");

  /* Make sure we're connected to the DB */
  if (PQstatus(log)) {
    PQfinish(log);
    printf("Couldn't connect to database!\n");
    exit(1);
  }

  dirp = opendir("/home/a7users/ss7gjobi/src/ifpcping/");
  strcpy(commands,"");
  nTimes = 0;
  while ((dp = readdir(dirp)) != NULL) {

    // Make sure it's the kind of file we want
    if(!strncmp(dp->d_name,"pings_m7",8)) {  
    
      // Get the hostname.
      strcpy(cBuf,dp->d_name);
      strcpy(cTmpBuf,strtok(cBuf,"_"));
      strcpy(hostname,strtok(NULL,"."));
      
      strcpy(filename,"/home/a7users/ss7gjobi/src/ifpcping/");
      strncat(filename,dp->d_name,strlen(dp->d_name));
      printf("Processing: %s ...",filename);
      fflush(stdout);
      
      hFile = gzopen(filename,"rb");

      // Read date and load datetime struct.
      gzgets(hFile,cBuf,sizeof(cBuf));

      if (strlen(cBuf) > 0) {
        strcpy(cTmpBuf,cBuf);      

        strcpy(sDatetime.dow,strtok(cTmpBuf," "));
        strcpy(sDatetime.mon,strtok(NULL," "));
        strcpy(sDatetime.dom,strtok(NULL," "));
        strcpy(time,strtok(NULL," "));
        strcpy(sDatetime.year,strtok(NULL," "));

        // Remove CR since the year is the last element of the string.
        sDatetime.year[4] = 0x00;
        
        strcpy(date,sDatetime.year);
        strcat(date,"-");
        
        if (!strcmp(sDatetime.mon,"Jan")) {
            strcat(date,"01-");
        } else if (!strcmp(sDatetime.mon,"Feb")) {
            strcat(date,"02-");
        } else if (!strcmp(sDatetime.mon,"Mar")) {
            strcat(date,"03-");
        } else if (!strcmp(sDatetime.mon,"Apr")) {
            strcat(date,"04-");
        } else if (!strcmp(sDatetime.mon,"May")) {
            strcat(date,"05-");
        } else if (!strcmp(sDatetime.mon,"Jun")) {
            strcat(date,"06-");
        } else if (!strcmp(sDatetime.mon,"Jul")) {
            strcat(date,"07-");
        } else if (!strcmp(sDatetime.mon,"Aug")) {
            strcat(date,"08-");
        } else if (!strcmp(sDatetime.mon,"Sep")) {
            strcat(date,"09-");
        } else if (!strcmp(sDatetime.mon,"Oct")) {
            strcat(date,"10-");
        } else if (!strcmp(sDatetime.mon,"Nov")) {
            strcat(date,"11-");
        } else if (!strcmp(sDatetime.mon,"Dec")) {
            strcat(date,"12-");
        }
        
        strcat(date,sDatetime.dom);
        
        strcpy(commands,"");
            
        while (!gzeof(hFile)) {
      
          gzgets(hFile,cBuf,sizeof(cBuf));

          if (strlen(cBuf) > 0) {

            strcpy(cTmpBuf,cBuf);
        
            strcpy(sLine.ifpc,strtok(cTmpBuf,":"));        
            sLine.ms = atoi(strtok(NULL," "));
        
            // Check to see if the record is already in the database.
            strcpy(command,"select count(id) from ping where date='");
            strcat(command,date);
            strcat(command,"' and time='");
            strcat(command,time);
            strcat(command,"' and ifpc='");
            strcat(command,sLine.ifpc);
            strcat(command,"' and hostname='");
            strcat(command,hostname);
            strcat(command,"';");

            result = PQexec(log,command);
        
            if (!result || PQresultStatus(result) != PGRES_TUPLES_OK) {
              printf("Command failed! Code %0d Exiting...\n",PQresultStatus(result));
              closedir(dirp);
              PQfinish(log);
              exit(1);
            }

            if (strcmp(PQgetvalue(result,0,0),"0") == 0) {
              strcat(commands,"insert into ping (date,time,hostname,ifpc,ms) values ('");
              strcat(commands,date);
              strcat(commands,"','");
              strcat(commands,time);
              strcat(commands,"','");
              strcat(commands,hostname);
              strcat(commands,"','");
              strcat(commands,sLine.ifpc);
              strcat(commands,"','");
              strcat(commands,(char *) ltoa(sLine.ms));
              strcat(commands,"');");
              nTimes++;              
            }
        
            PQclear(result);
          
//            if (nTimes > 1000) {
//              printf(" Committing %0d records...",nTimes);
              fflush(stdout);
              result = PQexec(log,commands);
              strcpy(commands,"");
              PQclear(result);
              nTimes = 0;
//            }
          }        
        }
      } else {
        printf(" No more records.\n");
      }
      gzclose(hFile);
      printf("\n");
    }
  }

  if (strlen(commands) > 0) {
            printf("Committing final records...\n");
            result = PQexec(log,commands);
            strcpy(commands,"");
            PQclear(result);  
  }
  
  closedir(dirp);

  PQfinish(log);

  printf("Done!\n");
  
  exit(0);
}

