/*
	linkmap
	4-18-01 by Jon Bieker
	(c)2001 Sprint
	
	Linkmap - linkmap generation tool.
*/

#include <stdio.h>
#include "/home/a7users/ss7gjobi/src/include/include.h"

#define MAXLINKS 1200

struct map {
	char physcu;
	char iphyscu;
	char cc;
	char icc;
	char ifslot;
	char cu;
	char icu;
	char input;
	char ifpc;
	char iifpc;
};

int showblurb() {

	printf("Linkmap - Link map generation tool.\n");
	printf("4-18-01 by Jon A. Bieker\n");
	printf("(c)2001 Sprint\n\n");
	
	return 0;
}

int showhelp() {
	showblurb();
	printf("Options:\n");
	printf("\t-a\tAlternate format for SCP and Int'l Links\n");
	printf("\t-h\tHelp (this screen)\n");
	printf("\t-q\tQuiet (no blurb/headers)\n");
	return 0;
}

struct links {
	int	link;	
};

int main(argc,argv) 
int argc;
char *argv[];
{
	char bSngLine, cBuf[256], bAlt;
	int nMax, nI, nJ, nSite, nE, nStart;

	struct links links[MAXLINKS];	
	struct map map;

	int showhelp();
	int showblurb();

	strcpy(cBuf,"");
	for (nI = 1; nI < argc; nI++) {
		strcat(cBuf,argv[nI]);
		strcat(cBuf," ");
	}
	uselog(argv[0],cBuf);
	
	nSite = 0;
	nMax = 0;
	nE = 0;
	bSngLine = 0;
	for (nI = 0; nI < (argc + 1); nI++) {
		if (!strcmp(argv[nI],"-q")) {
			bSngLine = 1;
		} else if (!strcmp(argv[nI],"-h")) {
			showhelp();
			exit(0);
		} else if (!strcmp(argv[nI],"-a")) {
			bAlt = 1;
		} else {
			if (nE < (MAXLINKS + 1) && nI > 0) {
				links[nE++].link = atoi(argv[nI]);
			}
		}
	}

	if (nE < 1) links[0].link = 0;

	if (!bSngLine) {
		showblurb();
		if (bAlt == 1) printf("Using alternate format for SCP and Int'l links.\n\n");
		printf("Link #\tPhys CU\tCC #\tIF Slot\tCU #\tInput\tIFPC Slot\n");
	}

	for (nJ = 0; nJ < nE; nJ++) {
	
		nMax = links[nJ].link;

		if (nJ > 0 && nMax == 0) return 0;
		
		map.physcu = 1;
		map.cc = 1;
		map.ifslot = 11;
		map.cu = 0;
		map.input = 1;
		map.ifpc = 0;
	
		map.iphyscu = 0;
		map.icc = 0;
		map.icu = 0;
		map.iifpc = 0;
		
		if (bAlt == 0) {
			nStart = 0;
		} else {
			nStart = 1;
		}

		for (nI = nStart; nI < (nMax > 0 ? nMax : (MAXLINKS + 1)); (bAlt == 0 ? nI += 2 : nI++)) {
			if (!nMax) printf("%0d\t%0d\t%0d\t%0d\t%0d\t%0d\t%0d\n",nI,map.physcu,map.cc,map.ifslot,map.cu,map.input,map.ifpc);
		
			map.icc++;
			if (map.icc > 63) {
				map.cc++;
				map.icc = 0;
			}
		
			map.icu++;
			if (map.icu > 15) {
				map.cu++;
				if (map.cu > 3) map.cu = 0;
				map.icu = 0;
			} 
		
			map.input++;
			if (map.input > 16) {
				map.input = 1;
			}
		
			map.iifpc++;
			if (map.iifpc > 7) {
				map.ifpc++;
				if (map.ifpc > 7) map.ifpc = 0;
				map.iifpc = 0;	
			}
		
			map.iphyscu++;
			if (map.iphyscu > 15) {
				map.iphyscu = 0;
				map.physcu++;
			}
		}	

		if (nMax) printf("%0d\t%0d\t%0d\t%0d\t%0d\t%0d\t%0d\n",nI,map.physcu,map.cc,map.ifslot,map.cu,map.input,map.ifpc);
	}
	
	return 0;
}