/*
	motd - Message of the Day reader
	6-14-01 by Jon A. Bieker
	(c)2001 Sprint
*/

#include <fcntl.h>
#include <sys/stat.h>
#include <stdio.h>
#include <string.h>
#include "/home/a7users/ss7gjobi/src/include/include.h"

int main() {
	int hFile, nI, nJ, nBytes;
	char * cMsg;
	char cBuf[1024];
	struct stat stat_p;
	struct tm tm;
	time_t now;

	uselog("motd","");	
	
	/* Check for '/etc/motd' */
	stat("/etc/motd",&stat_p);

	if (stat_p.st_size < 1) {
	
		/* No /etc/motd, so check for 'important.msg' */
		stat("/home/a7users/important.msg",&stat_p);
		
		if (stat_p.st_size < 1) {
			/* exit quietly... */
			exit(1);
		} else {
			hFile = open("/home/a7users/important.msg",O_RDONLY);
		}
	} else {
		hFile = open("/etc/motd",O_RDONLY);
	}

	/* Allocate space for the message */
	cMsg = (char *) malloc(stat_p.st_size + 1);
	
	/* Make sure it worked */
	if (cMsg == NULL) exit(1);
	
	/* Read the message & pack it into the space we've allocated */
	nJ = 0;
	nBytes = 1;
	while (nBytes > 0) {
		nBytes = read(hFile,cBuf,1);
		
		memcpy(cMsg + nJ++,cBuf,1);

		/* Make sure we don't buffer overflow */
		if (nJ > stat_p.st_size + 1) {
			free(cMsg);
			exit(1);
		}
	}


	/* Done with the file, so we might as well close it */		
	close(hFile);

	/* Put a 0x00 at the end of our memory buffer so we can use it
	   like a string.
	*/
	memcpy(cMsg + nJ - 1,0x00,1);
	
	printf("%s\n\n",cMsg);
	
	printf("This message will close in 60 seconds.\n");
	
	/* Count down timer & keypress exit routine */
	nJ = 60;
/*	while (nJ > 0) {
		now = time((time_t *)NULL);
		while (difftime(time((time_t *)NULL),now) < 1);

		nJ--;
	}
*/
	sleep(nJ);
		
	printf("\n");
	/* Clean house before we exit */
	free(cMsg);
	
	return 0;
}