#!/usr/bin/perl -w

# check_ntp.pl
# 7-9-03 by Jon Bieker
# (c)2003 Sprint

print "Getting probes...\n";
my @probes = `/opt/platform7/lbin/list_processors -p`;

print "Getting sites...\n";
my @sites = `/opt/platform7/lbin/list_processors -s`;

print "Getting workstations...\n";
my @workstations = `/opt/platform7/lbin/list_processors -w`;


foreach $w (@workstations) {
  chop $w;

  if ($w ne "m7ss7sw1") {
    printheader($w);
    getfiles($w);
    showfiles();
    print "\n"; 
  }
}

foreach $w (@sites) {
  chop $w;

  printheader($w);
  getfiles($w);
  showfiles();
  print "\n"; 
}

foreach $w (@probes) {
  chop $w;

  printheader($w);
  getfiles($w);
  showfiles();
  print "\n"; 
}

#finis
exit(0);

##################
# Subroutines

sub printheader {
  $server = $_[0];

  for ($nI = 0; $nI < length($server) + 2; $nI++) {
    print "-";
  }  
  print "\n|$server|\n";
  for ($nI = 0; $nI < length($server) + 2; $nI++) {
    print "-";
  }
  print "\n";
}

sub getfiles {
  $server = $_[0];
  
  unlink <"TIMEZONE">;
  unlink <"ntp.conf">;
  
  system("rcp $server:/etc/TIMEZONE .");
  system("rcp $server:/etc/ntp.conf ."); 
}

sub showfiles {
  print "TIMEZONE:\n";
  
  open(hFile,"<TIMEZONE");
  while (<hFile>) {
    print $_;
  }
  close(hFile);
  
  print "\n\nntp.conf:\n";
  
  open(hFile,"<ntp.conf");
  while (<hFile>) {
    print $_;
  }
  close(hFile);
}
