#!/usr/bin/perl -w

# p7getdate.pl
# 8-6-01 by Jon Bieker

my ($date,$day,$month,$dom,$time,$timezone,$year,$hr,$min,$sec);

sub check_date {
	# Get current date

	$date = `remsh $_[0] date`;
	($day2,$month2,$dom2,$time2,$timezone2,$year2) = split(/ /,$date);	
	
	if ($time2) {
		chop $year2;
		($hr2,$min2,$sec2) = split(/:/,$time2);
		print "$_[0]: \t$day2 $month2 $dom2, $year2 $hr2:$min2:$sec2 $timezone2\tTime is ";
	
		if ($hr = $hr2 
			&& $timezone eq $timezone2
			&& $day eq $day2
			&& $month eq $month2
			&& $year == $year2
			&& $dom == $dom2 ) {
		
			print "correct.\n";
		} else {
			print "INCORRECT.\n";
		}
	}
}

# Get current date from m7server
$date = `date`;
($day,$month,$dom,$time,$timezone,$year) = split(/ /,$date);
($hr,$min,$sec) = split(/:/,$time);
chop $year;

print "Workstations\n------------\n";
@workstations = `/opt/platform7/lbin/list_processors -w`;
foreach $w (@workstations) {
	check_date($w);
}

print "\nSite Processors\n---------------\n";
@site_processors = `/opt/platform7/lbin/list_processors -s`;
foreach $s (@site_processors) {
	check_date($s);
}

print "\nProbe Processors\n----------------\n";
@probe_processors = `/opt/platform7/lbin/list_processors -p`;
foreach $p (@probe_processors) {
	check_date($p);
}

#finis
exit(0);
