#include <stdio.h>
#include <errno.h>
#include <sys/time.h>
#include <sys/param.h>
#include <sys/socket.h>
#include <sys/file.h>
#include <signal.h>	/* added by jon */
#include <netinet/in_systm.h>
#include <netinet/in.h>
#include <netinet/ip.h>
#include <netinet/ip_icmp.h>
#include <netdb.h>

#define	MAXPACKET	4096	/* max packet size */
#ifndef MAXHOSTNAMELEN
#define MAXHOSTNAMELEN	64
#endif

u_char	packet[MAXPACKET];
int s, ident, datalen;
struct timezone tz;	/* leftover */
struct sockaddr whereto;/* Who to ping */
char *inet_ntoa();
int ntransmitted = 0;		/* sequence # for outbound packets = #sent */
int nreceived = 0;		/* # of packets we got back */
int finish();

main(argc, argv)
char *argv[];
{
	struct sockaddr_in from;
	char **av = argv;
	struct sockaddr_in *to = (struct sockaddr_in *) &whereto;
	struct protoent *proto;

	if (strlen(argv[1]) > 0) {
		strcpy(av[0],argv[1]);
	} else {
		printf("No Destination!\n");
		exit(1);
	}
	
	bzero( (char *)&whereto, sizeof(struct sockaddr) );
	to->sin_family = AF_INET;
	to->sin_addr.s_addr = inet_addr(av[0]);
	
	datalen = 56;	/* added by jon */
	
	ident = getpid() & 0xFFFF;
	
	if ((proto = getprotobyname("icmp")) == NULL) {
		fprintf(stderr, "icmp: unknown protocol\n");
		exit(10);
	}
	if ((s = socket(AF_INET, SOCK_RAW, proto->p_proto)) < 0) {
		perror("ping: socket");
		exit(5);
	}
	
	pinger();

	for (;;) {
		int fromlen = sizeof (from);
		int cc;

		alarm(1);
		
		if ( (cc=recvfrom(s, packet, sizeof(packet), 0, &from, &fromlen)) < 0) {
			if( errno == EINTR ) continue;
			perror("ping: recvfrom");
			continue;
		}
		pr_pack( packet, cc, &from );
		if (nreceived >= 1) finish();
	}
}

pinger()
{
	static u_char outpack[MAXPACKET];
	register struct icmp *icp = (struct icmp *) outpack;
	int i, cc;
	register struct timeval *tp = (struct timeval *) &outpack[8];
	register u_char *datap = &outpack[8+sizeof(struct timeval)];

	icp->icmp_type = ICMP_ECHO;
	icp->icmp_code = 0;
	icp->icmp_cksum = 0;
	icp->icmp_seq = ntransmitted++;
	icp->icmp_id = ident;		/* ID */

	cc = datalen+8;			/* skips ICMP portion */

	gettimeofday( tp, &tz );

	for( i=8; i<datalen; i++) *datap++ = i; /* skip 8 for time */

	icp->icmp_cksum = in_cksum( icp, cc );

	i = sendto( s, outpack, cc, 0, &whereto, sizeof(struct sockaddr) );

	if( i < 0 || i != cc )  {
		if( i<0 )  perror("sendto");
		printf("ping: wrote %d chars, ret=%d\n", cc, i );
		fflush(stdout);
	}
}


pr_pack( buf, cc, from )
char *buf;
int cc;
struct sockaddr_in *from;
{
	struct ip *ip;
	register struct icmp *icp;
	struct timeval tv;
	struct timeval *tp;
	int hlen, triptime;

	from->sin_addr.s_addr = ntohl( from->sin_addr.s_addr );
	gettimeofday( &tv, &tz );

	ip = (struct ip *) buf;
	hlen = ip->ip_hl << 2;
	if (cc < hlen + ICMP_MINLEN) return;
	cc -= hlen;
	icp = (struct icmp *)(buf + hlen);
	if( icp->icmp_type != ICMP_ECHOREPLY )  {
		return;
	}
	if( icp->icmp_id != ident ) return;

	tp = (struct timeval *)&icp->icmp_data[0];
	printf("%d bytes from %s: ", cc, inet_ntoa(ntohl(from->sin_addr.s_addr)));
	printf("icmp_seq=%d. ", icp->icmp_seq );

	tvsub( &tv, tp );
	triptime = tv.tv_sec*1000+(tv.tv_usec/1000);
	printf("time=%d. ms\n", triptime );

	nreceived++;
}

in_cksum(addr, len)
u_short *addr;
int len;
{
	register int nleft = len;
	register u_short *w = addr;
	register u_short answer;
	register int sum = 0;
	u_short odd_byte = 0;

	while( nleft > 1 )  {
		sum += *w++;
		nleft -= 2;
	}

	if( nleft == 1 ) {
		*(u_char *)(&odd_byte) = *(u_char *)w;
		sum += odd_byte;
	}

	sum = (sum >> 16) + (sum & 0xffff);	/* add hi 16 to low 16 */
	sum += (sum >> 16);			/* add carry */
	answer = ~sum;				/* truncate to 16 bits */
	return (answer);
}

tvsub( out, in )
register struct timeval *out, *in;
{
	if( (out->tv_usec -= in->tv_usec) < 0 )   {
		out->tv_sec--;
		out->tv_usec += 1000000;
	}
	out->tv_sec -= in->tv_sec;
}

finish()
{
	printf("%d packets transmitted, ", ntransmitted );
	printf("%d packets received, ", nreceived );
	if (ntransmitted) printf("%d%% packet loss",(int) (((ntransmitted-nreceived)*100) / ntransmitted ) );
	printf("\n");
	fflush(stdout);
	exit(0);
}
