/*
	prv.c
	4-20-01 by Jon Bieker
	(c)2001 Sprint
	
*/

#include "../include/include.h"
	
struct pcs {
	char monsp[12];
	char remsp[12];
	char type[2];
	char linkset[7];
	char slc[3];
	char name[25];
	char altname[25];
	char status[25];
	char linknumber[5];
	char fmsstatus[25];
	int etrloc;
};

struct ipr {
	char linktype[2];
	char priority[5];
	char ordertype[10];
	char pointcode[12];
	char cityst[25];
	char fmsnumber[15];
	char linkset[7];
	char slc[3];
	char linknumber[5];
	char stp[4];
	char scp[4];
	char order[2];
	char custwantdate[11];
	char fmsstatus[25];
	char fmsstatusdate[11];
	char status[25];
	char statusdate[11];
	char notes1[256];
	char notes2[256];
	int etrloc;
};

int main() 
{

	char cBuf[1024], cPCSBuf[1024], cETRBuf[1024];
	char lFound, lEOF;
	int nI, nJ, nResult, nTotalLinks, nLinksChanged, nLinkLoc, nTmpLoc, nEOF, nIPRLinks;
	int hEtrIn, hLinksIn;
	struct pcs pcs[1024];
	struct ipr ipr[1024];
	struct link link;

/*	char *readline();
	int lock_network_config();
	int unlock_network_config();
*/
	printf("PRV\n");
	printf("4-20-01 by Jon Bieker\n");
	printf("(c)2001 Sprint\n\n");

	/****************
	*  Init Arrays  *
	****************/	
	for (nI = 0; nI < 1024; nI++) {
		if (nI < 1024) {
			cBuf[nI] = 0;
			cPCSBuf[nI] = 0;
			cETRBuf[nI] = 0;
		}
	}


	/* Lock Network Config */
/*	if (lock_network_config()) {
		printf("Error! Couldn't lock network config!\n");
		exit(1);
	}
*/
	/*******************************
	*  Read Install Problem Report *
	*******************************/	
	printf("Opening Install Problem Report file... ");
	hLinksIn = open("install_problem_report.txt",O_RDONLY);
	if (hLinksIn == -1) {
		printf("Error %0d!  Couldn't open install_problem_report.txt!\n",errno);
		exit(1);
	} else {
		printf("Done. File #%0d\n",hLinksIn);
	}

	nJ = 0;
	lEOF = 0;
	nIPRLinks = 0;
	strcpy(cPCSBuf,"1\0");
	printf("Reading links... ");
	while (strlen(cPCSBuf) > 0) {
		strcpy(cPCSBuf,readline(&hLinksIn));

		for (nI = 0; nI < 19; nI++) {
			switch (nI) {
				case 0:
					strcpy(ipr[nJ].linktype,strtok(cPCSBuf,"\t"));
					break;
					
/* For some reason, strtok is grabbing two \t's on a blank field... */
/*				case 1:
					strcpy(ipr[nJ].priority,strtok(NULL,"\t"));
					break;
*/				case 2:
					strcpy(ipr[nJ].ordertype,strtok(NULL,"\t"));
					break;
				case 3:
					strcpy(ipr[nJ].pointcode,strtok(NULL,"\t"));
					break;
				case 4:
					strcpy(ipr[nJ].cityst,strtok(NULL,"\t"));
					break;
				case 5:
					strcpy(ipr[nJ].fmsnumber,strtok(NULL,"\t"));
					break;
				case 6:
					strcpy(ipr[nJ].linkset,strtok(NULL,"\t"));
					break;
				case 7:
					strcpy(ipr[nJ].slc,strtok(NULL,"\t"));
					break;
				case 8:
					strcpy(ipr[nJ].linknumber,strtok(NULL,"\t"));
					break;
				case 9:
					strcpy(ipr[nJ].stp,strtok(NULL,"\t"));
					break;					
				case 10:
					strcpy(ipr[nJ].scp,strtok(NULL,"\t"));
					break;			
				case 11:
					strcpy(ipr[nJ].order,strtok(NULL,"\t"));
					break;
				case 12:
					strcpy(ipr[nJ].custwantdate,strtok(NULL,"\t"));
					break;
				case 13:
					strcpy(ipr[nJ].fmsstatus,strtok(NULL,"\t"));
					break;
				case 14:
					strcpy(ipr[nJ].fmsstatusdate,strtok(NULL,"\t"));
					break;
				case 15:
					strcpy(ipr[nJ].status,strtok(NULL,"\t"));
					break;
				case 16:
					strcpy(ipr[nJ].statusdate,strtok(NULL,"\t"));
					break;
				case 17:
					strcpy(ipr[nJ].notes1,strtok(NULL,"\t"));
					break;
				case 18:
					strcpy(ipr[nJ].notes2,strtok(NULL,"\n"));
					break;
			}
		}
		
		printf("\nLinkType: %s\n",ipr[nJ].linktype);
		printf("Priority: %s\n",ipr[nJ].priority);
		printf("Order type: %s\n",ipr[nJ].ordertype);
		printf("Point Code: %s\n",ipr[nJ].pointcode);
		printf("FMS #%s\n",ipr[nJ].fmsnumber);
		printf("Linkset: %s\n",ipr[nJ].linkset);
		printf("SLC: %s\n",ipr[nJ].slc);
				
		if (strlen(ipr[nJ].linkset) > 0) nIPRLinks++;		
		nJ++;
	}
	
	printf("Done. %0d IPR links.\n",nIPRLinks);

	printf("Closing Install Problem Report file... ");
	close(hLinksIn);
	printf("Done.\n");



	
	/************************
	*  Read PCS Links Table *
	************************/	
	printf("Opening links file... ");
	hLinksIn = open("links.txt",O_RDONLY);
	if (hLinksIn == -1) {
		printf("Error %0d!  Couldn't open links.txt!\n",errno);
		exit(1);
	} else {
		printf("Done. File #%0d\n",hLinksIn);
	}

	nJ = 0;
	lEOF = 0;
	nTotalLinks = 0;
	strcpy(cPCSBuf,"1\0");
	printf("Reading links... ");
	while (strlen(cPCSBuf) > 0) {
		strcpy(cPCSBuf,readline(&hLinksIn));
		
		for (nI = 0; nI < 10; nI++) {
			switch (nI) {
				case 0:
					strcpy(pcs[nJ].monsp,strtok(cPCSBuf,"\t"));
					break;
				case 1:
					strcpy(pcs[nJ].remsp,strtok(NULL,"\t"));
					break;
				case 2:
					strcpy(pcs[nJ].type,strtok(NULL,"\t"));
					break;
				case 3:
					strcpy(pcs[nJ].linkset,strtok(NULL,"\t"));
					break;
				case 4:
					strcpy(pcs[nJ].slc,strtok(NULL,"\t"));
					break;
				case 5:
					strcpy(pcs[nJ].name,strtok(NULL,"\t"));
					break;
				case 6:
					strcpy(pcs[nJ].altname,strtok(NULL,"\t"));
					break;
				case 7:
					strcpy(pcs[nJ].status,strtok(NULL,"\t"));
					break;
				case 8:
					strcpy(pcs[nJ].linknumber,strtok(NULL,"\t"));
					break;
				case 9:
					strcpy(pcs[nJ].fmsstatus,strtok(NULL,"\n"));
					break;					
			}
		}
		
		if (strlen(pcs[nJ].name) > 0) nTotalLinks++;		
		nJ++;
	}
	
	printf("Done. %0d links.\n",nTotalLinks);

	printf("Closing links file... ");
	close(hLinksIn);
	printf("Done.\n");
	
	if (nTotalLinks == 0 && nIPRLinks == 0) {
		printf("Error!  No links found.\n\n");
		exit(1);
	}
	
	/******************
	*  Open ETR File  *
	******************/
	printf("Opening ETR file... ");
	hEtrIn = open("../etr/etrfile.etr",O_RDWR);
	if (hEtrIn == -1) {
		printf("Error %0d!  Couldn't open ETR file!\n",errno);
		exit(1);
	} else {
		printf("Done. File #%0d\n",hEtrIn);
	}
	nEOF = lseek(hEtrIn,0,SEEK_END);
	lseek(hEtrIn,0,SEEK_SET);


	/****************
	*  Do it to it  *
	****************/
	printf("Locating links in ETR file... (this takes a few minutes)\n");
	nLinksChanged = 0;
	strcpy(cETRBuf,"1\0");
	while (strlen(cETRBuf) > 0) {
		strcpy(cETRBuf,"1\0");
		while (strcmp(cETRBuf,"[link]")  && lseek(hEtrIn,0,SEEK_CUR) < nEOF) \
			strcpy(cETRBuf,readline(&hEtrIn));

		getlink(&hEtrIn,&link);
											
		nTmpLoc = lseek(hEtrIn,0,SEEK_CUR) \
			- strlen(link.status) \
			- strlen(link.mon_sys) \
			- strlen(link.linktype) \
			- strlen(link.chanB_hec) \
			- strlen(link.chanB_unscramble) \
			- strlen(link.chanB_vci) \
			- strlen(link.chanB_vpi) \
			- strlen(link.chanB_subrate_num) \
			- strlen(link.chanB_pcr) \
			- strlen(link.chanB_characteristic) \
			- strlen(link.chanA_hec) \
			- strlen(link.chanA_unscramble) \
			- strlen(link.chanA_vci) \
			- strlen(link.chanA_vpi) \
			- strlen(link.chanA_subrate_num) \
			- strlen(link.chanA_pcr) \
			- strlen(link.chanA_characteristic) \
			- strlen(link.altname) \
			- 24;


		/* Compare ETR file with links list */
		for (nJ = 0; nJ < nTotalLinks; nJ++) {

			/* This is the code that removes all PRV- prefixes */
/*			if (nTmpLoc > 0 \
				&& *strstr(link.altname,"RV-") > 0 \
				&& *strstr(link.name,pcs[nJ].name) > 0) {
				
				strncpy(cBuf,pcs[nJ].altname,3);
				if (cBuf[3] != 0) strcat(cBuf,"\0");

				printf("\nFound %s -> %s\n",link.altname,pcs[nJ].altname);
				
				link.altname[0] = cBuf[0];
				link.altname[1] = cBuf[1];
				link.altname[2] = cBuf[2];
				
				lseek(hEtrIn,nTmpLoc,SEEK_SET);
				write(hEtrIn,cBuf,3);
				nLinksChanged++;
			} 
*/
			if (!strcmp(link.altname,pcs[nJ].altname) && strlen(pcs[nJ].altname) > 0) {
			
				pcs[nJ].etrloc = nTmpLoc;

				printf("\nFound: PCS:%s ETR:%s Status:%s FMS:%s:\n",pcs[nJ].altname,link.altname,link.status,pcs[nJ].fmsstatus);

				if (strcmp(pcs[nJ].fmsstatus,"INSTALL") \
					&& nTmpLoc > 0 \
					&& strcmp(link.status,"ENABLED")) {
					printf("%s Changed.\n",pcs[nJ].altname);

					lseek(hEtrIn,nTmpLoc,SEEK_SET);
					write(hEtrIn,"PRV",3);
					nLinksChanged++;
				} else printf("%s not changed.\n",pcs[nJ].altname);
				
				nJ = nTotalLinks;
			}
		}
		
		/* Compare ETR file with install problem report list */
		for (nJ = 0; nJ < nIPRLinks; nJ++) {
			
			if (*strstr(link.altname,ipr[nJ].linkset) > 0 && !strcmp(link.slc,ipr[nJ].slc)) {
			
				ipr[nJ].etrloc = nTmpLoc;

				printf("Found: IPR:%s ETR:%s I-SLC:%s E-SLC:%s\n",ipr[nJ].linkset,link.altname,ipr[nJ].slc,link.slc);

				printf("%s Changed.\n",pcs[nJ].altname);

				lseek(hEtrIn,nTmpLoc,SEEK_SET);
				write(hEtrIn,"PRV",3);
				nLinksChanged++;
				
				nJ = nIPRLinks;
			}
		}

	}
	printf("\nDone.\n");
	
	printf("Verifying links...\n");
	/* Verify that all links were found */
	for (nJ = 0; nJ < nTotalLinks; nJ++) {
		if (pcs[nJ].etrloc == 0) {
			printf("Error! %s in the links file was not found in the ETR file!\n",pcs[nJ].altname);
		}
	}
	for (nJ = 0; nJ < nIPRLinks; nJ++) {
		if (ipr[nJ].etrloc == 0) {
			printf("Error! LS%s SLC:%s in the IPR file was not found in the ETR file!\n",ipr[nJ].linkset,ipr[nJ].slc);
		}
	}

	printf("Done.\n");
	
	printf("\nChanged:\t%0d\n\n",nLinksChanged);
	
	printf("Closing files... ");
	close(hEtrIn);
	printf("Done.\n");
	
	/* Unlock Network Config */
	unlock_network_config();
	
	return 0;	
}