/*
	stpaudit.c
	11-8-01 by Jon Bieker
	(c)2001 Sprint
*/

#include "../include/include.h"
#include <sys/file.h>

#define MAXBUFLEN 1024
#define MAXLINKS 5000
#define MAXSTP 8

struct stp {
	char switch_name[10];
	char point_code[12];
	char ip_address[16];
	char real_name[25];
};

struct linkstring {
	char string[20];
};

struct links {
	char real_name[25];
	char switch_name[7];
	char linkset[25];
	char linktype[2];
	char opc[12];
	char slc[3];
	char dpc[12];
	char remclli[25];
	char status[10];
	char linknum[5];
};

struct linkstat {
	char switch_name[7];
	char linknum[5];
	char service[6];
	char blocked[3];
	char inhibit[3];
	char probation[2];
	char suspension[2];
	char failure[2];
	char algorithm[2];
	char linkset[25];
	char linksetnum[5];
};

struct pc {
	char first_pos[4];
	char second_pos[4];
	char third_pos[4];
};

int main()
{
	/* Variable Declarations */
	char cBuf[MAXBUFLEN],cTmpBuf[MAXBUFLEN],cOutBuf[MAXBUFLEN];
	char lEOF, lNewSTP, lSpace, lFound;
	int nI,nJ,nStatLinks,nSTPLinks,nSTP,nLinks,nThisRow,nLinkNum,nSLC,nA7Links,nErrors;

	FILE *hCapture,*hOut,*hAllLinks,*hStatus;
	
	struct stp stp[MAXSTP];
	struct linkset linkset;
	struct linkstat linkstat[MAXLINKS];
	struct linkstring linkstring[100];
	struct links stp_links[MAXLINKS];
	struct links a7_links[MAXLINKS];
	struct pc pc;
	
	uselog("stpaudit","");
	
	/* Define STP's */
	strcpy(stp[0].switch_name,"CHC301");		/* Chicago 301		*/
	strcpy(stp[0].point_code,"253-193-000");
	strcpy(stp[0].ip_address,"172.20.196.226");
	strcpy(stp[0].real_name,"Chicago 301");
	strcpy(stp[1].switch_name,"FTW302");		/* Fort Worth 302	*/
	strcpy(stp[1].point_code,"253-194-000");
	strcpy(stp[1].ip_address,"172.20.198.8");
	strcpy(stp[1].real_name,"Fort Worth 302");
	strcpy(stp[2].switch_name,"STK303");		/* Stockton 303		*/
	strcpy(stp[2].point_code,"253-130-000");
	strcpy(stp[2].ip_address,"172.20.129.50");
	strcpy(stp[2].real_name,"Stockton 303");
	strcpy(stp[3].switch_name,"RIL304");		/* Rialto 304		*/
	strcpy(stp[3].point_code,"253-129-000");
	strcpy(stp[3].ip_address,"172.20.23.152");
	strcpy(stp[3].real_name,"Rialto 304");
	strcpy(stp[4].switch_name,"NAS307");		/* Nashville 307	*/
	strcpy(stp[4].point_code,"253-037-000");
	strcpy(stp[4].ip_address,"172.20.177.22");
	strcpy(stp[4].real_name,"Nashville 307");
	strcpy(stp[5].switch_name,"ATL306");		/* Atlanta 306		*/
	strcpy(stp[5].point_code,"253-066-000");
	strcpy(stp[5].ip_address,"172.20.202.172");
	strcpy(stp[5].real_name,"Atlanta 306");
	strcpy(stp[6].switch_name,"AKR314");		/* Akron 314		*/
	strcpy(stp[6].point_code,"253-038-000");
	strcpy(stp[6].ip_address,"172.20.155.25");
	strcpy(stp[6].real_name,"Akron 314");
	strcpy(stp[7].switch_name,"NYC305");		/* New York 305		*/
	strcpy(stp[7].point_code,"253-065-000");
	strcpy(stp[7].ip_address,"172.20.51.83");
	strcpy(stp[7].real_name,"New York 305");
	
	printf("STP Audit\n");
	printf("11-8-01 by Jon Bieker\n");
	printf("(c)2001 Sprint\n\n");
	
	printf("Reading AcceSS7 links...\n");
	hAllLinks = fopen("/home/filexfer/links/all_links.txt","r");
	if (hAllLinks == NULL) {
		perror("Couldn't open all_links.txt");
		exit(1);
	}
	
	lEOF = 0;
	
	/* Skip header lines */
	if (fgets(cBuf,sizeof(cBuf),hAllLinks) == NULL) lEOF = 1;
	if (!lEOF && fgets(cBuf,sizeof(cBuf),hAllLinks) == NULL) lEOF = 1;
	if (!lEOF && fgets(cBuf,sizeof(cBuf),hAllLinks) == NULL) lEOF = 1;

	nI = 0;
	while (!lEOF) {
		if(fgets(cBuf,sizeof(cBuf),hAllLinks) == NULL) lEOF = 1;
		
		/* Fill AcceSS7 link structure */
		strcpy(a7_links[nI].opc,strtok(cBuf," "));
		strcpy(a7_links[nI].dpc,strtok(NULL," "));
		strcpy(a7_links[nI].linktype,strtok(NULL," "));
		strcpy(a7_links[nI].linkset,strtok(NULL," "));
		strcpy(a7_links[nI].slc,strtok(NULL," "));
		strcpy(linkset.remclli,strtok(NULL," "));
		strcpy(cTmpBuf,strtok(NULL," "));
		strcpy(a7_links[nI].status,strtok(NULL," "));
		strcpy(a7_links[nI].linknum,strtok(NULL," "));
		
		/* Extract remote CLLI from link name
		   Pretty bad, I know, but we don't store it anywhere else...
		*/
		strcpy(cTmpBuf,strtok(linkset.remclli,"-"));
		strcpy(a7_links[nI].remclli,strtok(NULL,"/"));
		
		/* Fix the point codes */
		strcpy(pc.first_pos,strtok(a7_links[nI].opc,"-"));
		strcpy(pc.second_pos,strtok(NULL,"-"));
		strcpy(pc.third_pos,strtok(NULL,"-"));

		sprintf(cTmpBuf,"%03d",atol(pc.first_pos));
		strcpy(cBuf,cTmpBuf);
		strcat(cBuf,"-");
		sprintf(cTmpBuf,"%03d",atol(pc.second_pos));
		strcat(cBuf,cTmpBuf);
		strcat(cBuf,"-");
		sprintf(cTmpBuf,"%03d",atol(pc.third_pos));
		strcat(cBuf,cTmpBuf);

		strcpy(a7_links[nI].opc,cBuf);
		
		strcpy(pc.first_pos,strtok(a7_links[nI].dpc,"-"));
		strcpy(pc.second_pos,strtok(NULL,"-"));
		strcpy(pc.third_pos,strtok(NULL,"-"));

		sprintf(cTmpBuf,"%03d",atol(pc.first_pos));
		strcpy(cBuf,cTmpBuf);
		strcat(cBuf,"-");
		sprintf(cTmpBuf,"%03d",atol(pc.second_pos));
		strcat(cBuf,cTmpBuf);
		strcat(cBuf,"-");
		sprintf(cTmpBuf,"%03d",atol(pc.third_pos));
		strcat(cBuf,cTmpBuf);
		
		strcpy(a7_links[nI].dpc,cBuf);

		/* Fix SLC */
		strcpy(a7_links[nI].slc,ltoa(atoi(a7_links[nI].slc)));

		/* Fix link number */
		strcpy(a7_links[nI].linknum,ltoa(atoi(a7_links[nI].linknum)));

		nI++;
	}
	
	fclose(hAllLinks);
	
	nA7Links = nI;
	
	printf("Extracting link statuses...\n");

	/* Open STP link status file */
	hStatus = fopen("stat_capture.txt","r");
	if (hStatus == NULL) {
		perror("Couldn't open stat_capture.txt");
		exit(1);
	}

	lEOF = 0;
	nStatLinks = 0;
	while (!lEOF) {
/*		while (strstr(cBuf,"Switch Name:") < 1 && !lEOF) if (fgets(cBuf,sizeof(cBuf),hStatus) == NULL) lEOF = 1;
*/
		/* Move to next STP */
		while (strstr(cBuf,"Switch Name:") < 1 && !lEOF) if (fgets(cBuf,sizeof(cBuf),hStatus) == NULL) lEOF = 1;

		/* Get the name of the STP */
		strcpy(cTmpBuf,strtok(cBuf," "));
		strcpy(cTmpBuf,strtok(NULL," "));
		strcpy(cTmpBuf,strtok(NULL," "));
	
		/* Trim the switch name */
		for (nI = strlen(cTmpBuf); nI > 0; nI--) if (!isalnum(cTmpBuf[nI])) cTmpBuf[nI] = 0;
		
		/* Find out which STP we're on */
		nSTP = 0;
		for (nI = 0; nI < MAXSTP; nI++) {
			if (!strcmp(cTmpBuf,stp[nI].switch_name)) {
				nSTP = nI;
				nI = MAXSTP;
			}
		}
		
		/* Find underline */
		while (strstr(cBuf,"---") < 1 && !lEOF) if (fgets(cBuf,sizeof(cBuf),hStatus) == NULL) lEOF = 1;
		
		/* Get link statuses */
		lNewSTP = 0;
		while (!lNewSTP && !lEOF) {
			if (fgets(cBuf,sizeof(cBuf),hStatus) == NULL) lEOF = 1;

			/* Trim buffer */
			for (nI = strlen(cBuf); nI > 0; nI--) {
				if (!isalnum(cBuf[nI])) {
					cBuf[nI] = 0;
				} else {
					nI = 0;
				}
			}

			if (strlen(cBuf) > 1) {
				if (strstr(cBuf,"Switch Name:")) {
					lNewSTP = 1;
				} else {
					/* Remove spaces & stuff */
					strcpy(cTmpBuf,cBuf);
					memcpy(cBuf,0,sizeof(cBuf));
					nJ = 0;
					lSpace = 0;
					for (nI = 0; nI < strlen(cTmpBuf); nI ++) {
						/* Remove LF & FF */
						if (cTmpBuf[nI] == 0x0a || cTmpBuf[nI] == 0x0c) cTmpBuf[nI] = 0x20;
					
						if (cTmpBuf[nI] == 0x20 && !lSpace) {
							cBuf[nJ++] = cTmpBuf[nI];
							lSpace = 1;
						} else if (cTmpBuf[nI] != 0x20) {
							cBuf[nJ++] = cTmpBuf[nI];
							lSpace = 0;
						}
					}
					while (cBuf[0] == 0x20) {
						for (nI = 0; nI < strlen(cBuf) - 1; nI++) {
							cBuf[nI] = cBuf[nI + 1];
						}
					}
					
					if (isdigit(cBuf[0])) {
						strcpy(linkstat[nStatLinks].switch_name,stp[nSTP].switch_name);
						strcpy(linkstat[nStatLinks].linknum,strtok(cBuf," "));
						strcpy(linkstat[nStatLinks].service,strtok(NULL," "));
						strcpy(linkstat[nStatLinks].blocked,strtok(NULL," "));
						strcpy(linkstat[nStatLinks].inhibit,strtok(NULL," "));
						strcpy(linkstat[nStatLinks].probation,strtok(NULL," "));
						strcpy(linkstat[nStatLinks].suspension,strtok(NULL," "));
						strcpy(linkstat[nStatLinks].failure,strtok(NULL," "));
						strcpy(linkstat[nStatLinks].algorithm,strtok(NULL," "));
						strcpy(linkstat[nStatLinks].linkset,strtok(NULL," "));
						strcpy(linkstat[nStatLinks].linksetnum,strtok(NULL," "));
						
						nStatLinks++;
					}
				}				
			}		
		}		
	}	
	
	fclose(hStatus);
	
	printf("Extracting STP links...\n");	
	
	/* Open STP capture file */
	hCapture = fopen("disp_capture.txt","r");
	if (hCapture == NULL) {
		perror("Couldn't open disp_capture.txt");
		exit(1);
	}
	
	hOut = fopen("stp_links.txt","w");
	if (hOut == NULL) {
		perror("Couldn't create stp_links.txt");
		fclose(hCapture);
		exit(1);
	}

	lEOF = 0;
	nSTPLinks = 0;
	memcpy(cBuf,0,sizeof(cBuf));
	while (!lEOF) {
		/* Move to next STP */
		while (strstr(cBuf,"Switch Name:") < 1 && !lEOF) if (fgets(cBuf,sizeof(cBuf),hCapture) == NULL) lEOF = 1;

		/* Get the name of the STP */
		strcpy(cTmpBuf,strtok(cBuf," "));
		strcpy(cTmpBuf,strtok(NULL," "));
		strcpy(cTmpBuf,strtok(NULL," "));
	
		/* Trim the switch name */
		for (nI = strlen(cTmpBuf); nI > 0; nI--) if (!isalnum(cTmpBuf[nI])) cTmpBuf[nI] = 0;
		
		/* Find out which STP we're on */
		nSTP = 0;
		for (nI = 0; nI < MAXSTP; nI++) {
			if (!strcmp(cTmpBuf,stp[nI].switch_name)) {
				nSTP = nI;
				nI = MAXSTP;
			}
		}
/*		if (strlen(cTmpBuf) > 0) printf("Site: %s\n",stp[nSTP].real_name);
		fflush(stdout);
*/
		/* Print the linksets for the site */	
		lNewSTP = 0;
		while (!lNewSTP && !lEOF) {
			/* Find Linkset line */
			while (strstr(cBuf,"LS NAME") < 1 && !lEOF) if (fgets(cBuf,sizeof(cBuf),hCapture) == NULL) lEOF = 1;
			/* Find separator line */
			while (strstr(cBuf,"---") < 1 && !lEOF) if (fgets(cBuf,sizeof(cBuf),hCapture) == NULL) lEOF = 1;
			/* Find Linket data line */
			while (strncmp(cBuf,"   LS",5) && !lEOF) if (fgets(cBuf,sizeof(cBuf),hCapture) == NULL) lEOF = 1;
			
			if (!strncmp(cBuf,"   LS",5)) {
				/* Get linkset info */
				strcpy(linkset.monsp,stp[nSTP].point_code);
				strcpy(linkset.name,strtok(cBuf," "));
				strcpy(cTmpBuf,strtok(NULL," "));
				strcpy(linkset.remclli,strtok(NULL," "));
				strcpy(linkset.remsp,strtok(NULL," "));
				strcpy(linkset.linktype,strtok(NULL," "));			
			
				/* Get number of links in this linkset */
				strcpy(cTmpBuf,strtok(NULL," "));
				nLinks = atoi(cTmpBuf);
			}

/*			if (nLinks == 1) {
				printf("\n\t%s\t%0d %s Link\n",linkset.name,nLinks,linkset.linktype);
			} else {
				printf("\n\t%s\t%0d %s Links\n",linkset.name,nLinks,linkset.linktype);
			}
*/
			memcpy(linkstring,0,sizeof(linkstring));
			
			if (nLinks > 0) {
				/* Find Link line */
				while (strstr(cBuf,"LNK-PRI-SLC") < 1 && !lEOF) if (fgets(cBuf,sizeof(cBuf),hCapture) == NULL) lEOF = 1;

				/* Find separator line */
				while (strstr(cBuf,"---") < 1 && !lEOF) if (fgets(cBuf,sizeof(cBuf),hCapture) == NULL) lEOF = 1;

				/* Find link data line */
				while (!isdigit(cBuf[3]) && !lEOF) if (fgets(cBuf,sizeof(cBuf),hCapture) == NULL) lEOF = 1;

				/* Concatenate all the link lines */
				strcpy(cTmpBuf,cBuf);
				nI = nLinks;
				if (nI > 4) {
					nI -= 4;
					while (nI > 0 && !lEOF) {
						memcpy(cBuf,0,sizeof(cBuf));
						while (!isdigit(cBuf[3]) && !lEOF) if (fgets(cBuf,sizeof(cBuf),hCapture) == NULL) lEOF = 1;
						strcat(cTmpBuf,cBuf);
						nI -= 4;
					}
				}

				/* Remove spaces & stuff */
				memcpy(cBuf,0,sizeof(cBuf));
				nJ = 0;
				lSpace = 0;
				for (nI = 0; nI < strlen(cTmpBuf); nI ++) {
					/* Remove LF & FF */
					if (cTmpBuf[nI] == 0x0a || cTmpBuf[nI] == 0x0c) cTmpBuf[nI] = 0x20;
					
					if (cTmpBuf[nI] == 0x20 && !lSpace) {
						cBuf[nJ++] = cTmpBuf[nI];
						lSpace = 1;
					} else if (cTmpBuf[nI] != 0x20) {
						cBuf[nJ++] = cTmpBuf[nI];
						lSpace = 0;
					}
				}

				strcpy(cTmpBuf,cBuf);
				
				nI = nLinks;					

				if (nI > 0) {
					strcpy(linkstring[0].string,strtok(cTmpBuf," "));
					
					for (nJ = 1; nJ < nI; nJ++) {
						strcpy(linkstring[nJ].string,strtok(NULL," "));						
					}
				} else {
/*					printf("No links are defined on this linkset!\n");
*/				}

				for (nI = 0; nI < nLinks; nI++) {
					nLinkNum = atoi(strtok(linkstring[nI].string,"-"));
					strcpy(cBuf,strtok(NULL,"-"));
					nSLC = atoi(strtok(NULL,"-"));
/*					printf("\t\tLink: %0d\tSLC: %0d\n",nLinkNum,nSLC);
*/
					
					/* Fill STP link structure */
					strcpy(stp_links[nSTPLinks].real_name,stp[nSTP].real_name);
					strcpy(stp_links[nSTPLinks].switch_name,stp[nSTP].switch_name);
					strcpy(stp_links[nSTPLinks].linkset,linkset.name);
					strcpy(stp_links[nSTPLinks].linktype,linkset.linktype);
					strcpy(stp_links[nSTPLinks].opc,stp[nSTP].point_code);
					strcpy(stp_links[nSTPLinks].slc,ltoa(nSLC));
					strcpy(stp_links[nSTPLinks].dpc,linkset.remsp);
					strcpy(stp_links[nSTPLinks].remclli,linkset.remclli);
					strcpy(stp_links[nSTPLinks].linknum,ltoa(nLinkNum));
					nSTPLinks++;

					/* Write link data to outfile */
					strcpy(cOutBuf,stp[nSTP].real_name);
					strcat(cOutBuf,"\t");
					strcat(cOutBuf,stp[nSTP].switch_name);
					strcat(cOutBuf,"\t");
					strcat(cOutBuf,linkset.name);
					strcat(cOutBuf,"\t");
					strcat(cOutBuf,linkset.linktype);
					strcat(cOutBuf,"\t");
					strcat(cOutBuf,stp[nSTP].point_code);
					strcat(cOutBuf,"\t");
					strcat(cOutBuf,ltoa(nSLC));
					strcat(cOutBuf,"\t");
					strcat(cOutBuf,linkset.remsp);
					strcat(cOutBuf,"\t");
					strcat(cOutBuf,linkset.remclli);
					strcat(cOutBuf,"\t");
					strcat(cOutBuf,ltoa(nLinkNum));
					strcat(cOutBuf,"\t");
					
					for (nJ = 0; nJ < nStatLinks; nJ++) {
						if (!strcmp(linkstat[nJ].switch_name,stp[nSTP].switch_name) \
							&& (nLinkNum == atoi(linkstat[nJ].linknum))) {
							
							strcat(cOutBuf,linkstat[nJ].service);
							nJ = nStatLinks;
						}
					}
					
					strcat(cOutBuf,"\t");
					for (nJ = 0; nJ < nA7Links; nJ++) {
						if (!strcmp(a7_links[nJ].opc,stp[nSTP].point_code) \
							&& (nLinkNum == atoi(a7_links[nJ].linknum))) {
							
							strcat(cOutBuf,a7_links[nJ].status);

							nJ = nA7Links;
						}
					}

					strcat(cOutBuf,"\n");
					fputs(cOutBuf,hOut);
				}
			}
			
			/* Look for another linkset or a new STP */
			while (strstr(cBuf,"LS NAME") < 1 && strstr(cBuf,"Switch Name:") < 1 && !lEOF) {
				if (fgets(cBuf,sizeof(cBuf),hCapture) == NULL) lEOF = 1;
				if (strstr(cBuf,"Switch Name:")) lNewSTP = 1;
			}
		}
	}
	
	fclose(hOut);
	fclose(hCapture);

	nErrors = 0;
	
	for(nI = 0; nI < nSTPLinks; nI++) {
		/* Check for discrepancies */
		lFound = 0;
		nJ = 0;

		while (!lFound && nJ < nA7Links) {
			if (!strcmp(stp_links[nI].opc,a7_links[nJ].opc) \
				&& !strcmp(stp_links[nI].dpc,a7_links[nJ].dpc) \
				&& !strcmp(stp_links[nI].slc,a7_links[nJ].slc) \
				&& !strcmp(stp_links[nI].linknum,a7_links[nJ].linknum)) {
				
				lFound = 1;

				/* Check for bad linkset */
				if (strcmp(stp_links[nI].linkset,a7_links[nJ].linkset)) {
					printf("%s - %s <%s> %s \tLinkset is %s in AcceSS7 and should be %s.\n",stp_links[nI].switch_name,stp_links[nI].opc,stp_links[nI].slc,stp_links[nI].dpc,a7_links[nJ].linkset,stp_links[nI].linkset);
					nErrors++;
				}

				/* Check for bad linktype */
				if (strcmp(stp_links[nI].linktype,a7_links[nJ].linktype)) {
					printf("%s - %s <%s> %s \tLink type is \"%s\" in AcceSS7 and should be \"%s\".\n",stp_links[nI].switch_name,stp_links[nI].opc,stp_links[nI].slc,stp_links[nI].dpc,a7_links[nJ].linktype,stp_links[nI].linktype);
					nErrors++;
				}
				
				/* Check for bad CLLI */
				if (strcmp(stp_links[nI].remclli,a7_links[nJ].remclli)) {
					printf("%s - %s <%s> %s \tRemote end CLLI is \"%s\" in AcceSS7 and should be \"%s\".\n",stp_links[nI].switch_name,stp_links[nI].opc,stp_links[nI].slc,stp_links[nI].dpc,a7_links[nJ].remclli,stp_links[nI].remclli);
					nErrors++;
				}				
			}			
			nJ++;
		}
		
		/* Possible link on wrong SLC */
		if (!lFound) {
			printf("%s - %s <%s> %s \tLink %s was not found in AcceSS7.\n",stp_links[nI].switch_name,stp_links[nI].opc,stp_links[nI].slc,stp_links[nI].dpc,stp_links[nI].linknum);
			nErrors++;
		}
	}
		
	printf("\nSTP Audit complete.  %0d errors found.\n\n",nErrors);
	
	return 0;
}
