/*
   load_measurements.c
    
    8-22-02 by Jon Bieker
    (c)2002 Sprint

*/

/* Includes */
#include <dirent.h>
#include <libpq-fe.h>
#include <stdio.h>
#include <string.h>
#include <time.h>
#include <zlib.h>

/* Globals variables */
PGconn *log;
PGconn *tm2;
PGresult *result;

struct line {
  char program[5];
  char measurement[4];
  char link[30];
  char datetime[20];
  char meastype[5];
  char actual[15];
  char normalized[15];
};

struct parsed {
  char app[5];
  char measurement[4];
  char opc[12];
  char slc[3];
  char dpc[12];
  char date[11];
  char time[9];
  char type[5];
  char actual[25];
  char normalized[25];
};

struct today {
  char year[5];
  char month[3];
  char day[3];
};

main (int argc, char *argv[])
{

  char command[1024], commands[216000];
  char filename[50], cBuf[1024], cJunk[16];
  char cStartTime[9], cFinishTime[9], cTime[9], cStartDate[11], cDate[11];
  char one[5], two[5], three[5];
  char nEOF;
  int n, nI, nBytes, nTimes;
  time_t timer;
  struct line sLine;
  struct parsed sParsed;
  struct today today;
  
  DIR *dirp;
  gzFile hFile;
  
  struct dirent *dp;
  
  timer = time(NULL);
  strftime(cStartTime,sizeof(cStartTime),"%H:%M:%S",localtime(&timer));
  strftime(cStartDate,sizeof(cStartDate),"%Y-%m-%d",localtime(&timer));

  /* Connect to database */
  tm2 = PQconnectdb("hostaddr=172.19.6.152 dbname=tm2 user=postgres password=pgauthall");

  /* Make sure we're connected to the DB */
  if (PQstatus(tm2)) {
    PQfinish(tm2);
    printf("Couldn't connect to database!\n");
    exit(1);
  }

  strcpy(cBuf,cStartDate);
        
  strcpy(command,"select date from dates where date='");
  strcat(command,cDate);
  strcat(command,"';");
  result = PQexec(tm2,command);
  if (PQntuples(result) < 1) {
    PQclear(result);
    strcpy(command,"insert into dates (date) values ('");
    strcat(command,cDate);
    strcat(command,"');");
    result = PQexec(tm2,command);
  }
        
  PQclear(result);

  dirp = opendir("/data/tm");
  strcpy(commands,"");
  nTimes = 0;
  while ((dp = readdir(dirp)) != NULL) {

    // Make sure it's the kind of file we want
      // All files when the filename is greater than 30 characters long
//    if(strlen(dp->d_name) > 30) {  

      // All erlang load files in a certain month
//    if(strlen(dp->d_name) > 30 && strstr(dp->d_name,"May") && (!strstr(dp->d_name,"measdata002") && !strstr(dp->d_name,"measdata003") && !strstr(dp->d_name,"measdata004"))) {  

      // All RXABREL files
    if(strlen(dp->d_name) > 30 && (strstr(dp->d_name,"measdata002") || strstr(dp->d_name,"measdata003"))) {  

      strcpy(filename,"/data/tm/");
      strncat(filename,dp->d_name,strlen(dp->d_name));
      printf("Processing: %s ...",filename);
      fflush(stdout);
      
      strcpy(command,"select id from files where filename='");
      strcat(command,filename);
      strcat(command,"';");

      result = PQexec(tm2,command);

      if (PQntuples(result) == 0) {      
        PQclear(result);

        hFile = gzopen(filename,"rb");

        while (!gzeof(hFile)) {
      
          gzgets(hFile,cBuf,sizeof(cBuf));
          
          // Skip the first line if it contains AppID.
          if (!strncmp(cBuf,"AppID",5)) {
            gzgets(hFile,cBuf,sizeof(cBuf));
            printf("AppID found.  Skipping to next line.  ");
          }

          // Make sure the line doesn't contain "ERROR"
          if (strncmp(cBuf,"ERROR",5)) {

            // Regexps...
            for (nI = 0; nI < strlen(cBuf); nI++) {
              if (cBuf[nI] == 0x22) cBuf[nI] = 0x20;          
            }
//printf("\nBuf: %s\n",cBuf);
            strcpy(sLine.program,strtok(cBuf," "));
            strcpy(sLine.measurement,strtok(NULL," "));
            strcpy(sLine.link,strtok(NULL," "));
            strcpy(sLine.datetime,strtok(NULL," "));
            strcpy(sLine.meastype,strtok(NULL," "));
            strcpy(sLine.actual,strtok(NULL," "));
            strcpy(sLine.normalized,strtok(NULL," "));

            strcpy(sParsed.app,sLine.program);
            strcpy(sParsed.measurement,sLine.measurement);
            strcpy(sParsed.type,sLine.meastype);
            
            strcpy(cBuf,sLine.link);

            strcpy(one,strtok(cBuf,"-"));
            strcpy(two,strtok(NULL,"-"));
            
            if(!strcmp(sLine.measurement,"002") \
              || !strcmp(sLine.measurement,"003") \
              || !strcmp(sLine.measurement,"004")) {

              strcpy(three,strtok(NULL,""));
              
            } else {
            
              strcpy(three,strtok(NULL,"<"));            
              
            }

            if(!strcmp(sLine.measurement,"002") \
              || !strcmp(sLine.measurement,"003") \
              || !strcmp(sLine.measurement,"004")) {
              
              sprintf((char *) sParsed.dpc,"%0.3d-%0.3d-%0.3d",atoi(one),atoi(two),atoi(three));
              
              strcpy(sParsed.slc,"");
              strcpy(sParsed.opc,"");

            } else {

              sprintf((char *) sParsed.opc,"%0.3d-%0.3d-%0.3d",atoi(one),atoi(two),atoi(three));
            
              if (strcmp(sLine.measurement,"005")) {
                strcpy(sParsed.slc,strtok(NULL,">"));
              }
            
              strcpy(one,strtok(NULL,"-"));

              if (strlen(one) == 4) {
                one[0] = one[1];
                one[1] = one[2];
                one[2] = one[3];
                one[3] = 0x00;
              }

              strcpy(two,strtok(NULL,"-"));
              strcpy(three,strtok(NULL,"\n"));

              sprintf((char *) sParsed.dpc,"%0.3d-%0.3d-%0.3d",atoi(one),atoi(two),atoi(three));
            }

            strcpy(cBuf,strtok(sLine.datetime,"/"));
            strcpy(sParsed.date,"20");
            strcat(sParsed.date,cBuf);
            strcat(sParsed.date,"-");
            sprintf((char *) cBuf,strtok(NULL,"/"));
            strcat(sParsed.date,cBuf);
            strcat(sParsed.date,"-");
            sprintf((char *) cBuf,strtok(NULL,":"));
            strcat(sParsed.date,cBuf);
        
//            printf("Date: %s\n",sParsed.date);

            strcpy(sParsed.time,strtok(NULL,":"));
            strcat(sParsed.time,":");
            strcat(sParsed.time,strtok(NULL,":"));
            strcat(sParsed.time,":");
            strcat(sParsed.time,strtok(NULL,"\n"));
        
//            printf("Time: %s\n",sParsed.time);
        
            strcpy(sParsed.actual,sLine.actual);
            strcpy(sParsed.normalized,sLine.normalized);

            // Make sure this record isn't already in the database.
            strcpy(command,"select id from export where date='");
            strcat(command,sParsed.date);
            strcat(command,"' and time='");
            strcat(command,sParsed.time);
            strcat(command,"' and meas='");
            strcat(command,sParsed.measurement);

            if(!strcmp(sParsed.measurement,"002") \
              || !strcmp(sParsed.measurement,"003") \
              || !strcmp(sParsed.measurement,"004")) {
              
              strcat(command,"' and dpc='");
              strcat(command,sParsed.dpc);

            } else {

              strcat(command,"' and opc='");
              strcat(command,sParsed.opc);
              strcat(command,"' and dpc='");
              strcat(command,sParsed.dpc);
              strcat(command,"' and slc='");
              strcat(command,sParsed.slc);
            }
            strcat(command,"';");

            result = PQexec(tm2,command);            
        
//            printf("Tuples: %0d\n",PQntuples(result));

            if (PQntuples(result) < 1) {
              PQclear(result);
          
              strcat(commands,"insert into export (app,meas,opc,slc,dpc,date,time,type,actual,normalized) values ('");
              strcat(commands,sParsed.app);
              strcat(commands,"','");
              strcat(commands,sParsed.measurement);
              strcat(commands,"','");
              if(!strcmp(sParsed.measurement,"004")) {
                strcat(commands,sParsed.dpc);
                strcat(commands,"','");
                strcat(commands,sParsed.slc);
                strcat(commands,"','");
                strcat(commands,sParsed.opc);
                strcat(commands,"','");
              } else {
                strcat(commands,sParsed.opc);
                strcat(commands,"','");              
                strcat(commands,sParsed.slc);
                strcat(commands,"','");
                strcat(commands,sParsed.dpc);
                strcat(commands,"','");
              }
              strcat(commands,sParsed.date);
              strcat(commands,"','");
              strcat(commands,sParsed.time);
              strcat(commands,"','");
              strcat(commands,sParsed.type);
              strcat(commands,"','");
              strcat(commands,sParsed.actual);
              strcat(commands,"','");
              strcat(commands,sParsed.normalized);
              strcat(commands,"');");
          
//              printf("Length: %0d\tCommand: %s\n",strlen(commands),commands);

            } else {
              printf("\n\tRecord already exists: %s - %s %s %s %s\n",filename,sParsed.opc,sParsed.date,sParsed.time,sParsed.actual);
            }
            
            if (nTimes > 1000) {
              printf(" Committing %0d records...",nTimes);
              fflush(stdout);
              result = PQexec(tm2,commands);
              strcpy(commands,"");
              PQclear(result);
              nTimes = 0;
            } else {
              nTimes++;
            }
          }        
        }
  
        gzclose(hFile);

        // Add filename to list of files already in DB.
        timer = time(NULL);
        strftime(cTime,sizeof(cTime),"%H:%M:%S",localtime(&timer));
        strftime(cDate,sizeof(cDate),"%Y-%m-%d",localtime(&timer));

        strcpy(command,"insert into files (filename,date_loaded,time_loaded) values ('");
        strcat(command,filename);
        strcat(command,"','");
        strcat(command,cDate);
        strcat(command,"','");
        strcat(command,cTime);
        strcat(command,"');");
        result = PQexec(tm2,command);
        PQclear(result);
        strcpy(command,"");

        printf(" Added.\n");
      } else {        
        PQclear(result);
        printf(" Already in DB.\n");
      }
    }  
  }

  if (strlen(commands) > 0) {
            printf("Committing final records...\n");
            result = PQexec(tm2,commands);
            strcpy(commands,"");
            PQclear(result);  
  }
  
  closedir(dirp);

//  result = PQexec(tm2,"select opc from export;");

//  printf("Tuples: %0d\n",PQntuples(result));

//  for (n = 0; n < PQntuples(result); n++) {

//    printf("%s\n",(char *) PQgetvalue(result,n,0));
  
//  }

  timer = time(NULL);
  strftime(cFinishTime,sizeof(cFinishTime),"%H:%M:%S",localtime(&timer));
  
  log = PQconnectdb("hostaddr=172.20.206.55 dbname=log user=postgres password=pgauthall");      
  if (!PQstatus(log)) {
    strcpy(command,"insert into dbupdate (date,time,program,finish) values ('");
    strcat(command,cStartDate);
    strcpy(command,"','");
    strcat(command,cStartTime);
    strcat(command,"','TM Load Measurements - Connection to TM DB failed!','");
    strcat(command,cFinishTime);
    strcat(command,"');");

    result = PQexec(log,command);
    PQclear(result);
  } else {
    strcpy(command,"insert into dbupdate (date,time,program,finish) values ('");
    strcat(command,cStartDate);
    strcpy(command,"','");
    strcat(command,cStartTime);
    strcat(command,"','TM Load Measurements - ','");
    strcat(command,cFinishTime);
    strcat(command,"');");

    result = PQexec(log,command);
    PQclear(result);  
  }

  PQclear(result);
  PQfinish(log);
  PQfinish(tm2);

  printf("Done!\n");
  
  exit(0);
}

