#!/usr/contrib/bin/perl

# ni.pl - Get NI Measurement data
# 12-05-01 by Jon Bieker
# (c)2001 Sprint

$group_name = "PCS Link Uptime";

@month[0] = "Jan";
@month[1] = "Feb";
@month[2] = "Mar";
@month[3] = "Apr";
@month[4] = "May";
@month[5] = "Jun";
@month[6] = "Jul";
@month[7] = "Aug";
@month[8] = "Sep";
@month[9] = "Oct";
@month[10] = "Nov";
@month[11] = "Dec";

# Print blurb
print "ni.pl - Get NI Measurement Data\n";
print "12-05-01 by Jon Bieker\n";
print "(c)2001 Sprint\n\n";

# Get measurements
print "Getting measurement list...\n";
system("/home/a7users/ss7gjobi/bin/uselog ni " . @ARGV[0]);
@measurements = `measlist -host m7server`;
$meas = @measurements;

($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$dst) = localtime(time);
$year += 1900;

$argc = @ARGV;

if ($argc > 0) {
  ($xmon,$xday,$xyear) = split(/[-|\/]/,@ARGV[0]);
  if (length($xyear) < 4) {
    $xyear = "20" . $xyear;
  }
} else {
  $xmon = $mon + 1;
  $xday = $mday;
  $xyear = $year;
}

$filename = "/opt/cronjobs/bin/ni/ni_" . sprintf("%0.2d",$xday) . "_" . @month[$xmon - 1] . "_" . sprintf("%0.2d",$xyear) . ".dat";

open(hFile,">" . $filename);

$nK = 0;
for ($nI = 0; $nI < $meas; $nI++) {
  chop @measurements[$nI];
  
  ($meas_id,$owner,$group,$tag,$title,$status) = split(/,/,@measurements[$nI]);

  if ($group eq $group_name) {  
    print "Collecting data for measurement: $meas_id - $tag\n";
    
    @sdx = `sdx -id $meas_id -noni -linkFormat -showDate -out - -host m7server -time 22:15 -date 01/12/2001`;
    $sdx = @sdx;
    
    for ($nJ = 0; $nJ < $sdx; $nJ++) {
      chop @sdx[$nJ];
      ($sdx_id,$status,$pc,$date,$data) = split(/\|/,@sdx[$nJ]);
      ($xopc,$xslc,$xdpc) = split(/ /,$pc);
      $xslc =~ s/[<|>]//g;
      ($date,$time) = split(/ /,$date);
      ($day,$month,$year) = split(/\//,$date);
      $year = "20" . $year;
      
      $opc = int($xopc/65536) . "-" . int($xopc/256) % 256 . "-" . $xopc % 256;
      $dpc = int($xdpc/65536) . "-" . int($xdpc/256) % 256 . "-" . $xdpc % 256;

      $xdate = sprintf("%0.2d",$xday) . "/" . @month[$xmon - 1] . "/" . substr($xyear,2,2);

    
      if ($xdate eq $date) {
      
        print "$date\t$opc <$xslc> $dpc\t$data\n";
      
        print hFile "$date\t$sdx_id\t$opc <$xslc> $dpc\t$data\n";
      } else {
        print "Xdate: $xdate\tDate: $date\n";
      }

    }
  }
}

close(hFile);

print "Checking for overloaded IFPC's...\n";
for ($nI = 1; $nI < 9; $nI++) {
  print "\tChecking ";
  if ($nI == 1) {
    print "Rialto\n";
  } elsif ($nI == 2) {
    print "Stockton\n";
  } elsif ($nI == 3) {
    print "Chicago\n";
  } elsif ($nI == 4) {
    print "Ft. Worth\n";
  } elsif ($nI == 5) {
    print "Atlanta\n";
  } elsif ($nI == 6) {
    print "Nashville\n";
  } elsif ($nI == 7) {
    print "Akron\n";
  } elsif ($nI == 8) {
    print "New York\n";
  }
  
  $cSite = "m" . sprintf("%0.3d",$nI);
  
  @aLog = `remsh $cSite grep suspended /var/adm/syslog/syslog.log`;
  $aLog = @aLog;
  for ($nJ = 0; $nJ < $aLog; $nJ++) {
    chop @aLog[$nJ];
    print "\t\t" . @aLog[$nJ] . "\n";
  }
  @aLog = `remsh $cSite grep resumed /var/adm/syslog/syslog.log`;
  $aLog = @aLog;
  for ($nJ = 0; $nJ < $aLog; $nJ++) {
    chop @aLog[$nJ];
    print "\t\t" . @aLog[$nJ] . "\n";
  }
    
  print "\tChecking ";
  if ($nI == 1) {
    print "Rialto subordinate processor...\n";
  } elsif ($nI == 2) {
    print "Stockton subordinate processor...\n";
  } elsif ($nI == 3) {
    print "Chicago subordinate processor...\n";
  } elsif ($nI == 4) {
    print "Ft. Worth subordinate processor...\n";
  } elsif ($nI == 5) {
    print "Atlanta subordinate processor...\n";
  } elsif ($nI == 6) {
    print "Nashville subordinate processor...\n";
  } elsif ($nI == 7) {
    print "Akron subordinate processor...\n";
  } elsif ($nI == 8) {
    print "New York subordinate processor...\n";
  }

  $cSite = "m" . sprintf("%0.3d",$nI + 100);
  
  @aLog = `remsh $cSite grep suspended /var/adm/syslog/syslog.log`;
  @aLog = `remsh $cSite grep resumed /var/adm/syslog/syslog.log`;
  $aLog = @aLog;
  for ($nJ = 0; $nJ < $aLog; $nJ++) {
    chop @aLog[$nJ];
    print "\t\t" . @aLog[$nJ] . "\n";
  }
  @aLog = `remsh $cSite grep resumed /var/adm/syslog/syslog.log`;
  $aLog = @aLog;
  for ($nJ = 0; $nJ < $aLog; $nJ++) {
    chop @aLog[$nJ];
    print "\t\t" . @aLog[$nJ] . "\n";
  }

}

