#include <Xm/PushB.h>
#include <Xm/Form.h>
#include <Xm/Xm.h>
#include <Xm/MainW.h>
#include <Xm/CascadeB.h>
#include <Xm/MessageB.h>

Widget toplevel, main_win, form;

main (int argc, char *argv[])
{
  Widget menu_bar, file_menu, help_menu;
  Widget btnSave, btnCommit, btnQuit;
  XmString quit_m,file_m,save_m,help_m,about_m;
  XtAppContext app; 

  /* Function decl's */
  void help_call();
  void save_call();
  void quit_call();
  void file_call();
  void help_about_popup();

  XtSetLanguageProc (NULL, NULL, NULL);
  toplevel = XtVaOpenApplication (&app, "Linktool", NULL, 0, &argc, argv, 
  	NULL, sessionShellWidgetClass, NULL);

  main_win = XtVaCreateManagedWidget("main_window",xmMainWindowWidgetClass,
  	toplevel,XmNwidth,300,XmNheight,300,NULL);

  /* Create form */
  form = XmCreateForm (main_win,"form",NULL,0);
  XtManageChild (form);
  
  quit_m = XmStringCreateSimple("Quit");
  file_m = XmStringCreateSimple("File");
  save_m = XmStringCreateSimple("Save");
  help_m = XmStringCreateSimple("Help");
  about_m = XmStringCreateSimple("About");

  /* Create controls */
  menu_bar = XmVaCreateSimpleMenuBar(main_win,"main_list",
  	XmVaCASCADEBUTTON, file_m, 'F',
  	XmVaCASCADEBUTTON, help_m, 'H',
  	NULL,0);
  
  file_menu = XmVaCreateSimplePulldownMenu(menu_bar,"file_menu",0,file_call,
  	XmVaPUSHBUTTON,save_m,'S',NULL,NULL,
  	XmVaPUSHBUTTON,quit_m,'Q',NULL,NULL,
  	NULL);

  help_menu = XmVaCreateSimplePulldownMenu(menu_bar,"help_menu",1,help_call,
  	XmVaPUSHBUTTON,about_m,'A',NULL,NULL,
  	NULL);

  XmStringFree(quit_m);
  XmStringFree(file_m);
  XmStringFree(save_m);
  XmStringFree(help_m);
  

  /* Layout controls */
  XtVaSetValues(menu_bar,XmNtopAttachment,XmATTACH_FORM,XmNleftAttachment,XmATTACH_FORM,XmNrightAttachment,XmATTACH_FORM,NULL);

  /* Manage widgets */
  XtManageChild (menu_bar);
        
  /* Realize widgets */
  XtRealizeWidget (toplevel);

  /* Start the message loop */
  XtAppMainLoop (app);

}

void file_call (w, item) 
Widget w;
int item;
{
 
  switch (item) {
    case 0:
      printf("Saving...\n");
      break;
    case 1:
      printf("Exiting...\n");
      exit(0);
      break;
    default:
      break; 
  }
}


void help_call (w, item) 
Widget w;
int item;
{
  extern Widget toplevel;
  Widget dialog;
  Arg arg[5];
  XmString about_message;
  int n = 0;

  switch (item) {
    case 0:

      about_message = XmStringCreateLocalized("About Linktool\n\n8-8-02 by Jon Bieker\n(c)2002 Sprint - All Rights Reserved");
      XtSetArg (arg[n],XmNmessageString,about_message); n++;
      dialog = XmCreateMessageDialog(toplevel,"About",arg,1);
      XmStringFree (about_message);
      XtUnmanageChild (XtNameToWidget (dialog, "Help"));
      XtUnmanageChild (XtNameToWidget (dialog, "Cancel"));
      
      XtManageChild(dialog);

      break;
    default:
      break; 
  }
}
