#!/opt/perl5/bin/perl 

# Fix CLLI codes
# 12-03-01 by Jon Bieker

$EXCEPTION_FILE = "stp_CLLI.txt";
$ETRFILE = "etrfile.etr";
$ETRNEW = "etrfile.new";

# Load exception file into an array
if (-f $EXCEPTION_FILE) {
	open(hSTP,$EXCEPTION_FILE) || die ("Couldn't open $EXCEPTION_FILE!\n");
} else {
	die ("$EXCEPTION_FILE doesn't exist!\n");
}

$nErrors = 0;
while (<hSTP>) {
	chop $_;
	$stp[$nErrors] = $_;
	$nErrors++;
}

close (hSTP); 

system("/home/a7users/ss7gjobi/bin/uselog fix_CLLI");

# Strip the extra stuff out...
for ($nJ = 0; $nJ < $nErrors; $nJ++) {
	$stp[$nJ] =~ s/\t/ /g;	
	$stp[$nJ] =~ s/ - / /g;
	$stp[$nJ] =~ s/[<|>]//g;
	$stp[$nJ] =~ s/Remote end CLLI is//g;
	$stp[$nJ] =~ s/in AcceSS7 and should be//g;
	$stp[$nJ] =~ s/["|".]//g;
	$stp[$nJ] =~ s/\s+/ /g;
}
 
# Open ETR files
if (-f $ETRFILE) {
	open(hEtr,$ETRFILE) || die ("Couldn't open $ETRFILE!\n");
} else {
	die ("$ETRFILE doesn't exist!\n");
}

if (-f $ETRNEW) {
	print "$ETRNEW already exists!  Do you want to overwrite it? [y/N] ";
	$resp = <STDIN>;
	
	if (substr($resp,0,1) ne "y") {
		close (hEtr);
		exit(1);
	}
}

open(hNew,">$ETRNEW") || die ("Couldn't create $ETRNEW!\n");

$line = "";
while (!eof(hEtr)) {

	# Find linksets
	while ($line ne "[linkset]" && !eof(hEtr)) {
		$line = <hEtr>;
		chop $line;
		print hNew "$line\n";
	}
	
	$line = <hEtr>;
	chop $line;	
	print hNew "$line\n";	
	
	($opc,$dpc,$linktype,$normalization,$linkset) = split(/ /,$line);
	
	# Fix formatting
	if (substr($opc,0,3) eq "IN:") {
		($intl,$opc) = split(/:/,$opc);
		($one,$two,$three) = split(/-/,$opc);
		$opc = "IN:" . sprintf("%0.3d",$one) . "-" . sprintf("%0.3d",$two) . "-" . sprintf("%0.3d",$three);
	} else {
		($one,$two,$three) = split(/-/,$opc);
		$opc = sprintf("%0.3d",$one) . "-" . sprintf("%0.3d",$two) . "-" . sprintf("%0.3d",$three);
	}
	if (substr($dpc,0,3) eq "IN:") {
		($intl,$dpc) = split(/:/,$dpc);
		($one,$two,$three) = split(/-/,$dpc);
		$dpc = "IN:" . sprintf("%0.3d",$one) . "-" . sprintf("%0.3d",$two) . "-" . sprintf("%0.3d",$three);
	} else {
		($one,$two,$three) = split(/-/,$dpc);
		$dpc = sprintf("%0.3d",$one) . "-" . sprintf("%0.3d",$two) . "-" . sprintf("%0.3d",$three);
	}
	
	for ($nI = 0; $nI < $nErrors; $nI++) {
		($switch_name,$xopc,$xslc,$xdpc,$a7_clli,$stp_clli) = split(/ /,$stp[$nI]);
		
		if (($xopc eq $opc) && ($xdpc eq $dpc)) {
		
			$lNewLinkset = 0;
			while (!$lNewLinkset && !eof(hEtr)) {
			
				$line = <hEtr>;
				chop $line;
				print hNew "$line\n";
								
				if ($line eq "[linkset]") {
					$lNewLinkset = 1;
				} elsif ($line eq "[link]") {
			
					$line_1 = <hEtr>;
					chop $line_1;
				
					$line_2 = <hEtr>;
					chop $line_2;
				
					$line = $line_1 . $line_2;
					$line =~ s/\\//g;
					$line =~ s/\s+/ /g;
				
					@aline = split(/ /,$line);
				
					if ($aline[0] eq $xslc) {
						($site,$clli) = split(/-/,$aline[3]);
						($clli,$slc) = split(/\//,$clli);
				
						print "$switch_name $xopc<$xslc>$xdpc is $clli and should be $stp_clli. Change it? ";
						$resp = <stdin>;
					
						if (substr($resp,0,1) eq "y") {
					
							print "Old Line: $line_1\n";
					
							$line_1 =~ s/$clli/$stp_clli/g;
						
							print "New Line: $line_1\n\n";
					
						}					
					}
					print hNew "$line_1\n$line_2\n";
				}
			}
		}
	}	
}

close (hNew);
close (hEtr);

