#!/opt/perl5/bin/perl

# Change ifpclinkmonitoring on all international links
# 8-14-01 by Jon Bieker

$ETRFILE = "etrfile.etr";
$ETRNEW = "etrfile.new";

if (-f $ETRFILE) {
	open(hEtr,$ETRFILE) || die ("Couldn't open $ETRFILE!\n");
} else {
	die ("$ETRFILE doesn't exist!\n");
}

if (-f $ETRNEW) {
	print "$ETRNEW already exists!  Do you want to overwrite it? [y/N] ";
	$resp = <STDIN>;
	
	if (substr($resp,0,1) ne "y") {
		close (hEtr);
		exit(1);
	}
}

open(hNew,">$ETRNEW") || die ("Couldn't create $ETRNEW!\n");


$intllinks = 0;
$intllinksets = 0;
while (!eof(hEtr)) {

	# Find linksets
	while ($line ne "[linkset]" && !eof(hEtr)) {
		$line = <hEtr>;
		chop $line;
		print hNew "$line\n";
	}
	
	$line = <hEtr>;
	chop $line;	
	print hNew "$line\n";	
	
	# Determine if it's international
#	if (substr($line,0,3) eq "IN:") {

	# Find NYC093, STK_IDMS, and FTW_IDMS links
	($mon,$rem,$junk) = split(/ /,$line);
	if (	$rem eq "IN:3-23-4;ITU383"
		|| $rem eq "IN:3-23-6;ITU383"
		|| $rem eq "IN:3-24-4;ITU383" ) {
		
		$linkset = $line;
		$lExit = 0;
		$lSectionExists = 0;
		while (!$lExit) {
	
			# find the [ifpclinkmonitoring] sections
			while ($line ne "[ifpclinkmonitoring]" && $line ne "[linkset]" && !eof(hEtr)) {
				$line = <hEtr>;
				chop $line;
				print hNew "$line\n";
			}
		
			# Rewrite [ifpclinkmonitoring] section...
			if ($line eq "[ifpclinkmonitoring]") {
		
				# Get the IFPC slot number
				$line = <hEtr>;
				($app,$ifpc,$links) = split(" ",$line);

				# Skip past the existing applications...
				while (length($line) > 0) {
					$line = <hEtr>;
					chop $line;
				}

				# ... and write new ones.
				print hNew "CT $ifpc FULL\n";
				print hNew "PA $ifpc FULL\n";
				print hNew "TM $ifpc FULL\n";
				print hNew "Stats $ifpc FULL\n";
				print hNew "p7ctf $ifpc FULL\n\n";
			
				$intllinks++;				
				$lSectionExists = 1;
				
			} elsif ($line eq "[linkset]" || $line eq "[sites]") {
				$lExit = 1;
				if (!$lSectionExists) {
					print "$linkset is misconfigured!\n";
				}				
			} elsif ($line eq "[link]") {
				if (!$lSectionExists) {
					print "$linkset is misconfigured!\n";
				}
			}
		}
		$intllinksets++;
	}
}

close (hNew);
close (hEtr);

print "$intllinksets international linksets.\n";
print "$intllinks links changed.\n";

